#ifndef INCL_GROUP_H
#define INCL_GROUP_H

// *-----------------------------------------------------------------------
// * Xclasses class header file
// * 
// * class name: group
// * author    : Jrgen Schmitz
// * version   : 1.0
// *-----------------------------------------------------------------------

#include <Xclasses/types.h>
#include <Xclasses/gadget.h>
#include <Xclasses/Xcolors.h>

class group : public gadget 
{
	friend class pgroup;

	class pgroup *p;

protected:
	int realwidth;
	int realheight;

	int borderleft;
	int borderright;
	int bordertop;
	int borderbottom;	

public:
	virtual char *Class(void);

// function to overload in child classes
	virtual void BorderLimits(void);
	virtual void GExpose(XEvent *);

    virtual void GSetLimits(void);	// SetSize
	int minWidth(void); // Group limits (same as gg_minwidth(), etc !)
	int maxWidth(void);
	int minHeight(void);
	int maxHeight(void);

	group(void);
	virtual ~group(void);

	group  &Add(class gadget &gd);			// returns always gd
	group  *Add(class gadget *gd);			// returns always gd
	group  &Add(class gadget &gd,char *);	// returns always gd
	group  *Add(class gadget *gd,char *);	// returns always gd
	virtual group  *Add(void);				// 0 for error

	group &AddShadow(class group &gr);
	group *AddShadow(class group *gr);

    virtual void Dimensions(Window gparent,int gx,int gy,int gheight,int gwidth);
	virtual int Create(void);
    virtual Window Create(Window root,int x,int y,int width,int height); // create groups, add to parent with given dimensions
    virtual Window Create(Window root);                                  // create groups, add to parent with its dimensions
    virtual Window Create(Window root,int top,int bottom);               // create groups, add to parent with its dimensions, with y=top
    virtual void Free(void);                                     // close group window
    															 // incl. subwindows, groups, gadgets!
    															 // clears add list!
    virtual void Resize(int x,int y,int width,int height);       // resize to dimensions
    virtual void Resize(int width,int height);
    virtual void Resize(Window root);                            // resize to dimensions of parent
    virtual void Resize(Window root,int top,int bottom);         // resize to dimensions of parent, with y=top

	virtual void Lock(void);
	virtual void Unlock(void);
    virtual void Block(int);
    virtual void Unblock(int);

	void Show(void);
	void Background(unsigned long col);
	void Background(char *name);
	void Background(unsigned short r,unsigned short g,unsigned short b);
	
	void Horiz(void);
	void Vert(void);		// Default
	int  Direction(void);	// 0: Vert, 1: Horiz

	void DialogMode(void);
	void Center(void);
	void Right(void);
	void UseSmallest(void);
	void SameSize(group *);
	void SameSize(group &g) { SameSize(&g); };
	
	void XDistance(int d);
	void YDistance(int d);
	
	int AutoWeight(void);
};

#endif
