#ifndef INCL_DLIST_H
#define INCL_DLIST_H

// *-----------------------------------------------------------------------
// * Xclasses class header file
// * 
// * class name: dlist
// * author    : Jrgen Schmitz
// * version   : 1.0
// *-----------------------------------------------------------------------

#include <Xclasses/types.h>

struct node
{
	struct node *next;
	struct node *prev;
	int			number;
	char        *text;
};

class dlist
{
	int			numbered:1,
				free:1;
	struct node *last_node;
	int			last_number;
	int			count;

public:
	struct node *head;
	struct node *terminator;
	struct node *tail;

	dlist();
	~dlist();
	
	void AddHead(struct node *);
	void AddTail(struct node *);
	void Insert(struct node *,struct node *before);
	void AddAlpha(struct node *);
	
	struct node *RemHead(void);
	struct node *RemTail(void);
	void Remove(struct node*);

	int Find(struct node*);
	struct node *Find(int);
	struct node *FindText(char *text,struct node *start);
	struct node *FindTextNC(char *text,struct node *start); // nocase
	
	int Count(void);

	int IsEmpty(void);
	int IsMember(struct node*);

	void Sort(int (*func)(struct node*,struct node*));
};

#endif
