#ifndef INCL_APPWINDOW_H
#define INCL_APPWINDOW_H

// *-----------------------------------------------------------------------
// * Xclasses class header file
// * 
// * class name: appwindow
// * author    : Jrgen Schmitz
// * version   : 1.0
// *-----------------------------------------------------------------------

#include <Xclasses/types.h>
#include <Xclasses/Xwindows.h>
#include <Xclasses/Xcolors.h>
#include <Xclasses/group.h>
#include <Xclasses/menu.h>
#include <Xclasses/gfx_object.h>

#define EV_NOTHING		0
#define EV_GADGET		1
#define EV_WINDOWCLOSE	2
#define EV_TICK			3
#define EV_FINISH		4
#define EV_WAKEUP		5

class appwindow : public Xwindows
{
	friend class pappwindow;

	class pappwindow *p;	

public:

	appwindow(void);
	appwindow(char *);
	virtual ~appwindow(void);

	void InitSize(int x,int y,int w,int h);
	void InitSize(int x,int y,int p);
	void InitSize(int p);
	int Init(int &argc,char *argv[]);
	int Init(int &argc,char *argv[],char *basecolor);
	int Init(void);

	void Adjust(int x,int y,int w,int h, int a=ADJUST_CENTER|ADJUST_MIDDLE);

	int  Create(void);
	void Close(void);
	
	void SetGroup(group *);
	void SetGroup(group &);
	void SetExtraGroup(group *);
	void SetExtraGroup(group &);
	void ExtraRight(void);
	void ExtraBottom(void);	// default
	void SetMenu(menu *);
	void SetMenu(menu &);
	void Callback(void cfunc(appwindow *));
	void Callback(void *c,void cfunc(appwindow *));
	void Callback(void *c, ...);
	void Callback(void);	// calls Close()

	void Block(int b=0);
	void Unblock(int b=0);
	void BlockExcept(int b=0);
	void UnblockExcept(int b=0);

	void ShowExtra(void);
	void HideExtra(void);

	int HandleEvent(XEvent *event);

	int CloseMe(void);

	static int NextEvent(void);
	static int UpdateEvent(void);
	static int TickEvent(void);

	static int DoubleClick(void);
	static int ID(void);

	static void CloseAll(void);
	static void WakeUp(void);
};

#endif
