#include <string.h>
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/stat.h>

#include <Xclasses/Xclasses.h>
#include "maillist.h"

XCprogram	myprg("xmaillist",
					XCP_Version,"0.9",
					XCP_Copyright,"(c) by Jrgen Schmitz 1996",
					XCP_Author,"Jrgen Schmitz",
					XCP_EMail,"schmitzj@fsai.fh-trier.de",
					XCP_Done);

appwindow mywin;
menu mymenu;
group maingp,top,bottom;
bordergroup gr_global,gr_lists,gr_cleft,gr_cright;
button save,end;
listview alllists,user;
input listdirin,helpdirin,cmdnamein,mailaddressin,logfilein;

fbutton add_list,del_list;
input list_name,list_desc;
fbutton add_user,del_user;
input user_name;

config cfg(CFGFILE);


char *list_path(void)
{
	static char p[300];
	int s=alllists.Selected();
	char *gn=lists[s-1];

	strcpy(p,listdir);
	if (p[strlen(p)-1]!='/') strcat(p,"/");
	strcat(p,gn);
	strcat(p,"/");
	return p;
}

void new_list(int c)
{
	char *p=list_path();
	FILE *file;
	char buf[400];

	strcpy(buf,p);
	buf[strlen(buf)-1]=0;

	if (!mkdir(buf,S_IRWXU|S_IRGRP|S_IXGRP))
	{
		strcpy(buf,p);
		strcat(buf,DESCNAME);
		if (file=fopen(buf,"w"))
		{
			fprintf(file,"new group\n");
			fclose(file);
		}	
		strcpy(buf,p);
		strcat(buf,READERS);
		if (file=fopen(buf,"w"))
		{
			fprintf(file,"");
			fclose(file);
		}
	}
}
void list_select(void)
{
	FILE *file;
	char *p=list_path();
	char buf[400],lne[80],*l;
	int s=alllists.Selected();

	del_list.Unlock();
	list_desc.Unlock();
	add_user.Unlock();
	mymenu.UnlockItem(1,2);

	list_name.Default(lists[s-1]);
	strcpy(buf,p);
	strcat(buf,DESCNAME);
	if (file=fopen(buf,"r"))
	{
		if (fgets(lne,sizeof(lne),file))
			list_desc.Default(lne);		
		fclose(file);
	}
	for(int i=1;i<=user.Count();i++)
	{
		l=(char*)user.GetData(i);
		if (l) delete l;
	}
	user.RemoveAll();
	strcpy(buf,p);
	strcat(buf,READERS);
	if (file=fopen(buf,"r"))
	{
		while (!feof(file))
		{
			if (fgets(lne,sizeof(lne),file))
			{
				if (lne[strlen(lne)-1]=='\n') lne[strlen(lne)-1]=0;
				l=new char[strlen(lne)+1];
				strcpy(l,lne);
				user.AddAtEnd(lne,l);
			}
		}
		fclose(file);
	}	
}
void remove_list(void)
{
	int s=alllists.Selected();
	lists[s-1][0]=0;
	for(int i=s;i<MAXLISTS;i++)
	{
		lists[i-1]=lists[i];
	}
	alllists.Remove(s);
}
void change_desc(void)
{
	char *p=list_path();
	FILE *file;
	char buf[400];

	strcpy(buf,p);
	strcat(buf,DESCNAME);
	if (file=fopen(buf,"w"))
	{
		list_desc.Input(buf);
		fprintf(file,"%s\n",buf);
		fclose(file);
	}	
}
void write_user(void)
{
	char *p=list_path();
	char buf[400];
	FILE *file;

	strcpy(buf,p);
	strcat(buf,READERS);
	if (file=fopen(buf,"w"))
	{
		for(int i=0;i<user.Count();i++)
		{
			fprintf(file,"%s\n",user.GetData(i+1));
		}
		fclose(file);
	}
}
void remove_user(void)
{
	user.Remove(user.Selected());
	write_user();
}
void new_user(void)
{
	char buf[80],*l;
	user_name.Input(buf);
	if (strlen(buf)>0)
	{
		l=new char[strlen(buf)+1];
		strcpy(l,buf);
		user.AddAtEnd(buf,l);
		write_user();
	}
	user.Selected(user.Count());
}

int main(int argc,char *argv[])
{
	int pende=0,r;
	mywin.InitSize(0,0,30);
	if (!mywin.Init(argc,argv))
	{
		printf("Error: Can't open display\n\n");
		exit(1);
	}
	cfg.SetItems(cfg_o);
	cfg.Read();

	top.Horiz();
	 gr_global.Title("Global settings");
	 gr_global.Vert();
	 gr_global.Weight(50);
	  listdirin.Text("lists directory");
	  listdirin.MaxChars(sizeof(listdir));
	  listdirin.Default(listdir);
	  listdirin.HelpText("directory of lists");
	 gr_global.Add(listdirin);
	  helpdirin.Text("help files");
	  helpdirin.MaxChars(sizeof(helpdir));
	  helpdirin.Default(helpdir);
	  helpdirin.HelpText("directory of help text files");
	 gr_global.Add(helpdirin);
	  cmdnamein.Text("mail name");
	  cmdnamein.MaxChars(sizeof(cmdname));
	  cmdnamein.Default(cmdname);
	  cmdnamein.HelpText("EMail name of control address\nwithout host address\ne.g. maillist");
	 gr_global.Add(cmdnamein);
	  mailaddressin.Text("mail address");
	  mailaddressin.MaxChars(sizeof(mailaddress));
	  mailaddressin.Default(mailaddress);
	  mailaddressin.HelpText("EMail address of host\n(e.g. foobar.de)");
	 gr_global.Add(mailaddressin);
	  logfilein.Text("logfile");
	  logfilein.MaxChars(sizeof(logfile));
	  logfilein.Default(logfile);
	  logfilein.HelpText("Name of logfile,\ne.g. /tmp/maillist.log");
	 gr_global.Add(logfilein);

	top.Add(gr_global);
	 gr_lists.Horiz();
	 gr_lists.Title("Lists");
	  gr_cleft.Vert();
	  gr_cleft.Title("list manager");
	   alllists.ShowSelected();
	   alllists.ID(100);
	  gr_cleft.Add(alllists);
	   del_list.Text("Remove");
	   del_list.ID(101);
	   del_list.Weight(10);
	  gr_cleft.Add(del_list);
	   add_list.Text("Add");
	   add_list.ID(102);
	   add_list.Weight(10);
	  gr_cleft.Add(add_list);
	   list_name.Text("Name");
	   list_name.MaxChars(sizeof(lists[0]));
	  gr_cleft.Add(list_name);
	   list_desc.Text("Description");
	   list_desc.MaxChars(80);
	   list_desc.ID(103);
	  gr_cleft.Add(list_desc);

	 gr_lists.Add(gr_cleft);	   
	  gr_cright.Vert();
	  gr_cright.Title("list user manager");
	   user.ShowSelected();
	   user.ID(200);
	  gr_cright.Add(user);
	   del_user.Text("Remove");
	   del_user.ID(201);
	   del_user.Weight(10);
	  gr_cright.Add(del_user);
	   add_user.Text("Add");
	   add_user.ID(202);
	   add_user.Weight(10);
	  gr_cright.Add(add_user);
	   user_name.Text("EMail");
	   user_name.MaxChars(80);
	  gr_cright.Add(user_name);

	 gr_lists.Add(gr_cright);
	top.Add(gr_lists);
	bottom.Horiz();
	bottom.DialogMode();
	 save.ID(3);
	 save.Text("Save");
	bottom.Add(save);
	 end.ID(2);
	 end.Text("Quit");
	bottom.Add(end);
	maingp.Add(top);
	ruler rl;
	rl.Space(4);
	maingp.Add(rl);
	maingp.Add(bottom);
	maingp.Vert();

	mymenu.NoHelpMenu(REASON_SUID,NULL);
	mymenu.AddMenu("Program");
	mymenu.Add("Maintenance list",2);
	mymenu.AddRuler();
	mymenu.Add("Quit",1);
	mymenu.ID(1);
	mywin.SetGroup(maingp);
	mywin.SetMenu(mymenu);
	mywin.Create();

	for(int i=0;i<MAXLISTS;i++)
	{
		if (strlen(lists[i])) alllists.AddAtEnd(lists[i]);
	}
	if (alllists.Count()>=MAXLISTS) add_list.Lock();
	del_list.Lock();
	list_desc.Lock();
	add_user.Lock();
	del_user.Lock();
	mymenu.LockItem(1,2);
	while (!pende)
	{
		r=mywin.NextEvent();
		if (r==EV_WINDOWCLOSE)
		{
			if (mywin.CloseMe()) pende=1;
		}
		else if (r==EV_GADGET)
		{
			switch (mywin.ID())
			{
				case 1: // Menu
					switch (mymenu.Selection())
					{
						case 0x01000002: // maint
							break;
						case 0x01000001:
							pende=1;
							break;
					}
					break;
				case 2:
					pende=1;
					break;
				case 3:
					listdirin.Input(listdir);
					helpdirin.Input(helpdir);
					cmdnamein.Input(cmdname);
					mailaddressin.Input(mailaddress);
					logfilein.Input(logfile);
					cfg.Write();
					break;
				case 100: // list
					list_select();
					break;
				case 101: // del
					remove_list();
					del_list.Lock();
					list_desc.Lock();
					add_user.Lock();
					del_user.Lock();
					mymenu.LockItem(1,2);
					if (alllists.Count()<MAXLISTS) add_list.Unlock();
					cfg.Write();
					break;
				case 102: // add
					{
						int c=alllists.Count(),g=0;
						list_name.Input(lists[c]);
						if (strlen(lists[c]))
						{
							for(int i=0;i<c;i++)
							{
								if (!strcasecmp(lists[i],lists[c])) g=1;
							}
							if (g)
							{
								lists[c][0]=0;
							}
							else
							{
								lists_c=c+1;
								alllists.AddAtEnd(lists[c],lists[c]);
								alllists.Selected(c+1);
								new_list(c);
								list_select();
								cfg.Write();
							}
						}
					}
					if (alllists.Count()>=MAXLISTS) add_list.Lock();
					break;
				case 103: // desc
					change_desc();
					break;
				case 200: // user
					del_user.Unlock();
					user_name.Default((char*)user.GetData(user.Selected()));
					break;
				case 201: // del
					remove_user();
					del_user.Lock();
					break;
				case 202: // add
					new_user();
					if (user.Selected())
					{
						del_user.Unlock();
						user_name.Default((char*)user.GetData(user.Selected()));
					}
					break;
			}
		}
	}
	mywin.Close();
	cfg.Write();
}
