#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <ctype.h>
#include <time.h>
#include <sys/utsname.h>
#include <Xclasses/config.h>

#include "maillist.h"

struct text {
	struct text 	*next;
	int				length;
	char			txt[80];
};

struct text liste={NULL,-1,0};
struct text *ende=NULL;
int size;
char *mem=NULL,*txtmem=NULL;

char urname[100],subject[100],tname[100],fname[100];

void lprintf(char *format,...)
{
	va_list ap;
	FILE *lfile;
	struct tm *t;
	time_t tt;
	char curtime[35];

	time(&tt);
	t=localtime(&tt);
	strftime(curtime,sizeof(curtime),"%d-%b-%y %H:%M",t);

	va_start(ap,format);
	if (lfile=fopen(logfile,"a"))
	{
		fprintf(lfile,"%s: ",curtime);
		vfprintf(lfile,format,ap);
		fclose(lfile);
	}
	va_end(ap);
}
void stdiolesen(void)
{
	struct text *ll=NULL;
	int l,c;

	l=79;
	while (!feof(stdin))
	{
		c=fgetc(stdin);
		if (c>=0)
		{
			if (l>77)
			{
				if (ll)
				{
					ll->length=l;
					ll->txt[l]=0;
				}
				ll=(text*)malloc(sizeof(struct text));
				l=0;
				ende->next=ll;
				ll->next=NULL;
				ende=ll;
			}
			ll->txt[l]=c; l++;
			size++;
		}
	}
	if (ll)
	{
		ll->length=l;
		ll->txt[l]=0;
	}
}
int makebigblock(void)
{
	struct text *ll,*lb;

	if (mem=(char*)malloc(size+1))
	{
		int i,nl=0;
		char *z;

		size=0;
		z=mem;
		ll=liste.next;

		while(ll)
		{
			for(i=0;i<ll->length;i++)
			{
				*z=ll->txt[i];
				if (!txtmem)
				{
					if (*z=='\n') nl++;
					else if (*z!='\r') nl=0;
					if (nl==2) txtmem=z+1;
				}
				z++;
				size++;
			}
			lb=ll->next;
			free(ll);
			ll=lb;
		}
		*z=0;
		return 1;
	}
	return 0;
}

char *list_path(void)
{
	static char p[400];
	int s=-1;

	for (int i=0;i<MAXLISTS;i++)
	{
		if (cfg_o[i].name[4]=='M' && !strcasecmp(lists[i],tname)) s=i;
	}
	if (s>=0)
	{
		strcpy(p,listdir);
		if (p[strlen(p)-1]!='/') strcat(p,"/");
		strcat(p,lists[s]);
		strcat(p,"/");
		return p;
	}
	return NULL;
}
char *list_path_name(int s)
{
	static char p[400];

	strcpy(p,listdir);
	if (p[strlen(p)-1]!='/') strcat(p,"/");
	strcat(p,lists[s]);
	strcat(p,"/");
	return p;
}

void mailsichern(void)
{
	FILE *datei;
	char pfad[400],buf[20],*p;
	time_t t;

	p=list_path();
	if (p)
	{
		strcpy(pfad,p);
		time(&t);
		sprintf(buf,"mail_%09d",t);
		strcat(pfad,buf);
	
		if (datei=fopen(pfad,"w"))
		{
			fprintf(datei,"From %s\n",urname);
			fprintf(datei,"From: %s\n",fname);
			fprintf(datei,"Subject: %s\n",subject);
			fwrite(txtmem,strlen(txtmem),1,datei);
			fclose(datei);
		}
	}
}
void chkname(char *z)
{
	while (*z && *z!=32 && *z!='>' && *z!=10 &&*z!=13)
	{
		z++;
	}
	*z=0; 
}
void finduser(void)
{
	int i;

	urname[0]=0;
	fname[0]=0;

	for(i=0;i<size;i++)
	{
		if (!urname[0]&&
		    mem[i]=='F'&&
		    mem[i+1]=='r'&&
		    mem[i+2]=='o'&&
		    mem[i+3]=='m'&&
		    mem[i+4]==' '&&
		    mem[i+5])
		{
			strncpy(urname,&mem[i+5],sizeof(urname));
			chkname(urname);
		}
		if (!fname[0]&&
		    mem[i]=='F'&&
		    mem[i+1]=='r'&&
		    mem[i+2]=='o'&&
		    mem[i+3]=='m'&&
		    mem[i+4]==':'&&
		    mem[i+5]==' '&&
		    mem[i+6])
		{
			char *c;
			strncpy(fname,&mem[i+6],sizeof(fname));
			c=fname;
			while (*c)
			{
				c++;
				if (*c=='\n') *c=0;
			}

		}

		if (mem[i]=='R'&&
		    mem[i+1]=='e'&&
		    mem[i+2]=='t'&&
		    mem[i+3]=='u'&&
		    mem[i+4]=='r'&&
		    mem[i+5]=='n'&&
		    mem[i+6]=='-'&&
		    mem[i+7]=='P'&&
		    mem[i+8]=='a'&&
		    mem[i+9]=='t'&&
		    mem[i+10]=='h'&&
		    mem[i+11]==':'&&
		    mem[i+12]==' '&&
		    mem[i+13]=='<'&&
		    mem[i+14])
		{
			strncpy(urname,&mem[i+14],sizeof(urname));
			chkname(urname);
		}
		if (mem[i]=='T'&&
		    mem[i+1]=='o'&&
		    mem[i+2]==':'&&
		    mem[i+3]==' '&&
		    mem[i+4])
		{
			char *c;
			strncpy(tname,&mem[i+4],sizeof(tname));
			chkname(tname);
			c=tname;
			while (*c)
			{
				*c=tolower(*c);
				if (*c=='@') *c=0;
				c++;
			}
		}
		if (mem[i]=='S'&&
		    mem[i+1]=='u'&&
		    mem[i+2]=='b'&&
		    mem[i+3]=='j'&&
		    mem[i+4]=='e'&&
		    mem[i+5]=='c'&&
		    mem[i+6]=='t'&&
		    mem[i+7]==':'&&
		    mem[i+8]==' '&&
		    mem[i+9])
		{
			char *z=subject;
			strncpy(subject,&mem[i+9],sizeof(subject));
			while (*z && *z!=10 &&*z!=13)
			{
				z++;
			}
			*z=0; 
		}
	}
	if (strlen(fname)==0) strcpy(fname,urname);
}
int unameok(void)
{
	char uuname[200],*c;

	strncpy(uuname,urname,sizeof(uuname));
	c=uuname;
	while (*c)
	{
		*c=toupper(*c);
		c++;
	}
	/* From: */
	if (!strncmp(uuname,"POSTMASTER",10))
	{
		return 0;
	}
	if (!strncmp(uuname,"MAILER",6))
	{
		return 0;
	}
	{
		FILE *file;
		char buf[300],*p;
		if (p=list_path())
		{
			strcpy(buf,p);
			strcat(buf,READERS);
			if (file=fopen(buf,"r"))
			{
				setvbuf(file,NULL,_IOFBF,1000);
				while (!feof(file))
				{
					if (fgets(buf,sizeof(buf),file))
					{
						if (buf[strlen(buf)-1]=='\n') buf[strlen(buf)-1]=0;
						if (!strcasecmp(buf,urname))
						{
							fclose(file);
							return 1;
						}
					}
				}
				fclose(file);
			}	
		}
	}
	return 0;
}
void send_mail(char *t,char *b)
{
	char com[800],haddr[80],*tnam;
	FILE *file;

	strcpy(haddr,tname);
	strcat(haddr,"@");
	strcat(haddr,mailaddress);

	tnam=tmpnam(NULL);
	lprintf("sendmail %s\n",t);

	sprintf(com,"("MAIL" -F\"Maillist "VERSION"\" -f\"%s\" %s <%s;rm %s)&",haddr,t,tnam,tnam);
	if (file=fopen(tnam,"w"))
	{
		setvbuf(file,NULL,_IOFBF,1000);
		fprintf(file,"From: %s\n",fname);
		fprintf(file,"Subject: %s\n",subject);
		fprintf(file,"X-Mailer: Maillist "VERSION"\n");
		fprintf(file,"\n");
		fwrite(b,strlen(b),1,file);
		fprintf(file,"\n------------------------------------------------------------------\n");
		fprintf(file," Maillist "VERSION"  -  info & help, mailto: %s@%s\n",cmdname,mailaddress);
		fclose(file);
		system(com);
	}
}
void senden(void)
{
	FILE *file;
	char buf[300],*p,to[500]="";

	if (!lockwait(99)) return;
	if (p=list_path())
	{
		strcpy(buf,p);
		strcat(buf,READERS);
		if (file=fopen(buf,"r"))
		{
			setvbuf(file,NULL,_IOFBF,1000);
			while (!feof(file))
			{
				if (fgets(buf,sizeof(buf),file))
				{
					if (buf[strlen(buf)-1]=='\n') buf[strlen(buf)-1]=0;
					if (strcasecmp(buf,urname))
					{
						if (strlen(to)+strlen(buf)+2>sizeof(to))
						{
							send_mail(to,txtmem);
							to[0]=0;
						}
						strcat(to,buf);
						strcat(to," ");
					}
				}
			}
			fclose(file);
			send_mail(to,txtmem);
		}	
	}
	unlock(99);
}
void send_error(int e)
{
	char buf[400];
	switch (e)
	{
		case 1: // not allowed
			sprintf(buf,"Sorry, but you are not allowed to write\n"
						"mail in the mailing list %s.\n\n"
						"To subscribe write to '%s' at this host\n"
						"and write in the mailbody the command 'HELP'.\n\n"
						"Yours\n\n   maillist mailing list tool\n",
						tname,cmdname);
			lprintf("Illegal access to %s by %s\n",tname,urname);
			break;
	}
	send_mail(urname,buf);
}
void send_help(void)
{
	char buf[600];
	sprintf(buf,
		"Maillist "VERSION" Help Request\n\n"
		"To subscribe und unsubscribe a mailing list of maillist "VERSION"\n"
		"- write an EMail to %s@%s.\n"
		"- Place what ever you want in the subject.\n"
		"- Write one or more commands, one per line in the mail body\n\n"
		"The commands:\n\n"
		"> help\n"
		"  sends you this help page\n\n"
		"> index\n"
		"  sends you a list of all available mailing lists\n\n"
		"> list\n"
		"  lists your subscribed lists\n\n"
		"> subscribe <listname>\n" // [email address]\n"
		"> sub <listname> [email address]\n"
		"  subscribes the named list for you, you may optionalle\n"
		"  specify an EMail address\n\n"
		"> unsubscribe <listname>\n"
		"> unsub <listname>\n"
		"  unsubscribes the named list for you - here you can't\n"
		"  give an EMail address!\n\n"
//		"> master <text>\n"
//		"  sends the given text to the maillist admin\n\n"
		,cmdname,mailaddress);
	strcpy(subject,"Help Request");
	send_mail(urname,buf);
}
void send_index(void)
{
	FILE *file;
	char buf[600],*p,fle[100];
	strcpy(buf,"Available mailing lists:\n\n");
	for(int i=0;i<MAXLISTS;i++)
	{
		if (cfg_o[i].name[4]=='M' && strlen(lists[i]))
		{
			strcat(buf,"-> ");
			strcat(buf,lists[i]);
			strcat(buf,"\n");
			p=list_path_name(i);
			strcpy(fle,p);
			strcat(fle,DESCNAME);
			if (file=fopen(fle,"r"))
			{
				if (fgets(fle,sizeof(fle),file))
				{
					strcat(buf,"      ");
					strcat(buf,fle);
					strcat(buf,"\n");
				}
				fclose(file);
			}
		}
	}
	strcat(buf,"\n\nTo subscribe a list send the 'subscribe' command,\n");
	strcat(buf,"e.g. subscribe foobar\n\n");
	strcpy(subject,"Index Request");
	send_mail(urname,buf);
}
void send_list(void)
{
	FILE *file;
	char buf[400],lne[300],*p;

	sprintf(buf,"Subscribed mailing lists of %s:\n\n",urname);

	for(int i=0;i<MAXLISTS;i++)
	{
		if (cfg_o[i].name[4]=='M' && strlen(lists[i]))
		{
			if (p=list_path_name(i))
			{
				strcpy(lne,p);
				strcat(lne,READERS);
				if (lockwait(i))
				{
					if (file=fopen(lne,"r"))
					{
						while (!feof(file))
						{
							if (fgets(lne,sizeof(lne),file))
							{
								if (!strncasecmp(lne,urname,strlen(urname)))
								{
									strcat(buf,"- ");
									strcat(buf,lists[i]);
									strcat(buf,"\n");
								}
							}
						}
					}
					unlock(i);
				}
			}
		}
	}
	strcat(buf,"\n\nTo unsubscribe a list send the 'unsubscribe' command,\n");
	strcat(buf,"e.g. unsubscribe foobar\n\n");
	strcpy(subject,"List Request");
	send_mail(urname,buf);
}
int subscribe(char *m)
{
	FILE *file1,*file2;
	char buf1[300],buf2[300],*p,lstname[30],email[60],buf[80];
	int i,s=-1,ok=0,in=0;

	sscanf(m,"%*s %30s %60s",lstname,email);

	strcpy(email,urname);

	for(i=0;i<MAXLISTS;i++)
	{
		if (cfg_o[i].name[4]=='M' && !strcasecmp(lists[i],lstname)) s=i;
	}

	if (p=list_path_name(s))
	{
		if (lockwait(s))
		{
			strcpy(buf1,p);
			strcat(buf1,READERS);
			strcpy(buf2,p);
			strcat(buf2,"tmp_"READERS);
			rename(buf1,buf2);
			if (file1=fopen(buf2,"r"))
			{
				if (file2=fopen(buf1,"w"))
				{
					setvbuf(file1,NULL,_IOFBF,1000);
					setvbuf(file2,NULL,_IOFBF,1000);
					while (!feof(file1))
					{
						if (fgets(buf,sizeof(buf),file1))
						{
							fprintf(file2,buf);
							if (!strncasecmp(buf,email,strlen(email))) in=1;
						}
					}
					if (!in) fprintf(file2,"%s\n",email);
					ok=1;
					fclose(file2);
				}
				fclose(file1);
			}
			unlock(s);
		}
		if (ok)
		{
			remove(buf2);
			sprintf(buf1,"You have been subscribed to %s.\nTo unsubscribe send \"unsub %s\" to %s@%s.",lists[s],lists[s],cmdname,mailaddress);
		}
		else
		{
			rename(buf2,buf1);
			sprintf(buf1,"There have been an host error while subscribing to %s.\n",lists[s]);
		}
	}
	else
	{
		sprintf(buf1,"Unknown list %s.\n",lists[s]);
	}
	strcpy(subject,"Subscribe");
	send_mail(urname,buf1);
	return ok;
}
int unsubscribe(char *m)
{
	FILE *file1,*file2;
	char buf1[300],buf2[300],*p,lstname[30],buf[80];
	int i,s=-1,ok=0;

	sscanf(m,"%*s %30s",lstname);

	for(i=0;i<MAXLISTS;i++)
	{
		if (cfg_o[i].name[4]=='M' && !strcasecmp(lists[i],lstname)) s=i;
	}

	if (p=list_path_name(s))
	{
		if (lockwait(s))
		{
			strcpy(buf1,p);
			strcat(buf1,READERS);
			strcpy(buf2,p);
			strcat(buf2,"tmp_"READERS);
			rename(buf1,buf2);
			if (file1=fopen(buf2,"r"))
			{
				if (file2=fopen(buf1,"w"))
				{
					setvbuf(file1,NULL,_IOFBF,1000);
					setvbuf(file2,NULL,_IOFBF,1000);
					while (!feof(file1))
					{
						if (fgets(buf,sizeof(buf),file1))
						{
							if (strncasecmp(buf,urname,strlen(urname))) fprintf(file2,buf);
						}
					}
					ok=1;
					fclose(file2);
				}
				fclose(file1);
			}
			unlock(s);
		}
		if (ok)
		{
			remove(buf2);
			sprintf(buf1,"You have been unsubscribed from %s.\n",lists[s]);
		}
		else
		{
			rename(buf2,buf1);
			sprintf(buf1,"There have been an host error while unsubscribing from %s.\n",lists[s]);
		}
	}
	else
	{
		sprintf(buf1,"Unknown list %s.\n",lists[s]);
	}
	strcpy(subject,"Unsubscribe");
	send_mail(urname,buf1);
	return ok;
}
void befehl(void)
{
	char *m=txtmem,buf[80]="";
	int com=0,i=0;

	sprintf(fname,"Maillist "VERSION" <%s@%s>",cmdname,mailaddress);
	while (*m)
	{
		buf[i++]=*m;
		if (*m=='\n')
		{
			buf[i-1]=0;
			i=0;
			if (!strncasecmp("help",buf,4))
			{
				send_help();
				com++;
			}
			else if (!strncasecmp("index",buf,5))
			{
				send_index();
				com++;
			}
			else if (!strncasecmp("list",buf,4))
			{
				send_list();
				com++;
			}
			else if (!strncasecmp("sub",buf,3) || !strncasecmp("subscribe",buf,9))
			{
				subscribe(buf);
				com++;
			}
			else if (!strncasecmp("unsub",buf,5) || !strncasecmp("unsubscribe",buf,11))
			{
				unsubscribe(buf);
				com++;
			}
		}
		m++;
	}
	if (com==0) send_help();
}
void readconfig(void)
{
	config cfg(CFGFILE);
	cfg.SetItems(cfg_o);
	cfg.Read();	
}
int main(int argc,char *argv[])
{
	ende=&liste;
	size=0;

	readconfig();
	stdiolesen();
	if (makebigblock())
	{
		finduser();
		lprintf("User %s\n",urname);
		if (urname[0])
		{
			if (!strcasecmp(tname,cmdname))
			{
				befehl();
			}
			else
			{
				if (unameok())
				{
					mailsichern();
					senden();
				}
				else
				{
					send_error(1);
				}
			}
		}
	}
	return 0;
}
