/* $Id: Tab.c,v 1.2 1999/11/06 05:51:02 glgay Exp $ */
/*
 Copyright (C) 1996 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#include <Xmext/TabP.h>
#include <Xm/ManagerP.h>
#include <Xm/GadgetP.h>
#include <Xm/DrawP.h>
#include <Xm/MenuUtilP.h>
#include <stdio.h>

/* The following macro may/may not be defined.  So ... */ 
#if !defined(Prim_BottomShadowGC)
#define Prim_BottomShadowGC(w) \
   (((XmPrimitiveWidget)(w))->primitive.bottom_shadow_GC)
#endif

#if !defined(Prim_Foreground)
#define Prim_Foreground(w) \
   (((XmPrimitiveWidget)(w))->primitive.foreground)
#endif

#if !defined(Prim_HighlightDrawn)
#define Prim_HighlightDrawn(w) \
   (((XmPrimitiveWidget)(w))->primitive.highlight_drawn)
#endif

#if !defined(Prim_Highlighted)
#define Prim_Highlighted(w) \
   (((XmPrimitiveWidget)(w))->primitive.highlighted)
#endif

#if !defined(Prim_HighlightGC)
#define Prim_HighlightGC(w) \
   (((XmPrimitiveWidget)(w))->primitive.highlight_GC)
#endif

#if !defined(Prim_HighlightThickness)
#define Prim_HighlightThickness(w) \
   (((XmPrimitiveWidget)(w))->primitive.highlight_thickness)
#endif

#if !defined(Prim_TopShadowGC)
#define Prim_TopShadowGC(w) \
   (((XmPrimitiveWidget)(w))->primitive.top_shadow_GC)
#endif

#if !defined(Lab_SkipCallback)
#define Lab_SkipCallback(w) \
   (((XmLabelWidget)(w))->label.skipCallback)
#endif

#if !defined(Lab_Pixmap)
#define Lab_Pixmap(w) \
   (((XmLabelWidget)(w))->label.pixmap)
#endif

#if !defined(Lab_RecomputeSize)
#define Lab_RecomputeSize(w) \
   (((XmLabelWidget)(w))->label.recompute_size)
#endif

/* Tab widget */
#define Unused(x) (void)(x)
#define Offset(field) XtOffsetOf(XmTabRec, tab.field)
#define VALID(w)	(w && XtIsManaged(w))

/* local declarations */
static void border_highlight(Widget w);
static void border_unhighlight(Widget w);
#if 0
static void change_managed(Widget w);
#endif
static void class_initialize();
static void class_part_initialize(WidgetClass class);
static void destroy(Widget w);
static void expose(Widget w, XEvent *event, Region region);
static void initialize(Widget request, 
                       Widget c_new,
                       ArgList args,
                       Cardinal *num_args);

#if 0
static void layout(Widget sheet);
#endif

static void lower_tab(Widget w);
static void raise_tab(Widget w);
static Boolean set_values(Widget current, 
                          Widget request, 
                          Widget c_new, 
                          ArgList args,
                          Cardinal *num_args);

static void Activate(Widget w, 
                     XEvent *event, 
                     _XtString *params, 
                     Cardinal *num_params);
static void Arm(Widget w, 
                XEvent *event, 
                _XtString *params, 
                Cardinal *num_params);
static void ArmAndActivate(Widget w, 
                           XEvent *event, 
                           _XtString *params, 
                           Cardinal *num_params);
static void Disarm(Widget w, 
                   XEvent *event, 
                   _XtString *params, 
                   Cardinal *num_params);
static void EnterWindow(Widget w, 
                        XEvent *event, 
                        _XtString *params, 
                        Cardinal *num_params);
static void Help(Widget w, 
                 XEvent *event, 
                 _XtString *params, 
                 Cardinal *num_params);
static void LeaveWindow(Widget w, 
                        XEvent *event, 
                        _XtString *params, 
                        Cardinal *num_params);
static void ProcessDrag(Widget w, 
                        XEvent *event, 
                        _XtString *params, 
                        Cardinal *num_params);

#if XmVERSION >= 2
/*
 * FIX ME
 * If this routine disappears then replace it with 
 *
 *    XtRString,
 *    (XtPointer)"dark grey"
 *
 * until it can be fixed properly.
 *
 */
extern void _XmSelectColorDefault(
                        Widget widget,
                        int offset,
                        XrmValue *value) ;

/* This is no longer in LabelP.h */
extern void _XmCalcLabelDimensions(Widget w);

/* This is no longer in PrimitiveP.h */
extern void _XmPrimitiveEnter(Widget w,
                       XEvent *event,
                       String *params,
                       Cardinal *num_params);

/* This is no longer in PrimitiveP.h */
extern void _XmPrimitiveLeave(Widget w,
                       XEvent *event,
                       String *params,
                       Cardinal *num_params);

#endif

/* ========================================================================== */
/* Resources for the Tab class */
static XtResource resources[] = {
   {
     XmNactivateCallback,
     XmCCallback, 
     XtRCallback,
     sizeof(XtCallbackList),
     Offset(activate_callback),
     XmRPointer,
     (XtPointer)NULL
   },

   {
     XmNarmCallback,
     XmCCallback, 
     XtRCallback,
     sizeof(XtCallbackList),
     Offset(arm_callback),
     XmRPointer,
     (XtPointer)NULL
   },

   {
     XmNarmColor,
     XmCArmColor, 
     XmRPixel,
     sizeof(Pixel),
     Offset(arm_color),
     XmRCallProc,
     (XtPointer)_XmSelectColorDefault
   },

   {
     XmNarmPixmap,
     XmCArmPixmap, 
     XmRPrimForegroundPixmap,
     sizeof(Pixmap),
     Offset(arm_pixmap),
     XmRImmediate,
     (XtPointer)XmUNSPECIFIED_PIXMAP
   },

   {
     XmNcornerStyle,
     XmCCornerStyle, 
     XmRInt,
     sizeof(int),
     Offset(corner_style),
     XmRImmediate,
     (XtPointer) XmCORNER_LINE
   },

   {
     XmNcornerSize,
     XmCCornerSize, 
     XmRInt,
     sizeof(int),
     Offset(corner_size),
     XmRImmediate,
     (XtPointer) 0  /* zero means use defaults sizes for corner_style */
                    /* 10 for arcs, 3 for lines */
   },

   {
     XmNdisarmCallback,
     XmCCallback, 
     XtRCallback,
     sizeof(XtCallbackList),
     Offset(disarm_callback),
     XmRPointer,
     (XtPointer)NULL
   },

   {
     XmNfillOnArm,
     XmCFillOnArm, 
     XtRBoolean,
     sizeof(Boolean),
     Offset(fill_on_arm),
     XmRImmediate,
     (XtPointer)False
   },

   {
     XmNshowAsActive,
     XmCShowAsActive,
     XtRBoolean,
     sizeof(Boolean),
     Offset(show_as_active),
     XmRImmediate,
     (XtPointer)False
   },

   /* Resources redefined from Primitive/Label */
   { 
     XmNrecomputeSize,
     XmCRecomputeSize,
     XmRBoolean,
     sizeof(Boolean),
     XtOffsetOf(XmTabRec, label.recompute_size),
     XmRImmediate,
     (XtPointer)True 
   },
   {
     XmNtraversalOn,
     XmCTraversalOn,
     XmRBoolean,
     sizeof(Boolean),
     XtOffsetOf(XmTabRec, primitive.traversal_on),
     XmRImmediate,
     (XtPointer)True
   },
   {
     XmNhighlightThickness,
     XmCHighlightThickness,
     XmRHorizontalDimension,
     sizeof(Dimension),
     XtOffsetOf(XmTabRec, primitive.highlight_thickness),
     XmRImmediate,
     (XtPointer)2
   },
   {
     XmNshadowThickness, 
     XmCShadowThickness, 
     XmRHorizontalDimension,
     sizeof(Dimension),
     XtOffsetOf(XmTabRec, primitive.shadow_thickness),
     XmRImmediate,
     (XtPointer)2
   },
 
};

static XmSyntheticResource syn_resources[] = {
   {
     XmNhighlightThickness,
     sizeof(Dimension),
     XtOffsetOf(XmTabRec, primitive.highlight_thickness),
     _XmFromHorizontalPixels,
     _XmToHorizontalPixels
   },
};

/* ========================================================================== */
/* Actions for the Tab Widget */
static XtActionsRec actions[] = {
   {"Activate", Activate},
   {"Arm", Arm},
   {"ArmAndActivate", ArmAndActivate},
   {"Disarm", Disarm},
   {"Enter", EnterWindow},
   {"Help", Help},
   {"Leave", LeaveWindow},
   {"ProcessDrag", ProcessDrag},
};

/* ========================================================================== */
/* Translations for the Tab Widget */
char _XmTab_defaultTranslations[] = 
   "<Btn1Down>:           Arm()\n"
   "<Btn1Down>,<Btn1Up>:  Activate() Disarm()\n"
   "<Btn1Up>:             Activate() Disarm()\n"
   "<Btn2Down>:           ProcessDrag()\n"
   "<EnterWindow>:        Enter()\n"
   "<LeaveWindow>:        Leave()\n"
   "<Key>osfSelect:       ArmAndActivate()\n"
   "<Key>osfHelp:         Help()\n"
   "<Key>osfActivate:     PrimitiveParentActivate()\n"
   "~s ~m ~a <Key>Return: PrimitiveParentActivate()\n"
   "~s ~m ~a <Key>space:  ArmAndActivate()\n";

/* ========================================================================== */
/* Class record */

static XmBaseClassExtRec _XmTabCoreClassExtRec = {
   NULL,                       /* next_extension */
   NULLQUARK,                  /* record_type */
   XmBaseClassExtVersion,      /* version */ 
   sizeof(XmBaseClassExtRec),  /* size */
   XmInheritInitializePrehook, /* initialize_prehook */
   XmInheritSetValuesPrehook,  /* set_values_prehook */
   XmInheritInitializePosthook,/* initialize_posthook */
   XmInheritSetValuesPosthook, /* set_values_posthook */
   XmInheritClass,             /* secondary_object_class */
   XmInheritSecObjectCreate,   /* secondary_object_create */
   XmInheritGetSecResData,     /* get_secondary_resources */
   { 0 },                      /* fast_subclass */
   XmInheritGetValuesPrehook,  /* get_values_prehook */
   XmInheritGetValuesPosthook, /* get_values_posthook */
   XmInheritClassPartInitPrehook,  /* class_part_init_prehook */
   XmInheritClassPartInitPosthook, /* class_part_init_posthook */
   NULL,                       /* ext_resources */
   NULL,                       /* compiled_ext_resources */
   0,                          /* num_ext_resources */
   FALSE,                      /* use_ext_resources */
   XmInheritWidgetNavigable,   /* widget_navigable */
   XmInheritFocusChange,       /* focus_change */
   NULL,                       /* wrapper_data */
};
   
XmPrimitiveClassExtRec _XmTabPrimClassExtRec = {
   NULL,                           /* next_extension */
   NULLQUARK,                      /* record_type */
   XmPrimitiveClassExtVersion,     /* version */
   sizeof(XmPrimitiveClassExtRec), /* record_size */
   XmInheritBaselineProc,          /* widget_baseline */
   XmInheritDisplayRectProc,       /* widget_display_rect */
   NULL,                           /* widget_margins */
};

XmTabClassRec xmTabClassRec = {
   /* Core class part */
   {
      (WidgetClass) &xmLabelClassRec,         /* superclass */
      "XmTab",                                /* class_name */
      sizeof(XmTabRec),                       /* widget_size */
      class_initialize,                       /* class_initialize */
      class_part_initialize,                  /* class_part_initialize */
      FALSE,                                  /* class_inited */
      initialize,                             /* initialize */
      NULL,                                   /* initialize_hook */
      XtInheritRealize,                       /* realize */
      actions,                                /* actions */
      XtNumber(actions),                      /* num_actions */
      resources,                              /* resources */
      XtNumber(resources),                    /* num_resources */
      NULLQUARK,                              /* xrm_class */
      TRUE,                                   /* compress_motion */
      XtExposeCompressMultiple,               /* compress_exposure */
      TRUE,                                   /* compress_enterleave */
      FALSE,                                  /* visible_interest */
      destroy,                                /* destroy */
      XtInheritResize,                        /* resize */
      expose,                                 /* expose */
      set_values,                             /* set_values */
      NULL,                                   /* set_values_hook */
      XtInheritSetValuesAlmost,               /* set_values_almost */
      NULL,                                   /* get_values_hook */
      NULL,                                   /* accept_focus */
      XtVersion,                              /* version */
      NULL,                                   /* callback offsets */
      _XmTab_defaultTranslations,             /* tm_table */
      XtInheritQueryGeometry,                 /* query_geometry */
      XtInheritDisplayAccelerator,            /* display_accelerator */
#if 0
      (XtPointer)NULL
#else /* Do we need the extension record? This causes a core dump under
       * Motif 2.0 after the initialize prehook routine is called 
       * and we are not doing any extensions.
       */
      (XtPointer)&_XmTabCoreClassExtRec       /* extension */ 
#endif
   },
   /* XmPrimitive class part */
   {
      border_highlight,                       /* border_highlight */ 
      border_unhighlight,                     /* border_unhighlight */ 
      XtInheritTranslations,                  /* translations */
      ArmAndActivate,                         /* arm_and_activate_proc */
      syn_resources,                          /* Synthetic Resources */
      XtNumber(syn_resources),                /* num syn res */
      (XtPointer)&_XmTabPrimClassExtRec       /* extensions */
   },
   /* XmLabel class part */
   {
      XmInheritSetOverrideCallback,           /* setOverrideCallback */
      XmInheritMenuProc,                      /* menuProcs */
      XtInheritTranslations,                  /* translations */
      NULL                                    /* extension */ 
   },
   /* XmTab class part */
   {
      NULL                                    /* extension */ 
   }
};

WidgetClass xmTabWidgetClass = (WidgetClass) &xmTabClassRec;

/* ========================================================================== */
/* functions */

#if XmVERSION >= 2
extern void _XmDrawHighlight(Display *display,
                             Drawable d,
                             GC gc,
                             Position x,
                             Position y,
                             Dimension width,
                             Dimension height,
                             Dimension highlight_thick,
                             int line_style);
#endif

static void
border_highlight(Widget w)
{
   int highlight_offset = 5; /* <== maybe we should make this a user setting */

   /* check to see if thickness is zero */
   if(Prim_HighlightThickness(w) == 0)
   {
      return;
   }

   _XmDrawHighlight(XtDisplay(w), 
                    XtWindow(w), 
                    Prim_HighlightGC(w),
                    highlight_offset, 
                    highlight_offset, 
                    XtWidth(w) - 2*highlight_offset, 
                    XtHeight(w) - 2*highlight_offset,
                    Prim_HighlightThickness(w), LineOnOffDash); 

   Prim_Highlighted(w) = True;
   Prim_HighlightDrawn(w) = True;
}

static void
border_unhighlight(Widget w)
{
   int highlight_offset = 5; /* <== maybe we should make this a user setting */

   /* check to see if thickness is zero */
   if(Prim_HighlightThickness(w) == 0)
   {
      return;
   }

   if(XmIsManager(XtParent(w)))
   {
      _XmDrawHighlight(XtDisplay(w), 
                       XtWindow(w), 
                       XmParentBackgroundGC(w),
                       highlight_offset, 
                       highlight_offset, 
                       XtWidth(w) - 2*highlight_offset, 
                       XtHeight(w) - 2*highlight_offset,
                       Prim_HighlightThickness(w), LineOnOffDash); 
   }
   else
   {
      _XmClearBorder(XtDisplay(w),
                     XtWindow(w), 
                     highlight_offset, 
                     highlight_offset, 
                     XtWidth(w) - 2*highlight_offset, 
                     XtHeight(w) - 2*highlight_offset,
                     Prim_HighlightThickness(w)); 
   }

   Prim_Highlighted(w) = False;
   Prim_HighlightDrawn(w) = False;
}

#if 0
static void 
change_managed(Widget w)
{
   if(XtIsRealized(w))
   {
      layout(w);
   }
}
#endif

static void
class_initialize()
{
}

static void
class_part_initialize(WidgetClass widget_class)
{
   Unused(widget_class);
}

/*
* create_fill_GC
*
* This function creates the fill GC for the widget.
*/
static void
create_fill_GC(Widget w)
{
   XGCValues values;
   XtGCMask mask;

   mask = GCForeground | GCBackground | GCFillStyle | GCFunction |
          GCSubwindowMode | GCGraphicsExposures | GCPlaneMask;
   values.function = GXcopy;
   values.plane_mask = -1;
   values.subwindow_mode = ClipByChildren;
   values.graphics_exposures = False;
   values.foreground = Tab_ArmColor(w);
   values.background = XtBackground(w);
   values.fill_style = FillSolid;

   Tab_FillGC(w) = XtGetGC(w, mask, &values); 
}

static void
create_background_GC(Widget w)
{
   XGCValues values;
   XtGCMask mask;

   mask = GCForeground | GCBackground | GCFillStyle | GCFunction |
          GCSubwindowMode | GCGraphicsExposures | GCPlaneMask;
   values.function = GXcopy;
   values.plane_mask = -1;
   values.subwindow_mode = ClipByChildren;
   values.graphics_exposures = False;
   values.foreground = XtBackground(w);
   values.background = Prim_Foreground(w);
   values.fill_style = FillSolid;
   
   Tab_BackgroundGC(w) = XtGetGC(w, mask, &values); 
}

static void
destroy(Widget w)
{
   XtReleaseGC(w, Tab_FillGC(w));
   XtReleaseGC(w, Tab_BackgroundGC(w));
}

void
_XmDrawTabNone(Display *display,
               Window win,
               GC topGC,
               GC bottomGC,
               Position x,
               Position y,
               Dimension width,
               Dimension height,
               Dimension shadowThickness)
{
   /* XmSHADOW_OUT */

   int i;
   for(i=0; i<shadowThickness; i++) 
   {
      /*
       * draw the vertical lines
       */
      /* draw left side */
      XFillRectangle(display,
                     win,
                     topGC,
                     x + i ,y,
                     1, height - i);

      /* draw right side */
      XFillRectangle(display,
                     win,
                     bottomGC,
                     x+width - i - 1, y + i + 1,
                     1, height - i - 1);

      /*
       * draw the horizontal lines
       */
      /* draw the top */
      XFillRectangle(display,
                     win,
                     topGC,
                     x, y + i,
                     width - i, 1);

      #if 0
      /* this is the bottom */
      XFillRectangle(display,
                     win,
                     bottomGC,
                     x + i + 1, y+height - i - 1,
                     width - i - 1, 1);
      #endif
   }
}

void
_XmDrawTabLine(Display *display,
               Window win,
               GC topGC,
               GC bottomGC,
               Position x,
               Position y,
               Dimension width,
               Dimension height,
               Dimension shadowThickness,
               int cornerSize)
{
   /* XmSHADOW_OUT */
   int i;
   int corner_size = 3;

   if (cornerSize < 0)
   {
      cornerSize = 0;
   }
   else if (cornerSize > 20)
   {
      cornerSize = 20;
   }

   if (cornerSize != 0)
   {
      corner_size = cornerSize;
   }

   for(i=0; i<shadowThickness; i++) 
   {
      /* draw the top */
      XDrawLine(display,win,topGC,
                     x + corner_size - 1 - i,
                     y + i, 
                     x + width - corner_size - 1 - i,
                     y + i);

      /* draw the left corner */
      XDrawLine(display,win,topGC,
                     x + i + corner_size,
                     y + i,  
                     x + i,
                     y + i + corner_size );

      if(i!=shadowThickness-1)
      {
         /* fill in empty spaces between lines */
         XDrawLine(display,win,topGC,
                     x + i + corner_size + 1,
                     y + i,  
                     x + i + 1,
                     y + i + corner_size );
      }

      /* draw the left side */
      XDrawLine(display,win,topGC,
                     x + i, /* x1 */
                     y + corner_size, /* y1 */
                     x + i, /* x2 */
                     y + height /* y2 */);

      /* draw the right corner */
      XDrawLine(display,win,bottomGC,
                     (x - i) + (width - corner_size) - 1,
                     y + i, 
                     (x - i) + width - 1,
                     y + i + corner_size );

      if(i!=shadowThickness-1)
      {
         /* fill in empty spaces between lines */
         XDrawLine(display,win,bottomGC,
                     (x - i) + (width - corner_size) - 2,
                     y + i, 
                     (x - i) + width - 2,
                     y + i + corner_size );
      }

      /* draw the right side */
      XDrawLine(display,win,bottomGC,
                     (x - i) + width - 1, /* x1 */
                     (y + corner_size), /* y1 */
                     (x - i) + width - 1, /* x2 */
                     (y + height) /* y2 */);

   }
}

void
_XmDrawTabArc(Display *display,
              Window win,
              GC topGC,
              GC bottomGC,
              Position x,
              Position y,
              Dimension width,
              Dimension height,
              Dimension shadowThickness,
              int cornerSize)
{
   /* XmSHADOW_OUT */
   int i;
   int corner_size = 10;
   int arc_size;

   if (cornerSize < 0)
   {
      cornerSize = 0;
   }
   else if (cornerSize > 20)
   {
      cornerSize = 20;
   }

   if (cornerSize != 0)
   {
      corner_size = cornerSize;
   }

   arc_size = corner_size * 2;

   for(i=0; i<shadowThickness; i++) 
   {
      /* draw the top */
      XDrawLine(display,win,topGC,
                     x + corner_size - 1 - i,
                     y + i, 
                     x + width - corner_size - 1 - i,
                     y + i);

      /* draw the left corner */
      XDrawArc(display,win,topGC,
                     x + i,
                     y + i, 
                     arc_size,
                     arc_size,
                     64*91, 64*88 );

      if(i!=shadowThickness-1)
      {
         /* fill in empty spaces between lines */
         XDrawArc(display,win,topGC,
                     x + i + 1,
                     y + i, 
                     arc_size,
                     arc_size,
                     64*91, 64*88 );
      }

      /* draw the left side */
      XDrawLine(display,win,topGC,
                     x + i, /* x1 */
                     y + corner_size, /* y1 */
                     x + i, /* x2 */
                     y + height /* y2 */);

      /* draw the right corner */
      XDrawArc(display,win,bottomGC,
                     (x - i) + (width - arc_size) - 1,
                     y + i, 
                     arc_size,
                     arc_size,
                     64*89, 64*-88 );

      if(i!=shadowThickness-1)
      {
         /* fill in empty spaces between lines */
         XDrawArc(display,win,bottomGC,
                     (x - i) + (width - arc_size) - 2,
                     y + i, 
                     arc_size,
                     arc_size,
                     64*89, 64*-88 );
      }

      /* draw the right side */
      XDrawLine(display,win,bottomGC,
                     (x - i) + width - 1, 
                     (y + corner_size), 
                     (x - i) + width - 1,
                     y + height); 
   }
}

/*
*  _XmDrawTab
*
*  This function is just a front-end to the _XmDrawTab* functions.
*
*/
void
_XmDrawTab(Display *display,
           Window win,
           GC topGC,
           GC bottomGC,
           Position x,
           Position y,
           Dimension width,
           Dimension height,
           Dimension shadowThickness,
           int cornerStyle,
           int cornerSize)
{
   Cardinal n;

   if (shadowThickness > width || shadowThickness > height)
   {
      shadowThickness = 2;
   }

   switch (cornerStyle)
   {
      case XmCORNER_NONE:
         _XmDrawTabNone(display,
                        win,
                        topGC,
                        bottomGC,
                        x,
                        y,
                        width,
                        height,
                        shadowThickness);
         break;
      case XmCORNER_LINE:
         _XmDrawTabLine(display,
                        win,
                        topGC,
                        bottomGC,
                        x,
                        y,
                        width,
                        height,
                        shadowThickness,
                        cornerSize);
         break;
      case XmCORNER_ARC:
         _XmDrawTabArc(display,
                       win,
                       topGC,
                       bottomGC,
                       x,
                       y,
                       width,
                       height,
                       shadowThickness,
                       cornerSize);
         break; 
      default:
         n = 0;
         XtAppWarningMsg(XtDisplayToApplicationContext(display),
                         "cornerStyle", 
                         "cornerStyle",
                         "Error",
                         "Illegal corner style sent to _XmDrawTab",
                         NULL,
                         &n);
   }
}

static void
expose(Widget w,
       XEvent *event,
       Region region)
{
   Dimension normal_shadow_x, normal_shadow_y;
   Dimension normal_shadow_width, normal_shadow_height;
   
   if (!XtIsRealized(w))
   {
       return;
   }

   normal_shadow_x = Lab_MarginLeft(w);
   normal_shadow_y = Lab_MarginTop(w);
   normal_shadow_width = XtWidth(w) - Lab_MarginLeft(w) - Lab_MarginRight(w);
   normal_shadow_height = XtHeight(w) - Lab_MarginTop(w) - Lab_MarginBottom(w);

   #if 0
   normal_shadow_x = Lab_Highlight(w) + Lab_MarginLeft(w);
   normal_shadow_y = Lab_Highlight(w) + Lab_MarginTop(w);
   normal_shadow_width = XtWidth(w) - 2 * Lab_Highlight(w) -
                                Lab_MarginLeft(w) - Lab_MarginRight(w);
   normal_shadow_height = XtHeight(w) - 2 * Lab_Highlight(w) - 
                                Lab_MarginTop(w) - Lab_MarginBottom(w);
   #endif

   if(!Tab_Armed(w))
   {
      XFillRectangle(XtDisplay(w), XtWindow(w),
                     Tab_BackgroundGC(w),
                     0,0, XtWidth(w), XtHeight(w));
   }

   if(Tab_Armed(w) && Tab_FillOnArm(w) && !Lab_IsPixmap(w))
   {
      XFillRectangle(XtDisplay(w), XtWindow(w),
                     Tab_FillGC(w),
                     normal_shadow_x + Prim_ShadowThickness(w),
                     normal_shadow_y + Prim_ShadowThickness(w),
                     normal_shadow_width - 2 * Prim_ShadowThickness(w),
                     normal_shadow_height - 2 * Prim_ShadowThickness(w));
                     
   }

   if(Lab_IsPixmap(w))
   {
      if(Tab_Armed(w) && Tab_ArmPixmap(w) != XmUNSPECIFIED_PIXMAP)
      {
         Lab_Pixmap(w) = Tab_ArmPixmap(w);
      }
      else
      {
         Lab_Pixmap(w) = Tab_UnarmPixmap(w);
      }
   }         

   /* now draw the tab */
   _XmDrawTab(XtDisplay(w), XtWindow(w), 
                  Prim_TopShadowGC(w),
                  Prim_BottomShadowGC(w),
                  normal_shadow_x,
                  normal_shadow_y,
                  normal_shadow_width,
                  normal_shadow_height,
                  Lab_Shadow(w),
                  Tab_CornerStyle(w),
                  Tab_CornerSize(w));
                      
   #define superclass (&xmLabelClassRec)
   (*superclass->core_class.expose)(w, event, region);
   #undef superclass

   if(Prim_Highlighted(w))
   {
      border_highlight(w);
   }
   else
   {
      border_unhighlight(w);
   }
}

#if 0
static void
autoSpaceWidget(Widget w, int size)
{
   int border;
   border = XtWidth(w);

   if(border < size)
   {
      int offset = (size-border)%2;
      border = (size-border)/2;
      XtVaSetValues(w, 
                    XmNmarginLeft, border,
                    XmNmarginRight, ((Dimension) border+offset), 
                    NULL);
   }

   XtVaSetValues(w, 
                 XmNhighlightThickness, 1,
                 XmNborderWidth, 0, 
                 NULL);
}
#endif

static void
initialize(Widget request,
           Widget c_new,
           ArgList args,
           Cardinal *num_args)
{
   if(!Lab_Font(c_new))
   {
      Lab_Font(c_new) = _XmGetDefaultFontList(c_new, XmBUTTON_FONTLIST);
   }

   Tab_Armed(c_new) = False;
   
   create_fill_GC(c_new);
   create_background_GC(c_new);

   if(Lab_Pixmap(c_new) == XmUNSPECIFIED_PIXMAP &&
      Tab_ArmPixmap(c_new) != XmUNSPECIFIED_PIXMAP)
   {
      Lab_Pixmap(c_new) = Tab_ArmPixmap(c_new);
   }

   Tab_UnarmPixmap(c_new) = Lab_Pixmap(c_new);

}

#if 0
/*
* layout
*
* This function repositions child windows according to its own
* geometry.
*
*/
static void
layout(Widget w)
{
   printf("stub: layout()\n");
}
#endif

/*
* lower_tab
*
* This function gives the impression the tab is being lowered.
*/
static void
lower_tab(Widget w)
{
   XtWidgetGeometry request, reply_return;

   request.stack_mode = BottomIf;
   request.request_mode = CWStackMode;

   XtMakeGeometryRequest(w, &request, &reply_return);
}

/*
* raise_tab
*
* This function gives the impression the tab is being raised.
*/
static void
raise_tab(Widget w)
{
   XtWidgetGeometry request, reply_return;

   request.stack_mode = TopIf;
   request.request_mode = CWStackMode;

   XtMakeGeometryRequest(w, &request, &reply_return);
}

static Boolean 
set_values(Widget old, 
           Widget request, 
           Widget c_new, 
           ArgList args,
           Cardinal *num_args)
{
   Boolean need_refresh = False;

   if(Tab_ArmColor(c_new) != Tab_ArmColor(old)) 
   {
      XtReleaseGC(c_new, Tab_FillGC(c_new));
      create_fill_GC(c_new);
      need_refresh = True;
   }
   if(XtBackground(c_new) != XtBackground(old)) 
   {
      XtReleaseGC(c_new, Tab_BackgroundGC(c_new));
      create_background_GC(c_new);
      need_refresh = True;
   }

   if(Tab_ArmPixmap(c_new) != Tab_ArmPixmap(old)
      && Lab_IsPixmap(c_new)
      && Tab_Armed(c_new))
   {
      need_refresh = True;
   }

   if(Lab_Pixmap(c_new) == XmUNSPECIFIED_PIXMAP 
      && Tab_ArmPixmap(c_new) != XmUNSPECIFIED_PIXMAP)
   {
      if(Lab_RecomputeSize(c_new) 
         && XtWidth(c_new) == XtWidth(old))
      {
         XtWidth(c_new) = 0;
      }
      if(Lab_RecomputeSize(c_new) 
         && XtHeight(c_new) == XtHeight(old))
      {
         XtHeight(c_new) = 0;
      }
      _XmCalcLabelDimensions(c_new);
      (*xmLabelClassRec.core_class.resize)(c_new);
   }

   if(Lab_Pixmap(c_new) != Lab_Pixmap(old)) 
   {
      Tab_UnarmPixmap(c_new) = Lab_Pixmap(c_new);
      if(Lab_IsPixmap(c_new) && !Tab_Armed(c_new))
      {
         need_refresh = True;
      }
   }

   if(Lab_IsPixmap(c_new) 
      && Tab_Armed(c_new)
      && Tab_ArmPixmap(c_new) != Tab_ArmPixmap(old))
   {
      if(Lab_RecomputeSize(c_new)
         && XtWidth(c_new) == XtWidth(old))
      {
         XtWidth(c_new) = 0;
      }
      if(Lab_RecomputeSize(c_new)
         && XtHeight(c_new) == XtHeight(old))
      {
         XtHeight(c_new) = 0;
      }
      _XmCalcLabelDimensions(c_new);
      (*xmLabelClassRec.core_class.resize)(c_new);
      need_refresh = True;
   }

   if(Tab_FillOnArm(c_new) != Tab_FillOnArm(old)
      && Tab_Armed(c_new))
   {
      need_refresh = True;
   }

   if(Tab_CornerStyle(c_new) != Tab_CornerStyle(old))
   {
      need_refresh = True;
   }

   if(Tab_CornerSize(c_new) != Tab_CornerSize(old))
   {
      need_refresh = True;
   }

   if(Tab_ShowAsActive(c_new) != Tab_ShowAsActive(old))
   {
      if (Tab_ShowAsActive(c_new)) 
      {
         raise_tab(c_new);
      }
      else
      {
         lower_tab(c_new);
      }
      need_refresh = True;
   }

   Unused(request);
   Unused(args);
   Unused(num_args);

   return need_refresh;
}

static void
Activate(Widget w, 
         XEvent *event, 
         _XtString *params, 
         Cardinal *num_params)
{
   XmAnyCallbackStruct cbs;
   XtExposeProc exp = XtClass(w)->core_class.expose;

   Tab_Armed(w) = False; 

   (*exp)(w,event,NULL);

   if (!Lab_SkipCallback(w) && Tab_ActivateCallback(w)) 
   {
      cbs.reason = XmCR_ACTIVATE;
      cbs.event = event;

      XFlush(XtDisplay(w));

      XtCallCallbackList(w, Tab_ActivateCallback(w), (XtPointer) &cbs);
   }
}

static void
Arm(Widget w, 
    XEvent *event, 
    _XtString *params, 
    Cardinal *num_params)
{
   XmTabCallbackStruct cbs;
   XtExposeProc exp = XtClass(w)->core_class.expose;

   XmProcessTraversal(w, XmTRAVERSE_CURRENT);

   Tab_Armed(w) = True;

   (*exp)(w, event, NULL);

   if (Tab_ArmCallback(w)) 
   {
      cbs.reason = XmCR_ARM;
      cbs.event = event;

      XFlush(XtDisplay(w));

      XtCallCallbackList(w,Tab_ArmCallback(w),(XtPointer)&cbs);
   }
}

static void 
ArmAndActivate(Widget w, 
               XEvent *event, 
               _XtString *params, 
               Cardinal *num_params)
{
   Arm(w,event,params,num_params);
   Activate(w,event,params,num_params);
}

static void Disarm(Widget w, 
                   XEvent *event, 
                   _XtString *params, 
                   Cardinal *num_params)
{
   XmTabCallbackStruct cbs;
   XtExposeProc exp = XtClass(w)->core_class.expose;

   if (Tab_Armed(w)) 
   {
      Tab_Armed(w) = False;
      (*exp)(w, event, NULL);
   }

   if (Tab_DisarmCallback(w)) 
   {
      cbs.reason = XmCR_DISARM;
      cbs.event = event;
 
      XFlush(XtDisplay(w));

      XtCallCallbackList(w,Tab_DisarmCallback(w),(XtPointer)&cbs);
   }
}

static void EnterWindow(Widget w, 
                        XEvent *event, 
                        _XtString *params, 
                        Cardinal *num_params)
{
   XtExposeProc exp = XtClass(w)->core_class.expose;

   _XmPrimitiveEnter(w, event, NULL, NULL);

   if(Tab_Armed(w))
   {
      (*exp)(w, event, NULL);
   }
}

static void Help(Widget w, 
                 XEvent *event, 
                 _XtString *params, 
                 Cardinal *num_params)
{
   /* invoke help callbacks */
   XtCallActionProc(w, "PrimitiveHelp", event, params, *num_params);
}

static void LeaveWindow(Widget w, 
                        XEvent *event, 
                        _XtString *params, 
                        Cardinal *num_params)
{
   XtExposeProc exp = XtClass(w)->core_class.expose;

   _XmPrimitiveLeave(w, event, NULL, NULL);
   if(Tab_Armed(w))
   {
      (*exp)(w, event, NULL);
   }
}

static void ProcessDrag(Widget w, 
                        XEvent *event, 
                        _XtString *params, 
                        Cardinal *num_params)
{
   #if 0
   printf("Fix me\n");
   #endif
}

/*
 * XmCreateTab
 *
 * Creates an instance of a particular widget class or compound object.
 */
Widget 
XmCreateTab(Widget parent, char *name, ArgList arglist, Cardinal cnt)
{
   return XtCreateWidget(name, 
                         xmTabWidgetClass,
                         parent, 
                         arglist, 
                         cnt);
}

