/*
 Copyright (C) 1997, 1999 Gerald L. Gay

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave,
 Cambridge, MA 02139, USA.
*/

#include <Xarm/SpinBox.h>

/*
* The SpinBox only exists in versions of Motif >= 2 and CDE.
* However, you could write one yourself and remove this restriction.
*/
#if XmVERSION >= 2 && ! defined(XARM_HAS_CDE)

void SpinBoxClass::values(Widget w, const char **l, const int c)
{
    int i;
    XmString *xmstr = new XmString [c];

    if (xmstr == NULL) return;

    for (i = 0; i < c; i++) {
        xmstr[i] = cvtStringToXmString(l[i]);
    }
 
    values(w, (XmStringTable)xmstr);
    numValues(w, c);

    for (i = 0; i < c; i++) {
        XmStringFree(xmstr[i]);
    }
    delete [] xmstr;
}

#endif
