/* $Id: Page.C,v 1.6 1999/11/06 05:51:01 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/

#include <Xarm/Page.h>
#include <Xmext/Property.h>

/* PropertyPageClass members */
/* resources */
void
PropertyPageClass::cancelLabelString(const char *s)
{
   Widget w = XmPropertySheetGetChild(XtParent(widget()),
                                      XmDIALOG_CANCEL_BUTTON); 
   if(w != NULL)
   {
      XmString xmstr = cvtStringToXmString(s);
      XtVaSetValues(w, XmNcancelLabelString, xmstr, NULL);
      XmStringFree(xmstr);
   }
   else
   {
      XtAppWarning(appContext(), "Could not find the cancel button on the "
                   "PropertyPage parent widget (which should be a Property "
                   "Sheet).");
   }
}

void
PropertyPageClass::setModified(Boolean b)
{
   Widget w = XmPropertySheetGetChild(XtParent(widget()), XmDIALOG_APPLY_BUTTON); 

   if(w != NULL)
   {
      XtSetSensitive(w, b);
   }
   else
   {
      XtAppWarning(appContext(), "Could not find the apply button on the "
                   "PropertyPage parent widget (which should be a Property "
                   "Sheet).");
   }
}

