/* $Id: ScrollBar.h,v 1.7 1999/11/06 05:50:59 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 Copyright (C) 1999       Gerald L. Gay
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(xarm_scrollbar_h)
#define xarm_scrollbar_h

/* ======================================================================= */
/* Include(s): */
#include <Xarm/Primitive.h>

class ScrollBarClass : public PrimitiveClass {
 protected:
   ScrollBarClass() {}
   virtual WidgetClass classPointer() { return xmScrollBarWidgetClass; }
   virtual _XtString className()      { return (_XtString) "XmScrollBar"; }
 public:
   /* Callbacks */
   void decrementCallback(XtCallbackProc fp, XtPointer data = NULL)
                                            { XARM_SET_CALLBACK(XmNdecrementCallback); }
   void dragCallback(XtCallbackProc fp, XtPointer data = NULL)
                                            { XARM_SET_CALLBACK(XmNdragCallback); }
   void incrementCallback(XtCallbackProc fp, XtPointer data = NULL)
                                            { XARM_SET_CALLBACK(XmNincrementCallback); }
   void pageDecrementCallback(XtCallbackProc fp, XtPointer data = NULL)
                                            { XARM_SET_CALLBACK(XmNpageDecrementCallback); }
   void pageIncrementCallback(XtCallbackProc fp, XtPointer data = NULL)
                                            { XARM_SET_CALLBACK(XmNpageIncrementCallback); }
   void toBottomCallback(XtCallbackProc fp, XtPointer data = NULL)
                                            { XARM_SET_CALLBACK(XmNtoBottomCallback); }
   void toTopCallback(XtCallbackProc fp, XtPointer data = NULL)
                                            { XARM_SET_CALLBACK(XmNtoTopCallback); }
   void valueChangedCallback(XtCallbackProc fp, XtPointer data = NULL)
                                            { XARM_SET_CALLBACK(XmNvalueChangedCallback); }

   /* Resources */
   void increment(int val)                     { XARM_SET_VALUE(XmNincrement); }
   int increment() const                       { XARM_GET_VALUE(int, XmNincrement); }
   void initialDelay(int val)                  { XARM_SET_VALUE(XmNinitialDelay); }
   int initialDelay() const                    { XARM_GET_VALUE(int, XmNinitialDelay); }
   void maximum(int val)                       { XARM_SET_VALUE(XmNmaximum); }
   int maximum() const                         { XARM_GET_VALUE(int, XmNmaximum); }
   void minimum(int val)                       { XARM_SET_VALUE(XmNminimum); }
   int minimum() const                         { XARM_GET_VALUE(int, XmNminimum); }
   void orientation(unsigned char val)         { XARM_SET_VALUE(XmNorientation); }
   unsigned char orientation() const           { XARM_GET_VALUE(unsigned char, XmNorientation); }
   void processingDirection(unsigned char val) { XARM_SET_VALUE(XmNprocessingDirection); }
   unsigned char processingDirection() const   { XARM_GET_VALUE(unsigned char, XmNprocessingDirection); }
   void repeatDelay(int val)                   { XARM_SET_VALUE(XmNrepeatDelay); }
   int repeatDelay() const                     { XARM_GET_VALUE(int, XmNrepeatDelay); }
   void showArrows(Boolean val)                { XARM_SET_VALUE(XmNshowArrows); }
   Boolean showArrows() const                  { XARM_GET_VALUE(Boolean, XmNshowArrows); }
   void sliderSize(int val)                    { XARM_SET_VALUE(XmNsliderSize); }
   int sliderSize() const                      { XARM_GET_VALUE(int, XmNsliderSize); }
   void troughColor(Pixel val)                 { XARM_SET_VALUE(XmNtroughColor); }
   Pixel troughColor() const                   { XARM_GET_VALUE(Pixel, XmNtroughColor); }
   void value(int val)                         { XARM_SET_VALUE(XmNvalue); }
   int value() const                           { XARM_GET_VALUE(int, XmNvalue); }

   // Additional functionality
   void troughColor(const char *val)           { XARM_SET_TYPED(XmNtroughColor); }
};

typedef XarmRawWidget<ScrollBarClass, false> ScrollBar;

#endif
