/* $Id: Manager.h,v 1.5 1999/11/06 05:50:58 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 Copyright (C) 1999       Gerald L. Gay
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(xarm_manager_h)
#define xarm_manager_h

/* ======================================================================= */
/* Include(s): */
#include <Xarm/Constraint.h>

class ManagerClass : public ConstraintClass {
 protected:
   ManagerClass() {}
 public:
   /* callbacks */
   void helpCallback(XtCallbackProc fp, XtPointer data = NULL) { XARM_SET_CALLBACK(XmNhelpCallback); }

   /* resources */
   void bottomShadowColor(Pixel val)          { XARM_SET_VALUE(XmNbottomShadowColor); }
   Pixel bottomShadowColor() const            { XARM_GET_VALUE(Pixel, XmNbottomShadowColor); }
   void bottomShadowPixmap(Pixmap val)        { XARM_SET_VALUE(XmNbottomShadowPixmap); }
   Pixmap bottomShadowPixmap() const          { XARM_GET_VALUE(Pixmap, XmNbottomShadowColor); }
   void foreground(Pixel val)                 { XARM_SET_VALUE(XmNforeground); }
   Pixel foreground() const                   { XARM_GET_VALUE(Pixel, XmNforeground); }
   void highlightColor(Pixel val)             { XARM_SET_VALUE(XmNhighlightColor); }
   Pixel highlightColor() const               { XARM_GET_VALUE(Pixel, XmNhighlightColor); }
   void highlightPixmap(Pixmap val)           { XARM_SET_VALUE(XmNhighlightPixmap); }
   Pixmap highlightPixmap() const             { XARM_GET_VALUE(Pixmap, XmNhighlightPixmap); }
   void navigationType(XmNavigationType val)  { XARM_SET_VALUE(XmNnavigationType); }
   XmNavigationType navigationType() const    { XARM_GET_VALUE(XmNavigationType, XmNnavigationType); }
   void shadowThickness(Dimension val)        { XARM_SET_VALUE(XmNshadowThickness); }
   Dimension shadowThickness() const          { XARM_GET_VALUE(Dimension, XmNshadowThickness); }
   XmStringDirection stringDirection() const  { XARM_GET_VALUE(XmStringDirection, XmNstringDirection); }
   void topShadowColor(Pixel val)             { XARM_SET_VALUE(XmNtopShadowColor); }
   Pixel topShadowColor() const               { XARM_GET_VALUE(Pixel, XmNtopShadowColor); }
   void topShadowPixmap(Pixmap val)           { XARM_SET_VALUE(XmNtopShadowPixmap); }
   Pixmap topShadowPixmap() const             { XARM_GET_VALUE(Pixmap, XmNtopShadowPixmap); }
   void unitType(unsigned char val)           { XARM_SET_VALUE(XmNunitType); }
   unsigned char unitType() const             { XARM_GET_VALUE(unsigned char, XmNunitType); }
   void userData(XtPointer val)               { XARM_SET_VALUE(XmNuserData); }
   XtPointer userData() const                 { XARM_GET_VALUE(XtPointer, XmNuserData); }

   // Additional functionality
   void bottomShadowColor(const char *val)    { XARM_SET_TYPED(XmNbottomShadowColor); }
   void foreground(const char *val)           { XARM_SET_TYPED(XmNforeground); }
   void highlightColor(const char *val)       { XARM_SET_TYPED(XmNhighlightColor); }
   void topShadowColor(const char *val)       { XARM_SET_TYPED(XmNtopShadowColor); }
};

#endif
