/*
 Copyright (C) 1999 Gerald L. Gay
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(xarm_glwidgets_h)
#define xarm_glwidgets_h

#include <Xarm/Xarm.h>

#if defined(XARM_HAS_GL)

/*
 * Warning:  These classes diverge from the Motif 1.2 standard GUI.
 */

/*
 * It doesn't make much sense to be trying to build Xarm without Motif.
 * So we'll define this now and get it out of the way!.
 */

#if !defined(__GLX_MOTIF)
#define __GLX_MOTIF
#endif

/* ======================================================================= */
/* Include(s): */
#include <Xarm/Primitive.h>
#include <GL/MesaDrawingArea.h>
#include <GL/MesaWorkstation.h>

class GLDrawingAreaClass : public PrimitiveClass {

 protected:
   GLDrawingAreaClass() {} /* only a derived class can make this */
   virtual WidgetClass classPointer()  { return glwMDrawingAreaWidgetClass; }
   virtual _XtString   className()     { return "GLDrawingArea"; }

 public:

   /* callbacks */
   void ginitCallback(XtCallbackProc fp, XtPointer data = NULL)
     { XARM_SET_CALLBACK(GLwNginitCallback); }
   void exposeCallback(XtCallbackProc fp, XtPointer data = NULL)
     { XARM_SET_CALLBACK(GLwNexposeCallback); }
   void inputCallback(XtCallbackProc fp, XtPointer data = NULL)
     { XARM_SET_CALLBACK(GLwNinputCallback); }
   void resizeCallback(XtCallbackProc fp, XtPointer data = NULL)
     { XARM_SET_CALLBACK(GLwNresizeCallback); }

   /* resources */
   /* NOTE: None of the resources are settable after creation! */
   int         *attribList() const               { XARM_GET_VALUE(int *, GLwNattribList); }
   XVisualInfo *visualInfo() const               { XARM_GET_VALUE(XVisualInfo *, GLwNvisualInfo); }
   Boolean      installColormap() const          { XARM_GET_VALUE(Boolean, GLwNinstallColormap); }
   Boolean      allocateBackground() const       { XARM_GET_VALUE(Boolean, GLwNallocateBackground); }
   Boolean      allocateOtherColors() const      { XARM_GET_VALUE(Boolean, GLwNallocateOtherColors); }
   Boolean      installBackground() const        { XARM_GET_VALUE(Boolean, GLwNinstallBackground); }
   Boolean      rgba() const                     { XARM_GET_VALUE(Boolean, GLwNrgba); }
   Boolean      doublebuffer() const             { XARM_GET_VALUE(Boolean, GLwNdoublebuffer); }
   Boolean      stereo() const                   { XARM_GET_VALUE(Boolean, GLwNstereo); }
   int          bufferSize() const               { XARM_GET_VALUE(int, GLwNbufferSize); }
   int          level() const                    { XARM_GET_VALUE(int, GLwNlevel); }
   int          auxBuffers() const               { XARM_GET_VALUE(int, GLwNauxBuffers); }
   int          redSize() const                  { XARM_GET_VALUE(int, GLwNredSize); }
   int          greenSize() const                { XARM_GET_VALUE(int, GLwNgreenSize); }
   int          blueSize() const                 { XARM_GET_VALUE(int, GLwNblueSize); }
   int          alphaSize() const                { XARM_GET_VALUE(int, GLwNalphaSize); }
   int          depthSize() const                { XARM_GET_VALUE(int, GLwNdepthSize); }
   int          stencilSize() const              { XARM_GET_VALUE(int, GLwNstencilSize); }
   int          accumRedSize() const             { XARM_GET_VALUE(int, GLwNaccumRedSize); }
   int          accumBlueSize() const            { XARM_GET_VALUE(int, GLwNaccumBlueSize); }
   int          accumGreenSize() const           { XARM_GET_VALUE(int, GLwNaccumGreenSize); }
   int          accumAlphaSize() const           { XARM_GET_VALUE(int, GLwNaccumAlphaSize); }

   /* functions */

   void makeCurrent(GLXContext ctx)   { GLwDrawingAreaMakeCurrent(widget(), ctx); }
   void swapBuffers()                 { GLwDrawingAreaSwapBuffers(widget()); }
   
};

class MesaDrawingAreaClass : public GLDrawingAreaClass {

 protected:
    MesaDrawingAreaClass() {} /* only a derived class can make this */
    virtual WidgetClass classPointer() { return mesaMDrawingAreaWidgetClass; }
    virtual _XtString   className()    { return "MesaDrawingArea"; }

 public:

    /* resources */
    void ximage(Boolean val)              { XARM_SET_VALUE(GLwNximage); }
    Boolean ximage() const                { XARM_GET_VALUE(Boolean, GLwNximage); }
    void shareLists(Boolean val)          { XARM_SET_VALUE(GLwNshareLists); }
    Boolean shareLists() const            { XARM_GET_VALUE(Boolean, GLwNshareLists); }
    Widget shareListsWith() const         { XARM_GET_VALUE(Widget, GLwNshareListsWith); }
    void shareListsWith(Widget val)       { XARM_SET_VALUE(GLwNshareListsWith); }
    /* Xarm convenience */
    void shareListsWith(WObjectClass *wo) { Widget val = wo->widget(); XARM_SET_VALUE(GLwNshareListsWith); }

    /* functions */
    void makeCurrent() { GLwMMakeCurrent(widget()); }
};

class MesaWorkstationClass : public MesaDrawingAreaClass {

 protected:
    MesaWorkstationsClass() {} /* only a derived class can make this */
    virtual WidgetClass classPointer()  { return mesaMWorkstationWidgetClass; }
    virtual _XtString   className()     { return "MesaWorkstation"; }

 public:

    /* no new resources */

    /* functions */
    void   beginProjection()                                      { GLwMBeginProjection(widget()); }
    void   endProjection()                                        { GLwMEndProjection(); }
    void   postProjectionList(GLuint val)                         { GLwMPostProjectionList(widget(), val); }
    void   postProjectionMatrix(GLdouble *m)                      { GLwMPostProjectionMatrix(widget(), m); }
    void   postCurrentProjection()                                { GLwMPostCurrentProjection(widget()); }
    void   unpostProjection()                                     { GLwMUnpostProjection(widget()); }
    GLuint getProjectionList()                                    { return GLwMGetProjectionList(widget()); }
    int    getProjectionMatrix(GLdouble *m)                       { return GLwMGetProjectionMatrix(widget(), m); }
    void   beginView()                                            { GLwMBeginView(widget()); }
    void   endView()                                              { GLwMEndView(); }
    void   postViewList(GLuint val)                               { GLwMPostViewList(widget(), val); }
    void   postViewMatrix(GLdouble *m)                            { GLwMPostViewMatrix(widget(), m); }
    void   postCurrentView()                                      { GLwMPostCurrentView(widget()); }
    void   unpostView()                                           { GLwMUnpostView(widget()); }
    GLuint getViewList()                                          { return GLwMGetViewList(widget()); }
    int    getViewMatrix(GLdouble *m)                             { return GLwMGetViewMatrix(widget(), m); }
    void   setPolarView(GLdouble r, GLdouble theta, GLdouble phi) { GLwMSetPolarView(widget(), r, theta, phi); }
    void   postObject(GLuint obj)                                 { GLwMPostObject(widget(), obj); }
    void   unpostObject(GLuint obj)                               { GLwMUnpostObject(widget(), obj); }
    void   unpostAllObjects()                                     { GLwMUnpostAllObjects(widget()); }
    void   redrawObjects()                                        { GLwMRedrawObjects(widget()); }
    void   postProjection(GLuint val)                             { GLwMPostProjection(widget(), val); }
    GLuint getProjection()                                        { return GLwMGetProjection(widget()); }
    void   postView(GLuint val)                                   { GLwMPostView(widget(), val); }
    GLuint getView()                                              { return GLwMGetView(widget()); }

    void setFrustrumProjection(GLdouble left,   GLdouble right,
                               GLdouble bottom, GLdouble top,
                               GLdouble near,   GLdouble far) 
        { GLwMSetFrustumProjection(widget(), left, right, bottom, top, near, far); }

    void setOrthoProjection(GLdouble left,   GLdouble right,
                            GLdouble bottom, GLdouble top,
                            GLdouble near,   GLdouble far) 
        { GLwMSetOrthoProjection(widget(), left, right, bottom, top, near, far); }

};

typedef XarmRawWidget<GLDrawingAreaClass, true>   GLDrawingArea;
typedef XarmRawWidget<MesaDrawingAreaClass, true> MesaDrawingArea;
typedef XarmRawWidget<MesaWorkstationClass, true> MesaWorkstation;

#endif

#endif
