/* $Id: FileSB.h,v 1.5 1999/11/06 05:50:58 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 Copyright (C) 1999       Gerald L. Gay
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(xarm_filesb_h)
#define xarm_filesb_h

/* ======================================================================= */
/* Include(s): */
#include <Xarm/SelectioB.h>

class FileSelectionBoxClass : public SelectionBoxClass {
 protected:
   FileSelectionBoxClass() {}
   virtual WidgetClass classPointer()              { return xmFileSelectionBoxWidgetClass; } 
   virtual _XtString className()                   { return (_XtString) "XmFileSelectionBox"; }
 public:
   /* convenience routines */
   virtual Widget getChild(unsigned char child)    { return XmFileSelectionBoxGetChild(widget(), child); }
   void doSearch(const char *str)                  { XARM_FSB_SEARCH; }

   /* resources */
   void directory(const char *str)                 { XARM_SET_STRING(XmNdirectory); }
   char *directory() const                         { XARM_GET_STRING(XmNdirectory); }
   void directoryValid(Boolean val)                { XARM_SET_VALUE(XmNdirectoryValid); }
   Boolean directoryValid() const                  { XARM_GET_VALUE(Boolean, XmNdirectoryValid); }
   void dirListItems(const XmStringTable val)      { XARM_SET_VALUE(XmNdirListItems); }
   XmStringTable dirListItems() const              { XARM_GET_VALUE(XmStringTable, XmNdirListItems); }
   void dirListItemCount(int val)                  { XARM_SET_VALUE(XmNdirListItemCount); }
   int dirListItemCount() const                    { XARM_GET_VALUE(int, XmNdirListItemCount); }
   void dirListLabelString(const char *str)        { XARM_SET_STRING(XmNdirListLabelString); }
   char *dirListLabelString() const                { XARM_GET_STRING(XmNdirListLabelString); }
   void dirMask(const char *str)                   { XARM_SET_STRING(XmNdirMask); }
   char *dirMask() const                           { XARM_GET_STRING(XmNdirMask); }
   void dirSearchProc(XmSearchProc val)            { XARM_SET_VALUE(XmNdirSearchProc); }
   XmSearchProc dirSearchProc() const              { XARM_GET_VALUE(XmSearchProc, XmNdirSearchProc); }
   void dirSpec(const char *str)                   { XARM_SET_STRING(XmNdirSpec); }
   char *dirSpec() const                           { XARM_GET_STRING(XmNdirSpec); }
   void fileListItems(const XmStringTable val)     { XARM_SET_VALUE(XmNfileListItems); }
   XmStringTable fileListItems() const             { XARM_GET_VALUE(XmStringTable, XmNfileListItems); }
   void fileListItemCount(int val)                 { XARM_SET_VALUE(XmNfileListItemCount); }
   int fileListItemCount() const                   { XARM_GET_VALUE(int, XmNfileListItemCount); }
   void fileListLabelString(const char *str)       { XARM_SET_STRING(XmNfileListLabelString); }
   char *fileListLabelString() const               { XARM_GET_STRING(XmNfileListLabelString); }
   void fileSearchProc(XmSearchProc val)           { XARM_SET_VALUE(XmNfileSearchProc); }
   XmSearchProc fileSearchProc() const             { XARM_GET_VALUE(XmSearchProc, XmNfileSearchProc); }
   void fileTypeMask(unsigned char val)            { XARM_SET_VALUE(XmNfileTypeMask); }
   unsigned char fileTypeMask() const              { XARM_GET_VALUE(unsigned char, XmNfileTypeMask); }
   void filterLabelString(const char *str)         { XARM_SET_STRING(XmNfilterLabelString); }
   char *filterLabelString() const                 { XARM_GET_STRING(XmNfilterLabelString); }
   void listUpdated(Boolean val)                   { XARM_SET_VALUE(XmNlistUpdated); }
   Boolean listUpdated() const                     { XARM_GET_VALUE(Boolean, XmNlistUpdated); }
   void noMatchString(const char *str)             { XARM_SET_STRING(XmNnoMatchString); }
   char *noMatchString() const                     { XARM_GET_STRING(XmNnoMatchString); }
   void pattern(const char *str)                   { XARM_SET_STRING(XmNpattern); }
   char * pattern() const                          { XARM_GET_STRING(XmNpattern); }
   void qualifySearchDataProc(XmQualifyProc val)   { XARM_SET_VALUE(XmNqualifySearchDataProc); }
   XmQualifyProc qualifySearchDataProc() const     { XARM_GET_VALUE(XmQualifyProc, XmNqualifySearchDataProc); }
   
 
};

typedef XarmRawWidget<FileSelectionBoxClass, false> FileSelectionBox;

typedef XarmFuncWidget<FileSelectionBoxClass, XmCreateFileSelectionDialog, false> FileSelectionDialog;

#endif
