/* $Id: Command.h,v 1.5 1999/11/06 05:50:57 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 Copyright (C) 1999       Gerald L. Gay
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(xarm_command_h)
#define xarm_command_h

/* ======================================================================= */
/* Include(s): */
#include <Xarm/SelectioB.h>

class CommandBoxClass : public SelectionBoxClass {
 protected:
   CommandBoxClass() {}
   virtual WidgetClass classPointer() { return xmCommandWidgetClass; }
   virtual _XtString className() { return (_XtString) "XmCommand"; }
 public:
   /* Callacks */
   void changedCallback(XtCallbackProc fp, XtPointer data = NULL) { XARM_SET_CALLBACK(XmNcommandChangedCallback); }
   void enteredCallback(XtCallbackProc fp, XtPointer data = NULL) { XARM_SET_CALLBACK(XmNcommandEnteredCallback); }

   /* resources */
   void command(const char *str)              { XARM_SET_STRING(XmNcommand); }
   char *command() const                      { XARM_GET_STRING(XmNcommand); }
   void historyItems(const XmStringTable val) { XARM_SET_VALUE(XmNhistoryItems); }
   XmStringTable historyItems() const         { XARM_GET_VALUE(XmStringTable, XmNhistoryItems); }
   void historyItemCount(int val)             { XARM_SET_VALUE(XmNhistoryItemCount); }
   int historyItemCount() const               { XARM_GET_VALUE(int, XmNhistoryItemCount); }
   void historyMaxItems(int val)              { XARM_SET_VALUE(XmNhistoryMaxItems); }
   int historyMaxItems() const                { XARM_GET_VALUE(int, XmNhistoryMaxItems); }
   void historyVisibleItemCount(int val)      { XARM_SET_VALUE(XmNhistoryVisibleItemCount); }
   int historyVisibleItemCount() const        { XARM_GET_VALUE(int, XmNhistoryVisibleItemCount); }
   void promptString(const char *str)         { XARM_SET_STRING(XmNpromptString); }
   char *promptString() const                 { XARM_GET_STRING(XmNpromptString); }
};

typedef XarmRawWidget<CommandBoxClass, true> CommandBox;

#endif
