/* $Id: CascadeBG.h,v 1.5 1999/11/06 05:50:57 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 Copyright (C) 1999       Gerald L. Gay
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(xarm_cascadebg_h)
#define xarm_cascadebg_h

/* ======================================================================= */
/* Include(s): */
#include <Xarm/LabelG.h>

class CascadeButtonGadgetClass : public LabelGadgetClass {
 protected:
   CascadeButtonGadgetClass() {}
   virtual WidgetClass classPointer() { return xmCascadeButtonGadgetClass; }
   virtual _XtString className() { return (_XtString) "XmCascadeButtonGadget"; }
 public:
   /* callbacks */
   void activateCallback(XtCallbackProc fp, XtPointer data = NULL)  { XARM_SET_CALLBACK(XmNactivateCallback); }
   void cascadingCallback(XtCallbackProc fp, XtPointer data = NULL) { XARM_SET_CALLBACK(XmNcascadingCallback); }

   /* resources */
   void   cascadePixmap(const Pixmap val)  { XARM_SET_VALUE(XmNcascadePixmap); }
   Pixmap cascadePixmap() const            { XARM_GET_VALUE(Pixmap, XmNcascadePixmap); }
   void   mappingDelay(int val)            { XARM_SET_VALUE(XmNmappingDelay); }
   int    mappingDelay() const             { XARM_GET_VALUE(int, XmNmappingDelay); }

   /* expects a PulldownMenu */
   void   subMenuId(Widget val)            { XARM_SET_VALUE(XmNsubMenuId); }
   Widget subMenuId() const                { XARM_GET_VALUE(Widget, XmNsubMenuId); }
};

class CascadeButtonGadget : public CascadeButtonGadgetClass {
 public:
   CascadeButtonGadget(Widget w_parent, const char *str, _XtString name = NULL);
   CascadeButtonGadget(Widget w_parent,
                       ArgList arglist = NULL, 
                       Cardinal cnt = 0,
                       _XtString name = NULL);
   CascadeButtonGadget(_XtString name, Widget w_parent);
   CascadeButtonGadget(Widget w_parent, XarmArg &args, _XtString name);
};

#endif
