/* $Id: Base.h,v 1.12 1999/11/06 05:50:57 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 Copyright (C) 1998, 1999 Gerald L. Gay
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(xarm_base_h)
#define xarm_base_h

/* ======================================================================= */
/* Include(s): */
#include <Xarm/CObject.h>
#include <Xarm/XarmArg.h>

#if !defined(DELETE_ON_CLOSE)
/*
*  If DELETE_ON_CLOSE is defined to be TRUE then the object will clean up 
*  allocated memory and the object is associated with the widget.  This 
*  assumes that new was used to create the object.
*  Otherwise the programmer must handle the memory management and
*  object association.
*
*  Delete if going out of scope and/or delete operator is used.
*  This should always be true unless you know what you're doing.
*/
#define DELETE_ON_CLOSE TRUE
#endif

/*
*  typedef's for the conversion routines. As you can see I did not like
*  the idea of using XmString.  Hence, I provided a nice utility
*  for doing the conversions to and from XmString. 
*/
typedef char * (*XmStringToStringFunc)(const XmString);
typedef XmString (*StringToXmStringFunc)(const char *);

/* Define the Window Object type */
class WObjectClass;
typedef WObjectClass *WObject;

/* 
*  This routine returns the WObject only if the widget is associated with one,
*  otherwise NULL is returned.
*/
WObject WidgetToWObject(Widget);

class WObjectClass : public CObject {
 private:
   friend WObject WidgetToWObject(Widget w);
   Widget wid;
   XtPointer tipData;
   static void destructor(Widget w,XtPointer data,XtPointer cdata);
   int isDelete;
   XmStringToStringFunc cvtXmStringToStringfp;
   StringToXmStringFunc cvtStringToXmStringfp;

   // Disallow copying
   WObjectClass(const WObjectClass &);
   WObjectClass &operator=(const WObjectClass &);

 protected:
   /* ATTENTION, default settings for cvt functions... */
   WObjectClass():wid(NULL),tipData(NULL), isDelete(FALSE),
               cvtXmStringToStringfp((XmStringToStringFunc)XmCvtXmStringToCT),
               cvtStringToXmStringfp((StringToXmStringFunc)XmCvtCTToXmString) {}
   void widget(const Widget w);
   virtual WidgetClass classPointer() = 0; /* pure virtual function */
   virtual _XtString className() = 0; /* pure virtual function */
   virtual Widget createWidget(_XtString name, 
                               Widget w_parent, 
                               ArgList arglist = NULL, 
                               Cardinal cnt = 0);
 public:
   /* ATTENTION, default behavior is (TRUE) user defined, TRUE = delete this 
      pointer when widget is destroyed. */
   void deleteOnClose(int option = DELETE_ON_CLOSE); 

   virtual ~WObjectClass();

   operator Widget() const ; // auto cast self to widget 
   operator Display*() const ; // auto cast self to Display *

   Display *display() const { return XtDisplay(widget()); }
   Widget widget()    const { return wid; }
   Widget parent()    const { return XtParent(widget()); }
   XtAppContext appContext() const;
   Window window() const { return XtWindow(widget()); }

   void destroyCallback(XtCallbackProc funcp, XtPointer data = NULL);  
   void addDestructor();
   void removeDestructor();

   void manage() { XtManageChild(*this); }
   void unmanage() { XtUnmanageChild(*this); }

   bool managed() const { return XtIsManaged(*this); }
   void managed(bool state) { state ? manage() : unmanage(); }

   /* Mapping and unmapping functions */
   /* Not strictly Motif, but useful! */

   void mapWindow()       { XMapWindow(display(), window()); }
   void unmapWindow()     { XUnmapWindow(display(), window()); }
   void unmapSubwindows() { XUnmapSubwindows(display(), window()); }

   /* Most functions that denote a parameter of char * use the cvt functions */
   /* Be careful when changing the cvt function! */
   
   /* Portability functions for different locales */
   void cvtXmStringToStringFunc(XmStringToStringFunc fp) { 
      cvtXmStringToStringfp = fp;
   }
   void cvtStringToXmStringFunc(StringToXmStringFunc fp) { 
      cvtStringToXmStringfp = fp;
   }
   /* All functions that use this cvt routine will clean up the allocated 
      memory.  Hence, don't worry about it.  Look at the source. */
   XmString cvtStringToXmString(const char *str) const {
      return (*cvtStringToXmStringfp)(str);
   }
   /* Clean up allocated memory pointed to by the return value when done. */
   char * cvtXmStringToString(const XmString str) const {
      return (*cvtXmStringToStringfp)(str);
   }

   /* get pixmap from a file if possible or return XmUNSPECIFIED_PIXMAP */
   Pixmap getPixmap(const char *fname) const;
   /* get pixmap from a data if possible or return XmUNSPECIFIED_PIXMAP */
   Pixmap getPixmapFromData(const char **pdata) const; 
   
   /* the callback routines */
   void addCallback(_XtString type, 
                    XtCallbackProc fp, 
                    XtPointer closure=NULL);
   void removeCallback(_XtString type,
                       XtCallbackProc fp,
                       XtPointer closure=NULL);
   void removeAllCallbacks(_XtString type);

   /* Make member function callback routines from class CObject visible */
   void addCallback(Widget w,
                    _XtString type, 
                    p_msg fp, 
                    XtPointer closure=NULL);
   void removeCallback(Widget w,
                       _XtString type,
                       p_msg fp,
                       XtPointer closure=NULL);
   void removeAllCallbacks(Widget w, _XtString type);

   /* protocol routines */
   Atom addWMProtocol(char *atom_name, Bool add_if_exists=False);
   void addProtocol(Atom property, Atom protocol_to_add);

   /* Convenience routines */
   Boolean processTraversal(XmTraversalDirection d = XmTRAVERSE_CURRENT)
       { return XmProcessTraversal(widget(), d); }
   Widget getFocusWidget() { return XmGetFocusWidget(widget()); }

   /* ToolTip functions.  All are static except add and remove */
   /* ToolTip Enable/Disable, Timeout, and Margin effect all tooltips */

   void addToolTip(const char *tip_text);
   void removeToolTip();

   static bool toolTipEnable();      /* Tooltips on or off */
   static bool toolTipEnable(const bool);  /* The set functions return the old value */

   static unsigned int toolTipMargin();
   static unsigned int toolTipMargin(const unsigned int);

   static unsigned long toolTipTimeout();
   static unsigned long toolTipTimeout(const unsigned long);

};

#endif
