/* $Id: Shell.C,v 1.1.1.1 1997/03/19 13:32:22 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/

#include <Xarm/Shell.h>

/* callbacks */
void 
ShellClass::popdownCallback(XtCallbackProc fp, XtPointer data)
{
   addCallback(XmNpopdownCallback,fp,data);
}

void 
ShellClass::popupCallback(XtCallbackProc fp, XtPointer data)
{
   addCallback(XmNpopupCallback,fp,data);
}

/* convenience routines */
void
ShellClass::activateProtocol(Atom property, Atom protocol)
{
   XmActivateProtocol(widget(),property, protocol);
}

void
ShellClass::activateWMProtocol(Atom protocol)
{
   XmActivateWMProtocol(widget(), protocol);
}

/* resources */
Boolean
ShellClass::allowShellResize() const
{
   Boolean b;
   XtVaGetValues(widget(),XmNallowShellResize, &b, NULL);
   return b;
}

void
ShellClass::createPopupChildProc(XtCreatePopupChildProc fp)
{
   XtVaSetValues(widget(),XmNcreatePopupChildProc, fp, NULL);
}

XtCreatePopupChildProc
ShellClass::createPopupChildProc()
{
   XtCreatePopupChildProc fp;
   XtVaGetValues(widget(),XmNcreatePopupChildProc, &fp, NULL);
   return fp;
}

void
ShellClass::geometry(const _XtString s)
{
   XtVaSetValues(widget(), XmNgeometry, s, NULL);
}

_XtString
ShellClass::geometry() const
{
   _XtString s;
   XtVaGetValues(widget(), XmNgeometry, &s, NULL);
   return s;
}

void
ShellClass::overrideRedirect(Boolean b)
{
   XtVaSetValues(widget(), XmNoverrideRedirect, b, NULL);
}

Boolean
ShellClass::overrideRedirect() const
{
   Boolean b;
   XtVaGetValues(widget(), XmNoverrideRedirect, &b, NULL);
   return b;
}

void
ShellClass::saveUnder(Boolean b)
{
   XtVaSetValues(widget(), XmNsaveUnder, b, NULL);
}

Boolean
ShellClass::saveUnder() const
{
   Boolean b;
   XtVaGetValues(widget(), XmNsaveUnder, &b, NULL);
   return b;
}

void
ShellClass::visual(const Visual *v)
{
   XtVaSetValues(widget(), XmNvisual, v, NULL);
}

Visual *
ShellClass::visual() const
{
   Visual *v;
   XtVaGetValues(widget(), XmNvisual, &v, NULL);
   return v;
}

