/* $Id: RowColumn.C,v 1.3 1998/07/24 18:53:30 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/

#include <Xarm/RowColumn.h>

/* callbacks */
void
RowColumnClass::entryCallback(XtCallbackProc funcp, XtPointer data)
{
   addCallback(XmNentryCallback, funcp, data);
}

void 
RowColumnClass::mapCallback(XtCallbackProc funcp, XtPointer data)
{
   addCallback(XmNmapCallback, funcp, data);
}

void 
RowColumnClass::tearOffMenuActivateCallback(XtCallbackProc funcp, XtPointer data)
{
   addCallback(XmNtearOffMenuActivateCallback, funcp, data);
}

void 
RowColumnClass::tearOffMenuDeactivateCallback(XtCallbackProc funcp, XtPointer data)
{
   addCallback(XmNtearOffMenuDeactivateCallback, funcp, data);
}

void 
RowColumnClass::unmapCallback(XtCallbackProc funcp, XtPointer data)
{
   addCallback(XmNunmapCallback, funcp, data);
}

/* resources */
void 
RowColumnClass::adjustLast(Boolean b)
{
   XtVaSetValues(widget(), XmNadjustLast, b, NULL);
}

Boolean 
RowColumnClass::adjustLast() const
{
   Boolean b;
   XtVaGetValues(widget(), XmNadjustLast, &b, NULL);
   return b;
}

void 
RowColumnClass::adjustMargin(Boolean b)
{
   XtVaSetValues(widget(), XmNadjustMargin, b, NULL);
}

Boolean 
RowColumnClass::adjustMargin() const
{
   Boolean b;
   XtVaGetValues(widget(), XmNadjustMargin, &b, NULL);
   return b;
}

void 
RowColumnClass::entryAlignment(unsigned char c)
{
   XtVaSetValues(widget(), XmNentryAlignment, c, NULL);
}

unsigned char 
RowColumnClass::entryAlignment() const
{
   unsigned char c;
   XtVaGetValues(widget(), XmNentryAlignment, &c, NULL);
   return c;
}

void 
RowColumnClass::entryBorder(Dimension d)
{
   XtVaSetValues(widget(), XmNentryBorder, d, NULL);
}

Dimension 
RowColumnClass::entryBorder() const
{
   Dimension d;
   XtVaGetValues(widget(), XmNentryBorder, &d, NULL);
   return d;
}

void 
RowColumnClass::entryClass(WidgetClass wc)
{
   XtVaSetValues(widget(), XmNentryClass, wc, NULL);
}

WidgetClass 
RowColumnClass::entryClass() const
{
   WidgetClass wc;
   XtVaGetValues(widget(), XmNentryClass, &wc, NULL);
   return wc;
}

void 
RowColumnClass::entryVerticalAlignment(unsigned char c)
{
   XtVaSetValues(widget(), XmNentryVerticalAlignment, c, NULL);
}

unsigned char 
RowColumnClass::entryVerticalAlignment() const
{
   unsigned char c;
   XtVaGetValues(widget(), XmNentryVerticalAlignment, &c, NULL);
   return c;
}

void 
RowColumnClass::isAligned(Boolean b)
{
   XtVaSetValues(widget(), XmNisAligned, b, NULL);
}

Boolean 
RowColumnClass::isAligned() const
{
   Boolean b;
   XtVaGetValues(widget(), XmNisAligned, &b, NULL);
   return b;
}

void 
RowColumnClass::isHomogeneous(Boolean b)
{
   XtVaSetValues(widget(), XmNisHomogeneous, b, NULL);
}

Boolean 
RowColumnClass::isHomogeneous() const
{
   Boolean b;
   XtVaGetValues(widget(), XmNisHomogeneous, &b, NULL);
   return b;
}

void 
RowColumnClass::marginHeight(Dimension d)
{
   XtVaSetValues(widget(), XmNmarginHeight, d, NULL);
}

Dimension 
RowColumnClass::marginHeight() const
{
   Dimension d;
   XtVaGetValues(widget(), XmNmarginHeight, &d, NULL);
   return d;
}

void 
RowColumnClass::marginWidth(Dimension d)
{
   XtVaSetValues(widget(), XmNmarginWidth, d, NULL);
}

Dimension 
RowColumnClass::marginWidth() const
{
   Dimension d;
   XtVaGetValues(widget(), XmNmarginWidth, &d, NULL);
   return d;
}

void 
RowColumnClass::menuAccelerator(const _XtString s)
{
   XtVaSetValues(widget(), XmNmenuAccelerator, s, NULL);
}

_XtString 
RowColumnClass::menuAccelerator() const
{
   _XtString s;
   XtVaGetValues(widget(), XmNmenuAccelerator, &s, NULL);
   return s;
}

void 
RowColumnClass::menuHelpWidget(Widget w)
{
   XtVaSetValues(widget(), XmNmenuHelpWidget, w, NULL);
}

Widget 
RowColumnClass::menuHelpWidget() const
{
   Widget w;
   XtVaGetValues(widget(), XmNmenuHelpWidget, &w, NULL);
   return w;
}

void 
RowColumnClass::menuHistory(Widget w)
{
   XtVaSetValues(widget(), XmNmenuHistory, w, NULL);
}

Widget 
RowColumnClass::menuHistory() const
{
   Widget w;
   XtVaGetValues(widget(), XmNmenuHistory, &w, NULL);
   return w;
}

void 
RowColumnClass::menuPost(const _XtString s)
{
   XtVaSetValues(widget(), XmNmenuPost, s, NULL);
}

_XtString 
RowColumnClass::menuPost() const
{
   _XtString s;
   XtVaGetValues(widget(), XmNmenuPost, &s, NULL);
   return s;
}

void 
RowColumnClass::mnemonic(KeySym k)
{
   XtVaSetValues(widget(), XmNmnemonic, k, NULL);
}

KeySym 
RowColumnClass::mnemonic() const
{
   KeySym k;
   XtVaGetValues(widget(), XmNmnemonic, &k, NULL);
   return k;
}

void 
RowColumnClass::mnemonicCharSet(const _XtString s)
{
   XtVaSetValues(widget(), XmNmnemonicCharSet, s, NULL);
}

_XtString 
RowColumnClass::mnemonicCharSet() const
{
   _XtString s;
   XtVaGetValues(widget(), XmNmnemonicCharSet, &s, NULL);
   return s;
}

void 
RowColumnClass::numColumns(short s)
{
   XtVaSetValues(widget(), XmNnumColumns, s, NULL);
}

short 
RowColumnClass::numColumns() const
{
   short s;
   XtVaGetValues(widget(), XmNnumColumns, &s, NULL);
   return s;
}

void 
RowColumnClass::orientation(unsigned char c)
{
   XtVaSetValues(widget(), XmNorientation, c, NULL);
}

unsigned char 
RowColumnClass::orientation() const
{
   unsigned char c;
   XtVaGetValues(widget(), XmNorientation, &c, NULL);
   return c;
}

void 
RowColumnClass::packing(unsigned char c)
{
   XtVaSetValues(widget(), XmNpacking, c, NULL);
}

unsigned char 
RowColumnClass::packing() const
{
   unsigned char c;
   XtVaGetValues(widget(), XmNpacking, &c, NULL);
   return c;
}

void 
RowColumnClass::popupEnabled(Boolean b)
{
   XtVaSetValues(widget(), XmNpopupEnabled, b, NULL);
}

Boolean 
RowColumnClass::popupEnabled() const
{
   Boolean b;
   XtVaGetValues(widget(), XmNpopupEnabled, &b, NULL);
   return b;
}

void 
RowColumnClass::radioAlwaysOne(Boolean b)
{
   XtVaSetValues(widget(), XmNradioAlwaysOne, b, NULL);
}

Boolean 
RowColumnClass::radioAlwaysOne() const
{
   Boolean b;
   XtVaGetValues(widget(), XmNradioAlwaysOne, &b, NULL);
   return b;
}

void 
RowColumnClass::radioBehavior(Boolean b)
{
   XtVaSetValues(widget(), XmNradioBehavior, b, NULL);
}

Boolean 
RowColumnClass::radioBehavior() const
{
   Boolean b;
   XtVaGetValues(widget(), XmNradioBehavior, &b, NULL);
   return b;
}

void 
RowColumnClass::resizeHeight(Boolean b)
{
   XtVaSetValues(widget(), XmNresizeHeight, b, NULL);
}

Boolean 
RowColumnClass::resizeHeight() const
{
   Boolean b;
   XtVaGetValues(widget(), XmNresizeHeight, &b, NULL);
   return b;
}

void 
RowColumnClass::resizeWidth(Boolean b)
{
   XtVaSetValues(widget(), XmNresizeWidth, b, NULL);
}

Boolean 
RowColumnClass::resizeWidth() const
{
   Boolean b;
   XtVaGetValues(widget(), XmNresizeWidth, &b, NULL);
   return b;
}

unsigned char 
RowColumnClass::rowColumnType() const
{
   unsigned char c;
   XtVaGetValues(widget(), XmNrowColumnType, &c, NULL);
   return c;
}

void 
RowColumnClass::spacing(Dimension d)
{
   XtVaSetValues(widget(), XmNspacing, d, NULL);
}

Dimension 
RowColumnClass::spacing() const
{
   Dimension d;
   XtVaGetValues(widget(), XmNspacing, &d, NULL);
   return d;
}

void 
RowColumnClass::subMenuId(Widget w)
{
   XtVaSetValues(widget(), XmNsubMenuId, w, NULL);
}

Widget 
RowColumnClass::subMenuId() const
{
   Widget w;
   XtVaGetValues(widget(), XmNsubMenuId, &w, NULL);
   return w;
}

void 
RowColumnClass::tearOffModel(unsigned char c)
{
   XtVaSetValues(widget(), XmNtearOffModel, c, NULL);
}

unsigned char 
RowColumnClass::tearOffModel() const
{
   unsigned char c;
   XtVaGetValues(widget(), XmNtearOffModel, &c, NULL);
   return c;
}

void 
RowColumnClass::whichButton(unsigned int i)
{
   XtVaSetValues(widget(), XmNwhichButton, i, NULL);
}

unsigned int 
RowColumnClass::whichButton() const
{
   unsigned int i;
   XtVaGetValues(widget(), XmNwhichButton, &i, NULL);
   return i;
}

Widget
RowColumn::createWidget(_XtString name,
                        Widget w_parent,
                        ArgList arglist,
                        Cardinal cnt)
{
   if(name == NULL || *name == '\0') { name = className(); }
   return XmCreateRowColumn(w_parent,name,arglist,cnt);
}

/* RowColumn constructor */
RowColumn::RowColumn(Widget w_parent, ArgList arglist, Cardinal cnt, _XtString name)
{
   Widget wid = createWidget(name, w_parent,arglist,cnt);
   widget(wid);
}

RowColumn::RowColumn(Widget w_parent, XarmArg &args, _XtString name)
{
   Widget wid = createWidget(name, w_parent,args.getArgs(), args.count());
   if (args.hasTypedArgs()) args.setTypedArgs(wid);
   widget(wid);
}

RowColumn::RowColumn(_XtString name, Widget w_parent)
{
   Widget wid = createWidget(name,w_parent);
   widget(wid);
}

Widget
PulldownMenu::createWidget(_XtString name,
                        Widget w_parent,
                        ArgList arglist,
                        Cardinal cnt)
{
   if(name == NULL || *name == '\0') { name = className(); }
   return XmCreatePulldownMenu(w_parent,name,arglist,cnt);
}

/* pulldown menu constructor */
PulldownMenu::PulldownMenu(Widget w_parent,
                           ArgList arglist,
                           Cardinal cnt,
                           _XtString name)
{
   Widget wid = createWidget(name,w_parent,arglist,cnt);
   widget(wid);
}

PulldownMenu::PulldownMenu(Widget w_parent, XarmArg &args, _XtString name)
{
   Widget wid = createWidget(name,w_parent,args.getArgs(), args.count());
   if (args.hasTypedArgs()) args.setTypedArgs(wid);
   widget(wid);
}

PulldownMenu::PulldownMenu(_XtString name, Widget w_parent)
{
   Widget wid = createWidget(name,w_parent);
   widget(wid);
}

Widget
OptionMenu::createWidget(_XtString name,
                        Widget w_parent,
                        ArgList arglist,
                        Cardinal cnt)
{
   if(name == NULL || *name == '\0') { name = className(); }
   return XmCreateOptionMenu(w_parent,name,arglist,cnt);
}

/* pulldown menu constructor */
OptionMenu::OptionMenu(Widget w_parent,
                       ArgList arglist,
                       Cardinal cnt,
                       _XtString name)
{
   Widget wid = createWidget(name,w_parent,arglist,cnt);
   widget(wid);
}

OptionMenu::OptionMenu(Widget w_parent, XarmArg &args, _XtString name)
{
   Widget wid = createWidget(name,w_parent,args.getArgs(), args.count());
   if (args.hasTypedArgs()) args.setTypedArgs(wid);
   widget(wid);
}

OptionMenu::OptionMenu(_XtString name, Widget w_parent)
{
   Widget wid = createWidget(name,w_parent);
   widget(wid);
}

Widget
PopupMenu::createWidget(_XtString name,
                        Widget w_parent,
                        ArgList arglist,
                        Cardinal cnt)
{
   if(name == NULL || *name == '\0') { name = className(); }
   return XmCreatePopupMenu(w_parent,name,arglist,cnt);
}

/* pulldown menu constructor */
PopupMenu::PopupMenu(Widget w_parent,
                     ArgList arglist,
                     Cardinal cnt,
                     _XtString name)
{
   Widget wid = createWidget(name,w_parent,arglist,cnt);
   widget(wid);
}

PopupMenu::PopupMenu(Widget w_parent, XarmArg &args, _XtString name)
{
   Widget wid = createWidget(name,w_parent,args.getArgs(), args.count());
   if (args.hasTypedArgs()) args.setTypedArgs(wid);
   widget(wid);
}

PopupMenu::PopupMenu(_XtString name, Widget w_parent)
{
   Widget wid = createWidget(name,w_parent);
   widget(wid);
}

