/* $Id: PushB.C,v 1.3 1998/07/24 18:53:29 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/

#include <Xarm/PushB.h>
/* PushButtonClass member functions */
void
PushButtonClass::autoSpace(int size)
{
   /* auto space buttons */
   int border = width();
   if(border < size) {
      int offset = (size-border)%2;
      border = (size - border)/2;
      XtVaSetValues(widget(),XmNmarginLeft,border,
         XmNmarginRight, ((Dimension) border+offset), NULL);
   } 
}

/* callbacks */
void
PushButtonClass::activateCallback(XtCallbackProc fp, XtPointer udata)
{
   addCallback(XmNactivateCallback,fp,udata);
}

void
PushButtonClass::armCallback(XtCallbackProc fp, XtPointer udata)
{
   addCallback(XmNarmCallback,fp,udata);
}

void
PushButtonClass::disarmCallback(XtCallbackProc fp, XtPointer udata)
{
   addCallback(XmNdisarmCallback,fp,udata);
}

/* resources */
void
PushButtonClass::armColor(Pixel p)
{
   XtVaSetValues(widget(),XmNarmColor, p, NULL);
}

void
PushButtonClass::armColor(const char *p)
{
   XtVaSetValues(widget(),
                 XtVaTypedArg, XmNarmColor, 
                 XmRString, p, (strlen(p) + 1),
                 NULL);
}

Pixel
PushButtonClass::armColor() const
{
   Pixel p;
   XtVaGetValues(widget(),XmNarmColor, &p, NULL);
   return p;
}

void
PushButtonClass::armPixmap(Pixmap p)
{
   XtVaSetValues(widget(),XmNarmPixmap, p, NULL);
}

Pixmap
PushButtonClass::armPixmap() const
{
   Pixel p;
   XtVaGetValues(widget(),XmNarmPixmap, &p, NULL);
   return p;
}

void
PushButtonClass::defaultButtonShadowThickness(Dimension d)
{
   XtVaSetValues(widget(),XmNdefaultButtonShadowThickness,d, NULL);
}

Dimension
PushButtonClass::defaultButtonShadowThickness() const
{
   Dimension d;
   XtVaGetValues(widget(),XmNdefaultButtonShadowThickness, &d, NULL);
   return d;
}

void
PushButtonClass::fillOnArm(Boolean b)
{
   XtVaSetValues(widget(),XmNfillOnArm,b, NULL);
}

Boolean
PushButtonClass::fillOnArm() const
{
   Boolean b;
   XtVaGetValues(widget(),XmNfillOnArm, &b, NULL);
   return b;
}

void
PushButtonClass::multiClick(unsigned char c)
{
   XtVaSetValues(widget(),XmNmultiClick,c, NULL);
}

unsigned char
PushButtonClass::multiClick() const
{
   unsigned char c;
   XtVaGetValues(widget(),XmNmultiClick, &c, NULL);
   return c;
}

void
PushButtonClass::showAsDefault(Dimension d)
{
   XtVaSetValues(widget(),XmNshowAsDefault, d, NULL);
}

Dimension
PushButtonClass::showAsDefault() const
{
   Dimension d;
   XtVaGetValues(widget(),XmNshowAsDefault, &d, NULL);
   return d;
}

/* constructors */

PushButton::PushButton(Widget w_parent, char *text, KeySym mn,
                _XtString acc, char *acc_text, _XtString name)
{
   Widget wid = createWidget(name, w_parent);
   widget(wid);
   labelString(text);

   alignment(XmALIGNMENT_BEGINNING);
   if(mn != 0) mnemonic(mn);
   if(acc) accelerator(acc);
   if(acc_text) acceleratorText(acc_text);

   manage();
}

PushButton::PushButton(Widget w_parent, ArgList arglist, Cardinal cnt, 
                       _XtString name)
{
   Widget wid = createWidget(name, w_parent, arglist, cnt);
   
   widget(wid);
   manage();
}

PushButton::PushButton(Widget w_parent, XarmArg &args, _XtString name)
{
   Widget wid = createWidget(name, w_parent, args.getArgs(), args.count());
   if (args.hasTypedArgs()) args.setTypedArgs(wid);
   widget(wid);
   manage();
}

PushButton::PushButton(_XtString name, Widget w_parent)
{
   Widget wid = createWidget(name, w_parent);
   
   widget(wid);
   manage();
}
