/* $Id: Page.C,v 1.3 1998/07/24 18:53:26 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/

#include <Xarm/Page.h>
#include <Xmext/Property.h>

/* PropertyPageClass members */
/* callbacks */
void
PropertyPageClass::cancelCallback(XtCallbackProc funcp, XtPointer data)
{
   addCallback(XmNcancelCallback,funcp,data);
}

void
PropertyPageClass::okCallback(XtCallbackProc funcp, XtPointer data)
{
   addCallback(XmNokCallback,funcp,data);
}

void
PropertyPageClass::applyCallback(XtCallbackProc funcp, XtPointer data)
{
   addCallback(XmNapplyCallback,funcp,data);
}

void
PropertyPageClass::setActiveCallback(XtCallbackProc funcp, XtPointer data)
{
   addCallback(XmNsetActiveCallback,funcp,data);
}

void
PropertyPageClass::killActiveCallback(XtCallbackProc funcp, XtPointer data)
{
   addCallback(XmNkillActiveCallback,funcp,data);
}

/* resources */
void
PropertyPageClass::cancelLabelString(const char *s)
{
   Widget w = XmPropertySheetGetChild(XtParent(widget()),
                                      XmDIALOG_CANCEL_BUTTON); 
   if(w != NULL)
   {
      XmString xmstr = cvtStringToXmString(s);
      XtVaSetValues(w, XmNcancelLabelString, xmstr, NULL);
      XmStringFree(xmstr);
   }
   else
   {
      XtAppWarning(appContext(), "Could not find the cancel button on the "
                   "PropertyPage parent widget (which should be a Property "
                   "Sheet).");
   }
}

void
PropertyPageClass::setModified(Boolean b)
{
   Widget w = XmPropertySheetGetChild(XtParent(widget()), XmDIALOG_APPLY_BUTTON); 

   if(w != NULL)
   {
      XtSetSensitive(w, b);
   }
   else
   {
      XtAppWarning(appContext(), "Could not find the apply button on the "
                   "PropertyPage parent widget (which should be a Property "
                   "Sheet).");
   }
}


Widget
PropertyPageClass::createWidget(_XtString name,
                       Widget w_parent,
                       ArgList arglist,
                       Cardinal cnt)
{
   if(name == NULL || *name == '\0') { name = className(); }
   return XmCreatePropertyPage(w_parent, name, arglist, cnt);
}

PropertyPage::PropertyPage(Widget w_parent, ArgList arglist, Cardinal cnt,
                             _XtString name)
{
   Widget w = createWidget(name, w_parent, arglist, cnt);
   widget(w);
}

PropertyPage::PropertyPage(Widget w_parent, XarmArg &args, _XtString name)
{
   Widget w = createWidget(name, w_parent, args.getArgs(), args.count());
   if (args.hasTypedArgs()) args.setTypedArgs(w);
   widget(w);
}

PropertyPage::PropertyPage(_XtString name, Widget w_parent)
{
   Widget w = createWidget(name, w_parent);
   widget(w);
}

