/* $Id: MessageB.C,v 1.5 1998/07/24 18:53:26 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/

#include <Xarm/MessageB.h>

/* MessageBoxClass Members */
/* convenience routines */
Widget
MessageBoxClass::getChild(unsigned char child)
{
   return XmMessageBoxGetChild(widget(), child);
}

/* callbacks */
void
MessageBoxClass::cancelCallback(XtCallbackProc funcp, XtPointer data)
{
   addCallback(XmNcancelCallback,funcp,data);
}

void
MessageBoxClass::okCallback(XtCallbackProc funcp, XtPointer data)
{
   addCallback(XmNokCallback,funcp,data);
}

/* resources */
void
MessageBoxClass::cancelLabelString(const char *s)
{
   XmString xmstr = cvtStringToXmString(s);
   XtVaSetValues(widget(), XmNcancelLabelString, xmstr, NULL);
   XmStringFree(xmstr);
}

char *
MessageBoxClass::cancelLabelString() const
{
   XmString xmstr;
   XtVaGetValues(widget(), XmNcancelLabelString, &xmstr, NULL);
   return cvtXmStringToString(xmstr);
}

void
MessageBoxClass::helpLabelString(const char *s)
{
   XmString xmstr = cvtStringToXmString(s);
   XtVaSetValues(widget(), XmNhelpLabelString, xmstr, NULL);
   XmStringFree(xmstr);
}

char *
MessageBoxClass::helpLabelString() const
{
   XmString xmstr;
   XtVaGetValues(widget(), XmNhelpLabelString, &xmstr, NULL);
   return cvtXmStringToString(xmstr);
}


void
MessageBoxClass::defaultButtonType(unsigned char c)
{
   XtVaSetValues(widget(), XmNdefaultButtonType, c, NULL);
}

unsigned char
MessageBoxClass::defaultButtonType() const
{
   unsigned char c;
   XtVaGetValues(widget(), XmNdefaultButtonType, &c, NULL);
   return c;
}

void
MessageBoxClass::dialogType(unsigned char c)
{
   XtVaSetValues(widget(), XmNdialogType, c, NULL);
}

unsigned char
MessageBoxClass::dialogType() const
{
   unsigned char c;
   XtVaGetValues(widget(), XmNdialogType, &c, NULL);
   return c;
}

void
MessageBoxClass::messageAlignment(unsigned char c)
{
   XtVaSetValues(widget(), XmNmessageAlignment, c, NULL);
}

unsigned char
MessageBoxClass::messageAlignment() const
{
   unsigned char c;
   XtVaGetValues(widget(), XmNmessageAlignment, &c, NULL);
   return c;
}

void
MessageBoxClass::messageString(const char *s)
{
   XmString xmstr = cvtStringToXmString(s);
   XtVaSetValues(widget(), XmNmessageString, xmstr, NULL);
   XmStringFree(xmstr);
}

char *
MessageBoxClass::messageString() const
{
   XmString xmstr;
   XtVaGetValues(widget(), XmNmessageString, &xmstr, NULL);
   return cvtXmStringToString(xmstr);
}

void
MessageBoxClass::minimizeButtons(Boolean b)
{
   XtVaSetValues(widget(), XmNminimizeButtons, b, NULL);
}

Boolean
MessageBoxClass::minimizeButtons() const
{
   Boolean b;
   XtVaGetValues(widget(), XmNminimizeButtons, &b, NULL);
   return b;
}

char *
MessageBoxClass::okLabelString() const
{
   XmString xmstr;
   XtVaGetValues(widget(), XmNokLabelString, &xmstr, NULL);
   return cvtXmStringToString(xmstr); 
}

void
MessageBoxClass::okLabelString(const char *s)
{
   XmString xmstr = cvtStringToXmString(s);
   XtVaSetValues(widget(), XmNokLabelString, xmstr, NULL);
   XmStringFree(xmstr); 
}

void
MessageBoxClass::symbolPixmap(Pixmap pixmap)
{
   XtVaSetValues(widget(), XmNsymbolPixmap, pixmap, NULL);
}

Pixmap
MessageBoxClass::symbolPixmap() const
{
   Pixmap pixmap;
   XtVaGetValues(widget(), XmNsymbolPixmap, &pixmap, NULL);
   return pixmap;
}

/* constructor */
Widget
MessageBox::createWidget(_XtString name, 
                           Widget w_parent, 
                           ArgList arglist,
                           Cardinal cnt)
{
   if (name == NULL || *name == '\0') { name = className(); }
   return XmCreateMessageBox(w_parent, name, arglist, cnt);
}

MessageBox::MessageBox(Widget w_parent, char *mesg, _XtString name)
{
   Widget w = createWidget(name, w_parent);
   widget(w);
   messageString(mesg);
   manage();
}

MessageBox::MessageBox(Widget w_parent,
                       ArgList arglist,
                       Cardinal cnt,
                       _XtString name)
{
   Widget w = createWidget(name, w_parent, arglist, cnt);

   widget(w);
   manage();
}

MessageBox::MessageBox(Widget w_parent, XarmArg &args, _XtString name)
{
   Widget w = createWidget(name, w_parent, args.getArgs(), args.count());
   if (args.hasTypedArgs()) args.setTypedArgs(w);
   widget(w);
   manage();
}

MessageBox::MessageBox(_XtString name, Widget w_parent)
{
   Widget w = createWidget(name, w_parent);
   widget(w);
   manage();
}

Widget
MessageDialog::createWidget(_XtString name, 
                           Widget w_parent, 
                           ArgList arglist,
                           Cardinal cnt)
{
   if (name == NULL || *name == '\0') { name = className(); }
   return XmCreateMessageDialog(w_parent, name, arglist, cnt);
}

MessageDialog::MessageDialog(Widget w_parent, char *mesg, _XtString name)
{
   Widget w = createWidget(name,w_parent);
   widget(w);
   messageString(mesg);
}

MessageDialog::MessageDialog(Widget w_parent,
                             ArgList arglist,
                             Cardinal cnt,
                             _XtString name)
{
   Widget w = createWidget(name,w_parent, arglist, cnt);
   widget(w);
}

MessageDialog::MessageDialog(Widget w_parent, XarmArg &args, _XtString name)
{
   Widget w = createWidget(name,w_parent, args.getArgs(), args.count());
   if (args.hasTypedArgs()) args.setTypedArgs(w);
   widget(w);
}

MessageDialog::MessageDialog(_XtString name, Widget w_parent)
{
   Widget w = createWidget(name,w_parent);
   widget(w);
}

Widget
InformationDialog::createWidget(_XtString name, 
                                Widget w_parent, 
                                ArgList arglist,
                                Cardinal cnt)
{
   if (name == NULL || *name == '\0') { name = className(); }
   return XmCreateInformationDialog(w_parent, name, arglist, cnt);
}

InformationDialog::InformationDialog(Widget w_parent, char *mesg, _XtString name)
{
   Widget w = createWidget(name, w_parent);
   widget(w);
   messageString(mesg);
}

InformationDialog::InformationDialog(Widget w_parent,
                                     ArgList arglist,
                                     Cardinal cnt,
                                     _XtString name)
{
   Widget w = createWidget(name, w_parent, arglist, cnt);

   widget(w);
}

InformationDialog::InformationDialog(Widget w_parent, XarmArg &args, _XtString name)
{
   Widget w = createWidget(name, w_parent, args.getArgs(), args.count());
   if (args.hasTypedArgs()) args.setTypedArgs(w);
   widget(w);
}

InformationDialog::InformationDialog(_XtString name, Widget w_parent)
{
   Widget w = createWidget(name, w_parent);

   widget(w);
}

Widget
QuestionDialog::createWidget(_XtString name, 
                          Widget w_parent, 
                          ArgList arglist,
                          Cardinal cnt)
{
   if (name == NULL || *name == '\0') { name = className(); }
   return XmCreateQuestionDialog(w_parent, name, arglist, cnt);
}

QuestionDialog::QuestionDialog(Widget w_parent, char *mesg, _XtString name)
{
   Widget w = createWidget(name, w_parent);
   widget(w);
   messageString(mesg);
}

QuestionDialog::QuestionDialog(Widget w_parent,
                               ArgList arglist,
                               Cardinal cnt,
                               _XtString name)
{
   Widget w = createWidget(name, w_parent, arglist, cnt);
   widget(w);
}

QuestionDialog::QuestionDialog(Widget w_parent, XarmArg &args, _XtString name)
{
   Widget w = createWidget(name, w_parent, args.getArgs(), args.count());
   if (args.hasTypedArgs()) args.setTypedArgs(w);
   widget(w);
}

QuestionDialog::QuestionDialog(_XtString name, Widget w_parent)
{
    Widget w = createWidget(name, w_parent);
    widget(w);
}

Widget
WarningDialog::createWidget(_XtString name, 
                          Widget w_parent, 
                          ArgList arglist,
                          Cardinal cnt)
{
   if (name == NULL || *name == '\0') { name = className(); }
   return XmCreateWarningDialog(w_parent, name, arglist, cnt);
}

WarningDialog::WarningDialog(Widget w_parent, char *mesg, _XtString name)
{
   Widget w = createWidget(name, w_parent);
   widget(w);
   messageString(mesg);
}

WarningDialog::WarningDialog(Widget w_parent, 
                             ArgList arglist,
                             Cardinal cnt,
                             _XtString name)
{
   Widget w = createWidget(name, w_parent, arglist, cnt);
   widget(w);
}

WarningDialog::WarningDialog(Widget w_parent, XarmArg &args, _XtString name)
{
   Widget w = createWidget(name, w_parent, args.getArgs(), args.count());
   if (args.hasTypedArgs()) args.setTypedArgs(w);
   widget(w);
}

WarningDialog::WarningDialog(_XtString name, Widget w_parent)
{
   Widget w = createWidget(name, w_parent);
   widget(w);
}

Widget
WorkingDialog::createWidget(_XtString name, 
                          Widget w_parent, 
                          ArgList arglist,
                          Cardinal cnt)
{
   if (name == NULL || *name == '\0') { name = className(); }
   return XmCreateWorkingDialog(w_parent, name, arglist, cnt);
}

WorkingDialog::WorkingDialog(Widget w_parent, char *mesg, _XtString name)
{
   Widget w = createWidget(name, w_parent);
   widget(w);
   messageString(mesg);
}

WorkingDialog::WorkingDialog(Widget w_parent,
                             ArgList arglist,
                             Cardinal cnt,
                             _XtString name)
{
   Widget w = createWidget(name, w_parent, arglist, cnt);
   widget(w);
}

WorkingDialog::WorkingDialog(Widget w_parent, XarmArg &args, _XtString name)
{
   Widget w = createWidget(name, w_parent, args.getArgs(), args.count());
   if (args.hasTypedArgs()) args.setTypedArgs(w);
   widget(w);
}

WorkingDialog::WorkingDialog(_XtString name, Widget w_parent)
{
   Widget w = createWidget(name, w_parent);
   widget(w);
}

Widget
ErrorDialog::createWidget(_XtString name, 
                          Widget w_parent, 
                          ArgList arglist,
                          Cardinal cnt)
{
   if (name == NULL || *name == '\0') { name = className(); }
   return XmCreateErrorDialog(w_parent, 
                              name,
                              arglist,
                              cnt);
}

ErrorDialog::ErrorDialog(Widget w_parent, char *mesg, _XtString name)
{
   Widget w = createWidget(name, w_parent);
   widget(w);
   messageString(mesg);
}

ErrorDialog::ErrorDialog(Widget w_parent, 
                         ArgList arglist,
                         Cardinal cnt,
                         _XtString name)
{
   Widget w = createWidget(name, w_parent, arglist, cnt); 
   widget(w);
}

ErrorDialog::ErrorDialog(Widget w_parent, XarmArg &args, _XtString name)
{
   Widget w = createWidget(name, w_parent, args.getArgs(), args.count());
   if (args.hasTypedArgs()) args.setTypedArgs(w);
   widget(w);
}

ErrorDialog::ErrorDialog(_XtString name, Widget w_parent)
{
   Widget w = createWidget(name, w_parent); 
   widget(w);
}

