/* $Id: LabelG.C,v 1.4 1999/01/15 01:22:09 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/

#include <Xarm/LabelG.h>
/* LabelGadgetClass Members */

void
LabelGadgetClass::accelerator(const _XtString acc)
{
   XtVaSetValues(widget(),XmNaccelerator,acc,NULL);
}

_XtString
LabelGadgetClass::accelerator() const
{
   _XtString acc;
   XtVaGetValues(widget(),XmNaccelerator, &acc,NULL);
   return acc;
}

void
LabelGadgetClass::acceleratorText(const char *str)
{
   XmString xmstr = cvtStringToXmString(str);
   XtVaSetValues(widget(), XmNacceleratorText, xmstr, NULL);
   XmStringFree(xmstr);
}

char *
LabelGadgetClass::acceleratorText() const
{
   XmString xmstr;
   XtVaGetValues(widget(), XmNacceleratorText, &xmstr, NULL);
   return cvtXmStringToString(xmstr);
}

void
LabelGadgetClass::alignment(unsigned char setting)
{
   XtVaSetValues(widget(), XmNalignment, setting, NULL);
}

unsigned char
LabelGadgetClass::alignment() const
{
   unsigned char c;
   XtVaGetValues(widget(), XmNalignment, &c, NULL);
   return c;
}

void
LabelGadgetClass::fontList(const XmFontList fl)
{
   XtVaSetValues(widget(), XmNfontList, fl, NULL);
}

XmFontList
LabelGadgetClass::fontList() const
{
   XmFontList fl;
   XtVaGetValues(widget(), XmNfontList, &fl, NULL);
   return fl;
}

void
LabelGadgetClass::labelInsensitivePixmap(const Pixmap p)
{
   XtVaSetValues(widget(), XmNlabelInsensitivePixmap, p, NULL);
}

Pixmap
LabelGadgetClass::labelInsensitivePixmap() const
{
   Pixmap p;
   XtVaGetValues(widget(), XmNlabelInsensitivePixmap, &p, NULL);
   return p;
}

void
LabelGadgetClass::labelPixmap(const Pixmap p)
{
   XtVaSetValues(widget(), XmNlabelPixmap, p, NULL);
}

Pixmap
LabelGadgetClass::labelPixmap() const
{
   Pixmap p;
   XtVaGetValues(widget(), XmNlabelPixmap, &p, NULL);
   return p;
}

void
LabelGadgetClass::labelString(const char *s)
{
   XmString xmstr = cvtStringToXmString(s);
   XtVaSetValues(widget(), XmNlabelString, xmstr, NULL);
   XmStringFree(xmstr);
}

char *
LabelGadgetClass::labelString() const
{
   XmString xmstr;
   XtVaGetValues(widget(), XmNlabelString, &xmstr, NULL);
   return cvtXmStringToString(xmstr);
}

void
LabelGadgetClass::labelType(unsigned char c)
{
   XtVaSetValues(widget(), XmNlabelType, c, NULL);
}

unsigned char
LabelGadgetClass::labelType() const
{
   unsigned char c;
   XtVaGetValues(widget(), XmNlabelType, &c, NULL);
   return c;
}

void
LabelGadgetClass::marginBottom(Dimension d)
{
   XtVaSetValues(widget(), XmNmarginBottom, d, NULL);
}

Dimension
LabelGadgetClass::marginBottom() const
{
   Dimension d;
   XtVaGetValues(widget(), XmNmarginBottom, &d, NULL);
   return d;
}

void
LabelGadgetClass::marginHeight(Dimension d)
{
   XtVaSetValues(widget(), XmNmarginHeight, d, NULL);
}

Dimension
LabelGadgetClass::marginHeight() const
{
   Dimension d;
   XtVaGetValues(widget(), XmNmarginHeight, &d, NULL);
   return d;
}

void
LabelGadgetClass::marginLeft(Dimension d)
{
   XtVaSetValues(widget(), XmNmarginLeft, d, NULL);
}

Dimension
LabelGadgetClass::marginLeft() const
{
   Dimension d;
   XtVaGetValues(widget(), XmNmarginLeft, &d, NULL);
   return d;
}

void
LabelGadgetClass::marginRight(Dimension d)
{
   XtVaSetValues(widget(), XmNmarginRight, d, NULL);
}

Dimension
LabelGadgetClass::marginRight() const
{
   Dimension d;
   XtVaGetValues(widget(), XmNmarginRight, &d, NULL);
   return d;
}

void
LabelGadgetClass::marginTop(Dimension d)
{
   XtVaSetValues(widget(), XmNmarginTop, d, NULL);
}

Dimension
LabelGadgetClass::marginTop() const
{
   Dimension d;
   XtVaGetValues(widget(), XmNmarginTop, &d, NULL);
   return d;
}

void
LabelGadgetClass::marginWidth(Dimension d)
{
   XtVaSetValues(widget(), XmNmarginWidth, d, NULL);
}

Dimension
LabelGadgetClass::marginWidth() const
{
   Dimension d;
   XtVaGetValues(widget(), XmNmarginWidth, &d, NULL);
   return d;
}

void 
LabelGadgetClass::mnemonic(const KeySym ch) 
{
   XtVaSetValues(widget(),XmNmnemonic,ch,NULL);
}

KeySym
LabelGadgetClass::mnemonic() const
{
   KeySym ch;
   XtVaGetValues(widget(),XmNmnemonic,&ch,NULL);
   return ch;
}

void 
LabelGadgetClass::mnemonicCharSet(const _XtString str)
{
   XtVaSetValues(widget(),XmNmnemonicCharSet,str,NULL);
}

_XtString
LabelGadgetClass::mnemonicCharSet() const
{
   _XtString str;
   XtVaGetValues(widget(),XmNmnemonicCharSet,&str,NULL);
   return str;
}

void 
LabelGadgetClass::recomputeSize(Boolean expr)
{
   XtVaSetValues(widget(),XmNrecomputeSize,expr,NULL);
}

Boolean
LabelGadgetClass::recomputeSize() const
{
   Boolean b;
   XtVaGetValues(widget(),XmNrecomputeSize, &b,NULL);
   return b;
}

void
LabelGadgetClass::stringDirection(const XmStringDirection dir)
{
   XtVaSetValues(widget(), XmNstringDirection, dir, NULL);
}

XmStringDirection
LabelGadgetClass::stringDirection() const
{
   XmStringDirection dir;
   XtVaGetValues(widget(), XmNstringDirection, &dir, NULL);
   return dir;
}

LabelGadget::LabelGadget(Widget w_parent, ArgList arglist, Cardinal cnt, 
                         _XtString name)
{
   Widget wid = createWidget(name, w_parent, arglist, cnt);
   widget(wid);
   manage();
}

LabelGadget::LabelGadget(Widget w_parent, XarmArg &args, _XtString name)
{
   Widget wid = createWidget(name, w_parent, args.getArgs(), args.count());
   if (args.hasTypedArgs()) args.setTypedArgs(wid);
   widget(wid);
   manage();
}

LabelGadget::LabelGadget(_XtString name, Widget w_parent)
{
   Widget wid = createWidget(name, w_parent);
   widget(wid);
   manage();
}

LabelGadget::LabelGadget(Widget w_parent, const char *str, _XtString name)
{
   Widget wid = createWidget(name, w_parent);

   /* leave as example
   Widget wid = XtVaCreateWidget(name,
                               xmLabelGadgetClass,
                               w_parent,
                               NULL);
   */

   widget(wid);
   labelString(str);
   manage();
}


