/* $Id: Form.C,v 1.4 1999/01/15 10:07:02 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/

#include <Xarm/Form.h>

/* resources */
void 
FormClass::fractionBase(int i)
{
   XtVaSetValues(widget(),XmNfractionBase, i, NULL);
}

int 
FormClass::fractionBase() const
{
   int i;
   XtVaGetValues(widget(),XmNfractionBase, &i, NULL);
   return i;
}

void 
FormClass::horizontalSpacing(Dimension d)
{
   XtVaSetValues(widget(),XmNhorizontalSpacing,d,NULL);
}

Dimension 
FormClass::horizontalSpacing() const
{
   Dimension d;
   XtVaGetValues(widget(),XmNhorizontalSpacing, &d,NULL);
   return d;
}

void 
FormClass::rubberPositioning(Boolean b)
{
   XtVaSetValues(widget(),XmNrubberPositioning,b,NULL);
}

Boolean 
FormClass::rubberPositioning() const
{
   Boolean b;
   XtVaGetValues(widget(),XmNrubberPositioning, &b,NULL);
   return b;
}

void 
FormClass::verticalSpacing(Dimension d)
{
   XtVaSetValues(widget(),XmNverticalSpacing,d,NULL);
}

Dimension
FormClass::verticalSpacing() const
{
   Dimension d;
   XtVaGetValues(widget(),XmNverticalSpacing,&d,NULL);
   return d;
}

/* constructor */
Form::Form(Widget w_parent, ArgList arglist, Cardinal cnt, _XtString name)
{
   Widget wid = createWidget(name, w_parent, arglist, cnt);
   widget(wid);
}

Form::Form(Widget w_parent, XarmArg &args, _XtString name)
{
   Widget wid = createWidget(name, w_parent, args.getArgs(), args.count());
   if (args.hasTypedArgs()) args.setTypedArgs(wid);
   widget(wid);
}

Form::Form(_XtString name, Widget w_parent)
{
   Widget wid = createWidget(name, w_parent);
   widget(wid);
}

Widget
FormDialog::createWidget(_XtString name, 
                         Widget w_parent, 
                         ArgList arglist,
                         Cardinal cnt)
{

   if (name == NULL || *name == '\0') { name = className(); }
   return XmCreateFormDialog(w_parent, name , arglist, cnt);
}


FormDialog::FormDialog(Widget w_parent,
                       ArgList arglist,
                       Cardinal cnt,
                       _XtString name)
{
   Widget wid = createWidget(name, w_parent, arglist, cnt);
   widget(wid);
}

FormDialog::FormDialog(Widget w_parent, XarmArg &args, _XtString name)
{
   Widget wid = createWidget(name, w_parent, args.getArgs(), args.count());
   if (args.hasTypedArgs()) args.setTypedArgs(wid);
   widget(wid);
}

FormDialog::FormDialog(_XtString name, Widget w_parent)
{
   Widget wid = createWidget(name, w_parent);
   widget(wid);
}
