/* $Id: Command.C,v 1.4 1999/01/15 01:32:05 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


/* Include(s): */
#include <Xarm/Command.h>

/* CommandBoxClass Members */
void
CommandBoxClass::changedCallback(XtCallbackProc fp, XtPointer udata)
{
   addCallback(XmNcommandChangedCallback,fp,udata);
}

void
CommandBoxClass::enteredCallback(XtCallbackProc fp, XtPointer udata)
{
   addCallback(XmNcommandEnteredCallback,fp,udata);
}

void
CommandBoxClass::command(const char *str)
{
   XmString xmstr = cvtStringToXmString(str);
   XtVaSetValues(widget(), XmNcommand, xmstr, NULL);
   XmStringFree(xmstr);
}

char *
CommandBoxClass::command() const
{
   XmString xmstr;
   XtVaGetValues(widget(), XmNcommand, &xmstr, NULL);
   return cvtXmStringToString(xmstr);
}

void
CommandBoxClass::historyItems(const XmStringTable st)
{
   XtVaSetValues(widget(), XmNhistoryItems, st, NULL);
}

XmStringTable
CommandBoxClass::historyItems() const
{ 
   XmStringTable st;
   XtVaGetValues(widget(), XmNhistoryItems, &st, NULL);
   return st;
}

void
CommandBoxClass::historyItemCount(int no)
{
   XtVaSetValues(widget(), XmNhistoryItemCount, no, NULL);
}

int
CommandBoxClass::historyItemCount() const
{
   int no;
   XtVaGetValues(widget(), XmNhistoryItemCount, &no, NULL);
   return no;
}

void
CommandBoxClass::historyMaxItems(int no)
{
   XtVaSetValues(widget(), XmNhistoryMaxItems, no, NULL);
}

int
CommandBoxClass::historyMaxItems() const
{
   int no;
   XtVaGetValues(widget(), XmNhistoryMaxItems, &no, NULL);
   return no;
}

void
CommandBoxClass::historyVisibleItemCount(int no)
{
   XtVaSetValues(widget(), XmNhistoryVisibleItemCount, no, NULL);
}

int
CommandBoxClass::historyVisibleItemCount() const
{
   int no;
   XtVaGetValues(widget(), XmNhistoryVisibleItemCount, &no, NULL);
   return no;
}

void
CommandBoxClass::promptString(const char *str)
{
   XmString xmstr = cvtStringToXmString(str);
   XtVaSetValues(widget(), XmNpromptString, xmstr, NULL);
   XmStringFree(xmstr);
}

char *
CommandBoxClass::promptString() const
{
   XmString xmstr; 
   XtVaGetValues(widget(), XmNpromptString, &xmstr, NULL);
   return cvtXmStringToString(xmstr);
}

/* constructor */
CommandBox::CommandBox(Widget w_parent,
                       ArgList arglist,
                       Cardinal cnt,
                       _XtString name)
{
   Widget wid = createWidget(name, w_parent, arglist, cnt);
   widget(wid);
   manage();
}

CommandBox::CommandBox(Widget w_parent, XarmArg &args, _XtString name)
{
   Widget wid = createWidget(name, w_parent, args.getArgs(), args.count());
   if (args.hasTypedArgs()) args.setTypedArgs(wid);
   widget(wid);
   manage();
}

CommandBox::CommandBox(_XtString name, Widget w_parent)
{
   Widget wid = createWidget(name, w_parent);
   widget(wid);
   manage();
}

