/*
 Copyright (C) 1997 Gerald L. Gay

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave,
 Cambridge, MA 02139, USA.
*/

#include <Xarm/SpinBox.h>

/*
* The SpinBox only exists in versions of Motif >= 2 and CDE.
* However, you could write one yourself and remove this restriction.
*/
#ifdef XARM_HAS_CDE

/* callbacks */
void
SpinBoxClass::modifyVerifyCallback(XtCallbackProc fp, XtPointer udata)
{
   addCallback(DtNmodifyVerifyCallback,fp,udata);
}

void
SpinBoxClass::valueChangedCallback(XtCallbackProc fp, XtPointer udata)
{
   addCallback(DtNvalueChangedCallback,fp,udata);
}

/* resources */

void SpinBoxClass::arrowSize(Dimension d)
{
   XtVaSetValues(widget(),DtNarrowSize,d,NULL);
}

Dimension SpinBoxClass::arrowSize() const
{
   Dimension d;
   XtVaGetValues(widget(),DtNarrowSize, &d,NULL);
   return d;
}

void SpinBoxClass::arrowLayout(unsigned char c)
{
    XtVaSetValues(widget(), DtNarrowLayout, c, NULL);
}

unsigned char SpinBoxClass::arrowLayout() const
{
    unsigned char c;

    XtVaGetValues(widget(), DtNarrowLayout, &c, NULL);
    return c;
}

void SpinBoxClass::arrowSensitivity(unsigned char c)
{
    XtVaSetValues(widget(), DtNarrowSensitivity, c, NULL);
}

unsigned char SpinBoxClass::arrowSensitivity() const
{
    unsigned char c;

    XtVaGetValues(widget(), DtNarrowSensitivity, &c, NULL);
    return c;
}

unsigned char SpinBoxClass::spinBoxChildType() const
{
    unsigned char c;

    XtVaGetValues(widget(), DtNspinBoxChildType, &c, NULL);
    return c;
}

void SpinBoxClass::decimalPoints(short s)
{
    XtVaSetValues(widget(), DtNdecimalPoints, s, NULL);
}

short SpinBoxClass::decimalPoints() const
{
    short s;

    XtVaGetValues(widget(), DtNdecimalPoints, &s, NULL);
    return s;
}

void SpinBoxClass::initialDelay(unsigned int u)
{
    XtVaSetValues(widget(), DtNinitialDelay, u, NULL);
}

unsigned int SpinBoxClass::initialDelay() const
{
    unsigned int u;

    XtVaGetValues(widget(), DtNinitialDelay, &u, NULL);
    return u;
}

void SpinBoxClass::repeatDelay(unsigned int u)
{
    XtVaSetValues(widget(), DtNrepeatDelay, u, NULL);
}

unsigned int SpinBoxClass::repeatDelay() const
{
    unsigned int u;

    XtVaGetValues(widget(), DtNrepeatDelay, &u, NULL);
    return u;
}

void SpinBoxClass::incrementValue(int i)
{
    XtVaSetValues(widget(), DtNincrementValue, i, NULL);
}

int SpinBoxClass::incrementValue() const
{
    int i;

    XtVaGetValues(widget(), DtNincrementValue, &i, NULL);
    return i;
}

void SpinBoxClass::maximumValue(int i)
{
    XtVaSetValues(widget(), DtNmaximumValue, i, NULL);
}

int SpinBoxClass::maximumValue() const
{
    int i;

    XtVaGetValues(widget(), DtNmaximumValue, &i, NULL);
    return i;
}

void SpinBoxClass::minimumValue(int i)
{
    XtVaSetValues(widget(), DtNminimumValue, i, NULL);
}

int SpinBoxClass::minimumValue() const
{
    int i;

    XtVaGetValues(widget(), DtNminimumValue, &i, NULL);
    return i;
}

void SpinBoxClass::numValues(int i)
{
    XtVaSetValues(widget(), DtNnumValues, i, NULL);
}

int SpinBoxClass::numValues() const
{
    int i;

    XtVaGetValues(widget(), DtNnumValues, &i, NULL);
    return i;
}

void SpinBoxClass::position(int i)
{
    XtVaSetValues(widget(), DtNposition, i, NULL);
}

int SpinBoxClass::position() const
{
    int i;

    XtVaGetValues(widget(), DtNposition, &i, NULL);
    return i;
}

void SpinBoxClass::values(XmStringTable s)
{
    XtVaSetValues(widget(), DtNvalues, s, NULL);
}

XmStringTable SpinBoxClass::values() const
{
    XmStringTable s;

    XtVaGetValues(widget(), DtNvalues, &s, NULL);
    return s;
}

void SpinBoxClass::values(const char **l, const int c)
{
    int i;
    XmString *xmstr = new XmString [c];

    if (xmstr == NULL) return;

    for (i = 0; i < c; i++) {
        xmstr[i] = cvtStringToXmString(l[i]);
    }
 
    values((XmStringTable)xmstr);
    numValues(c);

    for (i = 0; i < c; i++) {
        XmStringFree(xmstr[i]);
    }
    delete [] xmstr;
}

void SpinBoxClass::add(const char *s, int pos)
{
    XmString xmstr = cvtStringToXmString(s);
    DtSpinBoxAddItem(widget(), xmstr, pos);
    XmStringFree(xmstr);
}

void SpinBoxClass::del(int pos)
{
    DtSpinBoxDeletePos(widget(), pos);
}

void SpinBoxClass::setItem(const char *s)
{
    XmString xmstr = cvtStringToXmString(s);
    DtSpinBoxSetItem(widget(), xmstr);
    XmStringFree(xmstr);
}

Widget
SpinBoxClass::createWidget(_XtString name,
                       Widget w_parent,
                       ArgList arglist,
                       Cardinal cnt)
{
   if(name == NULL || *name == '\0') { name = className(); }
   return DtCreateSpinBox(w_parent, name, arglist, cnt);
}

SpinBox::SpinBox(Widget w_parent,
            ArgList arglist, 
            Cardinal cnt,
            _XtString name)
{
   Widget w = createWidget(name, w_parent,arglist,cnt);
   widget(w);
}

SpinBox::SpinBox(Widget w_parent, XarmArg &args, _XtString name)
{
   Widget w = createWidget(name, w_parent, args.getArgs(), args.count());
   if (args.hasTypedArgs()) args.setTypedArgs(w);
   widget(w);
}

SpinBox::SpinBox(_XtString name, Widget w_parent)
{
   Widget w = createWidget(name, w_parent);
   widget(w);
}

#endif
