/* $Id: BulletinB.C,v 1.4 1999/01/14 03:35:18 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


/* Include(s): */
#include <Xarm/BulletinB.h>

/* BulletinBoardClass Members */
void
BulletinBoardClass::allowOverlap(Boolean b)
{
   XtVaSetValues(widget(), XmNallowOverlap, b, NULL);
}

Boolean 
BulletinBoardClass::allowOverlap() const
{
   Boolean b;
   XtVaGetValues(widget(), XmNallowOverlap, &b, NULL);
   return b;
}

Boolean 
BulletinBoardClass::autoUnmanage() const
{
   Boolean b;
   XtVaGetValues(widget(), XmNautoUnmanage, &b, NULL);
   return b;
}

void
BulletinBoardClass::buttonFontList(XmFontList fl)
{
   XtVaSetValues(widget(), XmNbuttonFontList, fl, NULL);
}

XmFontList
BulletinBoardClass::buttonFontList() const
{
   XmFontList fl;
   XtVaGetValues(widget(), XmNbuttonFontList, &fl, NULL);
   return fl;
}

void
BulletinBoardClass::cancelButton(Widget w)
{
   XtVaSetValues(widget(), XmNcancelButton, w, NULL);
}

Widget
BulletinBoardClass::cancelButton() const
{
   Widget w;
   XtVaGetValues(widget(), XmNcancelButton, &w, NULL);
   return w;
}

void
BulletinBoardClass::defaultButton(Widget w)
{
   XtVaSetValues(widget(), XmNdefaultButton, w, NULL);
}

Widget
BulletinBoardClass::defaultButton() const
{
   Widget w;
   XtVaGetValues(widget(), XmNdefaultButton, &w, NULL);
   return w;
}

void
BulletinBoardClass::defaultPosition(Boolean b)
{
   XtVaSetValues(widget(), XmNdefaultPosition, b, NULL);
}

Boolean
BulletinBoardClass::defaultPosition() const
{
   Boolean b;
   XtVaGetValues(widget(), XmNdefaultPosition, &b, NULL);
   return b;
}

void
BulletinBoardClass::dialogStyle(unsigned char s)
{
   XtVaSetValues(widget(), XmNdialogStyle, s, NULL);
}

unsigned char 
BulletinBoardClass::dialogStyle() const
{
   unsigned char s;
   XtVaGetValues(widget(), XmNdialogStyle, &s, NULL);
   return s;
}

void
BulletinBoardClass::dialogTitle(const char *str)
{
   XmString xmstr = cvtStringToXmString(str);
   XtVaSetValues(widget(), XmNdialogTitle, xmstr, NULL);
   XmStringFree(xmstr);
}

char *
BulletinBoardClass::dialogTitle() const
{
   XmString xmstr;
   XtVaGetValues(widget(), XmNdialogTitle, &xmstr, NULL);
   char *s = cvtXmStringToString(xmstr);
   XmStringFree(xmstr);
   return s;
}

void
BulletinBoardClass::focusCallback(XtCallbackProc fp, XtPointer udata)
{
   addCallback(XmNfocusCallback,fp,udata);
}

void
BulletinBoardClass::labelFontList(XmFontList fl)
{
   XtVaSetValues(widget(), XmNlabelFontList, fl, NULL);
}

XmFontList
BulletinBoardClass::labelFontList() const
{
   XmFontList fl;
   XtVaGetValues(widget(), XmNlabelFontList, &fl, NULL);
   return fl;
}

void
BulletinBoardClass::mapCallback(XtCallbackProc fp, XtPointer udata)
{
   addCallback(XmNmapCallback,fp,udata);
}

void
BulletinBoardClass::marginHeight(Dimension d)
{
   XtVaSetValues(widget(), XmNmarginHeight, d, NULL);
}

Dimension
BulletinBoardClass::marginHeight() const
{
   Dimension d;
   XtVaGetValues(widget(), XmNmarginHeight, &d, NULL);
   return d;
}

void
BulletinBoardClass::marginWidth(Dimension d)
{
   XtVaSetValues(widget(), XmNmarginWidth, d, NULL);
}

Dimension
BulletinBoardClass::marginWidth() const
{
   Dimension d;
   XtVaGetValues(widget(), XmNmarginWidth, &d, NULL);
   return d;
}

void
BulletinBoardClass::noResize(Boolean b)
{
   XtVaSetValues(widget(), XmNnoResize, b, NULL);
}

Boolean
BulletinBoardClass::noResize() const
{
   Boolean b;
   XtVaGetValues(widget(), XmNnoResize, &b, NULL);
   return b;
}

void
BulletinBoardClass::resizePolicy(unsigned char p)
{
   XtVaSetValues(widget(), XmNresizePolicy, p, NULL);
}

unsigned char
BulletinBoardClass::resizePolicy() const
{
   unsigned char p;
   XtVaGetValues(widget(), XmNresizePolicy, &p, NULL);
   return p;
}

void
BulletinBoardClass::shadowType(unsigned char s)
{
   XtVaSetValues(widget(), XmNshadowType, s, NULL);
}

unsigned char
BulletinBoardClass::shadowType() const
{
   unsigned char s;
   XtVaGetValues(widget(), XmNshadowType, &s, NULL);
   return s;
}

void
BulletinBoardClass::textFontList(XmFontList fl)
{
   XtVaSetValues(widget(), XmNtextFontList, fl, NULL);
}

XmFontList
BulletinBoardClass::textFontList() const
{
   XmFontList fl;
   XtVaGetValues(widget(), XmNtextFontList, &fl, NULL);
   return fl;
}

void
BulletinBoardClass::unmapCallback(XtCallbackProc fp, XtPointer udata)
{
   addCallback(XmNunmapCallback,fp,udata);
}

BulletinBoard::BulletinBoard(Widget w_parent, 
                             ArgList arglist,
                             Cardinal cnt,
                             _XtString name)
{
   Widget wid = createWidget(name, w_parent, arglist, cnt);

   widget(wid);
}

BulletinBoard::BulletinBoard(Widget w_parent, XarmArg &args, _XtString name)
{
   Widget wid = createWidget(name, w_parent, args.getArgs(), args.count());
   if (args.hasTypedArgs()) args.setTypedArgs(wid);
   widget(wid);
}


BulletinBoard::BulletinBoard(_XtString name, Widget w_parent)
{
   Widget wid = createWidget(name, w_parent);

   widget(wid);
}

