/* $Id: ArrowB.C,v 1.5 1999/01/14 03:35:18 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#include <Xarm/ArrowB.h>
/* ArrowButtonClass member functions */

void
ArrowButtonClass::activateCallback(XtCallbackProc fp, XtPointer udata)
{
   addCallback(XmNactivateCallback,fp,udata);
}

void
ArrowButtonClass::armCallback(XtCallbackProc fp, XtPointer udata)
{
   addCallback(XmNarmCallback,fp,udata);
}

void
ArrowButtonClass::disarmCallback(XtCallbackProc fp, XtPointer udata)
{
   addCallback(XmNdisarmCallback,fp,udata);
}

void
ArrowButtonClass::arrowDirection(unsigned char direction)
{
   XtVaSetValues(widget(),XmNarrowDirection,direction,NULL);
}

unsigned char ArrowButtonClass::arrowDirection() const
{
   unsigned char uc;

   XtVaGetValues(widget(), XmNarrowDirection, &uc, NULL);
   return uc;
}

unsigned char ArrowButtonClass::multiClick() const
{
    unsigned char uc;

    XtVaGetValues(widget(), XmNmultiClick, &uc, NULL);
    return uc;
}

void
ArrowButtonClass::multiClick(unsigned char click)
{
   XtVaSetValues(widget(),XmNmultiClick,click,NULL);
}

/* Arrow Button Constructor */

ArrowButton::ArrowButton(Widget w_parent, ArgList arglist, Cardinal cnt, _XtString name)
{
   Widget wid = createWidget(name, w_parent, arglist, cnt);

   widget(wid);
   manage();
}

ArrowButton::ArrowButton(Widget w_parent, XarmArg &args, _XtString name)
{
    Widget wid = createWidget(name, w_parent, args.getArgs(), args.count());
    if (args.hasTypedArgs()) args.setTypedArgs(wid);
    widget(wid);
    manage();
}

ArrowButton::ArrowButton(_XtString name, Widget w_parent)
{
   Widget wid = createWidget(name, w_parent);

   widget(wid);
   manage();
}

/* */
