/*
 Copyright (C) 1999, Gerald L. Gay
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License
 version 2 as published by the Free Software Foundation.
 
 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.
 
 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave,
 Cambridge, MA 02139, USA.
*/

#if !defined(_XARM_CAPTION_H)
#define _XARM_CAPTION_H

#include <Xarm/Xarm.h>
#include <Xarm/Manager.h>

#ifdef XARM_HAS_XBAE

#include <Xbae/Caption.h>

#ifndef Alignment
typedef unsigned char Alignment;
#endif

class CaptionClass : public ManagerClass {

  protected:

    CaptionClass() {}

    virtual WidgetClass classPointer() { return xbaeCaptionWidgetClass; }
    virtual _XtString   className()    { return (_XtString) "XbaeCaption"; }

  public:

    /* Resources */

    void                fontList(const XmFontList);
    XmFontList          fontList() const;
    void                labelAlignment(XbaeLabelAlignment);
    XbaeLabelAlignment  labelAlignment() const;
    void                labelOffset(int);
    int                 labelOffset() const;
    void                labelPixmap(Pixmap);
    Pixmap              labelPixmap() const;
    void                labelPosition(XbaeLabelPosition);
    XbaeLabelPosition   labelPosition() const;
    void                labelString(const char *);
    char *              labelString() const;
    void                labelTextAlignment(Alignment);
    Alignment           labelTextAlignment() const;
    void                labelType(unsigned char);
    unsigned char       labelType() const;

};

class Caption : public CaptionClass {

  public:

    Caption(Widget     w_parent,
	    ArgList    arglist = NULL,
	    Cardinal   cnt = 0,
	    _XtString  name = NULL);

    Caption(_XtString name, Widget w_parent);
    Caption(Widget w_parent, XarmArg &args, _XtString name);
};

#endif // XARM_HAS_XBAE

#endif // _XARM_CAPTION_H
