/* $Id: RowColumn.h,v 1.2 1997/04/07 15:33:21 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(_XARM_ROWCOLUMN_H_)
#define _XARM_ROWCOLUMN_H_

/* ======================================================================= */
/* Include(s): */
#include <Xarm/Manager.h>

class RowColumnClass : public ManagerClass {
 protected:
   RowColumnClass() {} /* only a derived class can make this */
   virtual WidgetClass classPointer() { return xmRowColumnWidgetClass; }
   virtual _XtString className() { return (_XtString) "XmRowColumn"; }
 public:
   /* callbacks */
   void entryCallback(XtCallbackProc funcp, XtPointer data = NULL);
   void mapCallback(XtCallbackProc funcp, XtPointer data = NULL);
   void tearOffMenuActivateCallback(XtCallbackProc funcp, XtPointer data = NULL);
   void tearOffMenuDeactivateCallback(XtCallbackProc funcp, XtPointer data = NULL);
   void unmapCallback(XtCallbackProc funcp, XtPointer data = NULL);

   /* resources */
   void adjustLast(Boolean b);
   Boolean adjustLast() const;
   void adjustMargin(Boolean b);
   Boolean adjustMargin() const;
   void entryAlignment(unsigned char c);
   unsigned char entryAlignment() const;
   void entryBorder(Dimension d);
   Dimension entryBorder() const;
   void entryClass(WidgetClass wc);
   WidgetClass entryClass() const;
   void entryVerticalAlignment(unsigned char c);
   unsigned char entryVerticalAlignment() const;
   void isAligned(Boolean b);
   Boolean isAligned() const;
   void isHomogeneous(Boolean b);
   Boolean isHomogeneous() const;
   void marginHeight(Dimension d);
   Dimension marginHeight() const;
   void marginWidth(Dimension d);
   Dimension marginWidth() const;
   void menuAccelerator(const _XtString s);
   _XtString menuAccelerator() const;
   void menuHelpWidget(Widget w);
   Widget menuHelpWidget() const;
   void menuHistory(Widget w);
   Widget menuHistory() const;
   void menuPost(const _XtString s);
   _XtString menuPost() const;
   void mnemonic(KeySym k);
   KeySym mnemonic() const;
   void mnemonicCharSet(const _XtString s);
   _XtString mnemonicCharSet() const;
   void numColumns(short s);
   short numColumns() const;
   void orientation(unsigned char c);
   unsigned char orientation() const;
   void packing(unsigned char c);
   unsigned char packing() const;
   void popupEnabled(Boolean b);
   Boolean popupEnabled() const;
   void radioAlwaysOne(Boolean b);
   Boolean radioAlwaysOne() const;
   void radioBehavior(Boolean b);
   Boolean radioBehavior() const;
   void resizeHeight(Boolean b);
   Boolean resizeHeight() const;
   void resizeWidth(Boolean b);
   Boolean resizeWidth() const;
   unsigned char rowColumnType() const;
   void spacing(Dimension d);
   Dimension spacing() const;
   void subMenuId(Widget w);
   Widget subMenuId() const;
   void tearOffModel(unsigned char c);
   unsigned char tearOffModel() const;
   void whichButton(unsigned int);
   unsigned int whichButton() const;
};

class RowColumn : public RowColumnClass {
 protected:
   virtual Widget createWidget(_XtString name, 
                               Widget w_parent,
                               ArgList arglist = NULL,
                               Cardinal cnt = 0);
 public:
   RowColumn(Widget w_parent,
             ArgList arglist = NULL,
             Cardinal cnt = 0,
             _XtString name = NULL);
   RowColumn(_XtString name, Widget w_parent);
   RowColumn(Widget w_parent, XarmArg &args, _XtString name);
};

class PulldownMenuClass : public RowColumnClass {
 protected:
   PulldownMenuClass() {} /* only a derived class can make this */
};

class PulldownMenu : public PulldownMenuClass {
 protected:
   virtual Widget createWidget(_XtString name, 
                               Widget w_parent,
                               ArgList arglist = NULL,
                               Cardinal cnt = 0);
 public:
   PulldownMenu(Widget w_parent,
                ArgList arglist = NULL,
                Cardinal = 0,
                _XtString name = NULL);
   PulldownMenu(_XtString name, Widget w_parent);
   PulldownMenu(Widget w_parent, XarmArg &args, _XtString name);
};

class MenuBarClass : public RowColumnClass {
 protected:
   MenuBarClass() {} /* only a derived class can make this */
 public:
   /* extra functionality */
   void help(Widget pull);
   void help(PulldownMenuClass *pull) { help(pull->widget()); }
};

class MenuBar : public MenuBarClass {
 protected:
   virtual Widget createWidget(_XtString name, 
                               Widget w_parent,
                               ArgList arglist = NULL,
                               Cardinal cnt = 0);
 public:
   MenuBar(Widget w_parent, 
           ArgList arglist = NULL,
           Cardinal cnt = 0,
           _XtString name = NULL);
   MenuBar(_XtString name, Widget w_parent);
   MenuBar(Widget w_parent, XarmArg &args, _XtString name);
};

class OptionMenuClass : public RowColumnClass {
 protected:
   OptionMenuClass() {} /* only a derived class can make this */
};

class OptionMenu : public OptionMenuClass {
 protected:
   virtual Widget createWidget(_XtString name, 
                               Widget w_parent,
                               ArgList arglist = NULL,
                               Cardinal cnt = 0);
 public:
   OptionMenu(Widget w_parent,
              ArgList arglist = NULL,
              Cardinal cnt = 0,
              _XtString name = NULL);
   OptionMenu(_XtString name, Widget w_parent);
   OptionMenu(Widget w_parent, XarmArg &args, _XtString name);
};

class PopupMenuClass : public RowColumnClass {
 protected:
   PopupMenuClass() {} /* only a derived class can make this */
};

class PopupMenu : public PopupMenuClass {
 protected:
   virtual Widget createWidget(_XtString name, 
                               Widget w_parent,
                               ArgList arglist = NULL,
                               Cardinal cnt = 0);
 public:
   PopupMenu(Widget w_parent,
             ArgList arglist = NULL,
             Cardinal cnt = 0, 
             _XtString name = NULL);
   PopupMenu(_XtString name, Widget w_parent);
   PopupMenu(Widget w_parent, XarmArg &args, _XtString name);
};


class CheckBoxClass : public RowColumnClass {
 protected:
   CheckBoxClass() {}
};

class RadioBoxClass : public RowColumnClass {
 protected:
   RadioBoxClass() {} /* only a derived class can make this */
};

#endif
