/* $Id: PushBG.h,v 1.2 1997/04/07 15:33:21 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(_XARM_PUSHBG_H_)
#define _XARM_PUSHBG_H_

/* ======================================================================= */
/* Include(s): */
#include <Xarm/LabelG.h>

class PushButtonGadgetClass : public LabelGadgetClass {
 protected:
   PushButtonGadgetClass() {} /* only a derived class can make this */
   /* class pointer */
   virtual WidgetClass classPointer() { return xmPushButtonGadgetClass; }
   /* class name */
   virtual _XtString className() { return (_XtString) "XmPushButtonGadget"; }
 public:
   /* callbacks */
   void activateCallback(XtCallbackProc funcp, XtPointer data = NULL);
   void armCallback(XtCallbackProc funcp, XtPointer data = NULL);
   void disarmCallback(XtCallbackProc funcp, XtPointer data = NULL);

   /* resources */
   void armColor(Pixel);
   Pixel armColor() const;
   void defaultButtonShadowThickness(Dimension);
   Dimension defaultButtonShadowThickness() const;
   void fillOnArm(Boolean);
   Boolean fillOnArm() const;
   void multiClick(unsigned char);
   unsigned char multiClick() const;
   void showAsDefault(Dimension);
   Dimension showAsDefault() const;

   /* extra functionality */
   void autoSpace(int size = 100);
};
   
class PushButtonGadget : public PushButtonGadgetClass {
 public:
   PushButtonGadget(Widget w_parent, 
                    char *text, 
                    KeySym mn = 0,
                    _XtString acc = NULL, 
                    char *acc_text = NULL,
                    _XtString name = NULL);
   PushButtonGadget(Widget w_parent, 
                    ArgList arglist = NULL, 
                    Cardinal cnt = 0,
                    _XtString name = NULL);
   PushButtonGadget(_XtString name, Widget w_parent);
   PushButtonGadget(Widget w_parent, XarmArg &args, _XtString name);
};

#endif
