/* $Id: Gadget.h,v 1.2 1999/01/15 10:07:02 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(_XARM_GADGET_H_)
#define _XARM_GADGET_H_

/* ======================================================================= */
/* Include(s): */
#include <Xarm/RectObj.h>

class GadgetClass : public _RectObjClass {
 protected:
   GadgetClass() {} /* only a derived class can make this */
 public:
   /* callbacks */
   void helpCallback(XtCallbackProc funcp, XtPointer data = NULL);

   /* resources */
   Pixel bottomShadowColor() const;
   Pixel highlightColor() const;
   void highlightOnEnter(Boolean);
   Boolean highlightOnEnter() const;
   void highlightThickness(Dimension);
   Dimension highlightThickness() const;
   void navigationType(XmNavigationType);
   XmNavigationType navigationType() const;
   void shadowThickness(Dimension);
   Dimension shadowThickness() const;
   Pixel topShadowColor() const;
   void traversalOn(Boolean on); 
   Boolean traversalOn() const;
   void unitType(unsigned char);
   unsigned char unitType() const;
   void userData(XtPointer udata);
   XtPointer userData() const;
};

#endif
