/* $Id: DragDrop.h,v 1.6 1999/01/15 09:38:42 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(_XARM_DRAGDROP_H_)
#define _XARM_DRAGDROP_H_

/* ======================================================================= */
/* Include(s): */
#include <Xarm/Core.h>
#include <Xarm/Xarm.h>

#ifdef XARM_HAS_CDE
#include <Xarm/CDEdnd.h>
#endif

class DragContextClass : public CoreClass {
 protected:
   DragContextClass() {} /* only a derived class can make this */
 
   virtual WidgetClass classPointer() { return xmDragContextClass; }
   virtual _XtString className() { return (_XtString) "XmDragContext"; }
 public:
   /* callbacks */
   void dragDropFinishCallback(XtCallbackProc, XtPointer);
   void dragMotionCallback(XtCallbackProc, XtPointer);
   void dropFinishCallback(XtCallbackProc, XtPointer);
   void dropSiteEnterCallback(XtCallbackProc, XtPointer);
   void dropSiteLeaveCallback(XtCallbackProc, XtPointer);
   void dropStartCallback(XtCallbackProc, XtPointer);
   void operationChangedCallback(XtCallbackProc, XtPointer);
   void topLevelEnterCallback(XtCallbackProc, XtPointer);
   void topLevelLeaveCallback(XtCallbackProc, XtPointer);

   /* resources */
   unsigned char blendModel() const;
   void clientData (XtPointer);
   XtPointer clientData() const;
   void convertProc(XtConvertSelectionIncrProc);
   XtConvertSelectionIncrProc convertProc() const;
   void cursorBackground(Pixel);
   Pixel cursorBackground() const;
   void cursorForeground(Pixel);
   Pixel cursorForeground() const;
   void exportTargets(Atom *);
   Atom *exportTargets() const;
   void incremental(Boolean);
   Boolean incremental() const;
   void invalidCursorForeground(Pixel);
   Pixel invalidCursorForeground() const;
   void noneCursorForeground(Pixel);
   Pixel noneCursorForeground() const;
   void numExportTargets(Cardinal);
   Cardinal numExportTargets() const;
   void operationCursorIcon(Widget);
   Widget operationCursorIcon() const;
   void sourceCursorIcon(Widget);
   Widget sourceCursorIcon() const;
   void sourcePixmapIcon(Widget);
   Widget sourcePixmapIcon() const;
   void stateCursorIcon(Widget);
   Widget stateCursorIcon() const;
   void validCursorForeground(Pixel);
   Pixel validCursorForeground() const;

   // Additional functionality
   void cursorBackground(const char *);
   void cursorForeground(const char *);
   void invalidCursorForeground(const char *);
   void noneCursorForeground(const char *);
   void validCursorForeground(const char *);
   
};

class DragIconClass : public _ObjectClass {
 protected:
   DragIconClass() {}     

   virtual WidgetClass classPointer() { return xmDragIconObjectClass; }
   virtual _XtString className() { return (_XtString) "XmDragIcon"; }
 public:
   /* resources */
   void attachment(unsigned char);
   unsigned char attachment() const;
   void depth(int);
   int depth() const;
   void height(Dimension);
   Dimension height() const;
   void hotX(Position);
   Position hotX() const;
   void hotY(Position);
   Position hotY() const;
   void mask(Pixmap);
   Pixmap mask() const;
   void offsetX(Position);
   Position offsetX() const;
   void offsetY(Position);
   Position offsetY() const;
   void pixmap(Pixmap);
   Pixmap pixmap() const;
   void width(Dimension);
   Dimension width() const;
};

class DropTransferClass : public _ObjectClass 
{
 protected:
   DropTransferClass() {}
 public:
   /* resources */
   XmDropTransferEntryRec *dropTransfers() const;
   void incremental(Boolean);
   Boolean incremental() const;
   void numDropTransfers(Cardinal);
   Cardinal numDropTransfers() const;
   void transferProc(XtSelectionCallbackProc);
   XtSelectionCallbackProc transferProc() const;
   void transferStatus(unsigned char);
   unsigned char transferStatus() const;
};

#endif
