/* $Id: Dial.h,v 1.2 1999/01/15 01:50:58 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(_XARM_DIAL_H_)
#define _XARM_DIAL_H_

/*
 * Warning:  These classes diverge from the Motif 1.2 standard GUI.
 */

/* ======================================================================= */
/* Include(s): */
#include <Xarm/Primitive.h>
#include <Xmext/Dial.h>

class DialClass : public PrimitiveClass {
 protected:
   DialClass() {} /* only a derived class can make this */
   virtual WidgetClass classPointer() { return xmDialWidgetClass; }
   virtual _XtString className() { return (_XtString) "XmDial"; }
   virtual Widget createWidget(_XtString name,
                               Widget w_parent,
                               ArgList arglist = NULL,
                               Cardinal cnt = 0);
 public:
   /* resources */
   void          minimum(int);
   int           minimum() const;
   void          maximum(int);
   int           maximum() const;
   void          value(int);
   int           value() const; 
   void          tickIncrement(int);
   int           tickIncrement() const;   
   void          tickSize(int);
   int           tickSize() const;   
   void          arcMargin(int);
   int           arcMargin() const;
   void          borderMargin(int);
   int           borderMargin() const;
   void          processingDirection(unsigned char);
   unsigned char processingDirection() const;
   void          fill(Boolean);
   Boolean       fill() const;
   void          showValue(Boolean);
   Boolean       showValue() const; 
   void          showMinMax(Boolean);
   Boolean       showMinMax() const;
   void          showPercentage(Boolean);
   Boolean       showPercentage() const;
   void          showHub(Boolean);
   Boolean       showHub() const; 
   void          style(const DialStyle);
   DialStyle     style() const;
};

class Dial : public DialClass {
 public:
   Dial(Widget w_parent, 
               ArgList arglist = NULL, 
               Cardinal cnt = 0, 
               _XtString name = NULL);
   Dial(_XtString name, Widget w_parent); 
   Dial(Widget w_parent, XarmArg &args, _XtString name);
};

#endif
