/* $Id: Command.h,v 1.3 1999/01/15 01:32:05 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(_XARM_COMMAND_H_)
#define _XARM_COMMAND_H_

/* ======================================================================= */
/* Include(s): */
#include <Xarm/SelectioB.h>

class CommandBoxClass : public SelectionBoxClass {
 protected:
   CommandBoxClass() {}
   virtual WidgetClass classPointer() { return xmCommandWidgetClass; }
   virtual _XtString className() { return (_XtString) "XmCommand"; }
 public:
   /* Callacks */
   void changedCallback(XtCallbackProc fp, XtPointer udata);
   void enteredCallback(XtCallbackProc fp, XtPointer udata);

   /* resources */
   void command(const char *str);
   char *command() const;
   void historyItems(const XmStringTable);
   XmStringTable historyItems() const;
   void historyItemCount(int);
   int historyItemCount() const;
   void historyMaxItems(int);
   int historyMaxItems() const;
   void historyVisibleItemCount(int);
   int historyVisibleItemCount() const;
   void promptString(const char *);
   char *promptString() const;
};

class CommandBox : public CommandBoxClass {
 public:
   CommandBox(Widget w_parent, 
              ArgList arglist = NULL, 
              Cardinal cnt = 0, 
              _XtString name = NULL);
   CommandBox(_XtString name, Widget w_parent);
   CommandBox(Widget w_parent, XarmArg &args, _XtString name);
};

#endif
