/*
 Copyright (C) 1998 Gerald L. Gay
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License
 version 2 as published by the Free Software Foundation.
 
 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.
 
 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave,
 Cambridge, MA 02139, USA.
*/


#if !defined(_XARM_CDEDND_H)
#define _XARM_CDEDND_H

#include <Dt/Dnd.h>

typedef DtDndProtocol XarmDndProtocol;

#define XARM_DND_TEXT_TRANSFER      DtDND_TEXT_TRANSFER
#define XARM_DND_FILENAME_TRANSFER  DtDND_FILENAME_TRANSFER
#define XARM_DND_BUFFER_TRANSFER    DtDND_BUFFER_TRANSFER

void RegisterDragSource(void *);
void RegisterDropSite(void *, Widget, XarmDndProtocol, unsigned char, ArgList, Cardinal);

Widget XarmBeginDragOps(void *,
			Widget,
			XEvent *,
			XarmDndProtocol,
			Cardinal,
			unsigned char,
			ArgList,
			Cardinal);

template <class T>
struct XarmDragInfo {
    typedef bool (T::*p_dragStart)(Widget, XEvent *, XtPointer);

    T *obj;
    p_dragStart dragStartProc;
    Widget w;
    XtPointer closure;
};

template <class T>
struct XarmStartDragInfo {
    typedef void (T::*p_call)(Widget, XtPointer, XtPointer);

    T *obj;
    p_call convertProc;
    p_call finishProc;
    XtPointer convClosure;
    XtPointer finishClosure;
};

template <class T>
struct XarmDropSiteInfo {
    typedef void (T::*p_call)(Widget, XtPointer, XtPointer);

    T *obj;
    p_call transferProc;
    Widget w;
    XtPointer transferClosure;
};

template <class T>
void addDropSite(T *obj,
		 void (T::*transferProc)(Widget, XtPointer, XtPointer),
		 XtPointer transferClosure,
		 Widget w,
		 XarmDndProtocol proto,
		 unsigned char operations,
		 ArgList argList,
		 Cardinal argCount)
{

    XarmDropSiteInfo<T> *xdsi = new XarmDropSiteInfo<T>;

    if (xdsi == NULL) return;

    xdsi->obj             = obj;
    xdsi->transferProc    = transferProc;
    xdsi->transferClosure = transferClosure;
    xdsi->w               = w;

    RegisterDropSite(xdsi, w, proto, operations, argList, argCount);
}
    

template <class T>
Widget XarmStartDrag(T *obj,
		     void (T::*conv_proc)(Widget, XtPointer, XtPointer),
		     void (T::*finish_proc)(Widget, XtPointer, XtPointer),
		     XtPointer convClosure,
		     XtPointer finishClosure,
		     Widget w,
		     XEvent *event,
		     XarmDndProtocol proto,
		     Cardinal numItems,
		     unsigned char operations,
		     ArgList argList,
		     Cardinal argCount)
{

    XarmStartDragInfo<T> *xsdi = new XarmStartDragInfo<T>;

    if (xsdi == NULL) return NULL;

    xsdi->obj           = obj;
    xsdi->convertProc   = conv_proc;
    xsdi->finishProc    = finish_proc;
    xsdi->convClosure   = convClosure;
    xsdi->finishClosure = finishClosure;

    return XarmBeginDragOps(xsdi, w, event, proto, numItems, operations, argList, argCount);
}
  

template <class T>
void addDragSource(T *obj,
		   bool (T::*func)(Widget, XEvent *, XtPointer),
		   Widget w,
		   XtPointer closure=NULL)
{

    XarmDragInfo<T> *dragInfo = new XarmDragInfo<T>;

    if (dragInfo == NULL) return;

    dragInfo->obj           = obj;
    dragInfo->dragStartProc = func;
    dragInfo->w             = w;
    dragInfo->closure       = closure;

    RegisterDragSource(dragInfo);
}

#endif
