/* $Id: ArrowB.h,v 1.3 1999/01/14 03:35:18 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(_XARM_ARROWB_H_)
#define _XARM_ARROWB_H_

/* ======================================================================= */
/* Include(s): */
#include <Xarm/Primitive.h>

class ArrowButtonClass : public PrimitiveClass {
 protected:
   ArrowButtonClass() {} /* only a derived class can make this */

   virtual WidgetClass classPointer() { return xmArrowButtonWidgetClass; }
   virtual _XtString className() { return (_XtString) "XmArrowButton"; }
 public:
   /* callbacks */
   void activateCallback(XtCallbackProc funcp, XtPointer data = NULL);
   void armCallback(XtCallbackProc funcp, XtPointer data = NULL);
   void disarmCallback(XtCallbackProc funcp, XtPointer data = NULL);

   /* resources */
   void arrowDirection(unsigned char);
   unsigned char arrowDirection() const;
   void multiClick(unsigned char);
   unsigned char multiClick() const;
};

class ArrowButton : public ArrowButtonClass {
 public:
   ArrowButton(Widget w_parent, 
               ArgList arglist = NULL, 
               Cardinal argcnt = 0, 
               _XtString name = NULL);
   ArrowButton(_XtString name, Widget w_parent);
   ArrowButton(Widget w_parent, XarmArg &args, _XtString name);
};

#endif
