/* $Id: adt.C,v 1.1.1.1 1997/03/19 13:32:22 glgay Exp $ */
/*
 Copyright (C) 1991-1996 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/
/*
*  File: adt.C
*  Author: Peter G. Williams
*  Date: 12/15/91
*/

#include <stdio.h>
#include <stdlib.h>
#include <Xarm/adt.h>

/* Defines */

#define Arm_Not_Found NULL
#define Arm_Failure NULL

/* ArmBinaryTree Member Functions */

ArmBinaryTree::ArmBinaryTree(ArmNode *s)
{
   symbol=NULL;
   left=right=NULL;

   if(s!=NULL)
   {
      symbol=s->duplicate();
   }
}

ArmBinaryTree::~ArmBinaryTree() 
{
   delete symbol; /* destroy element */
   delete left;   /* delete left branch */
   delete right;  /* delete right branch */
}

const ArmNode *
ArmBinaryTree::add(ArmNode *s) 
{
   if(symbol==NULL) 
   {
      symbol=s->duplicate();
      return symbol;
   }

   // ok, we have a collision
   ArmBinaryTree *q, *p=this;
   int order;

   do {
      order=s->compare(p->symbol);
      // check for dup just in case.
      if(order==0) 
      { // we have a duplicate
         return Arm_Failure;
      }
      else 
      { // not a duplicate
         q=p;
	 if(order<0)
         {
	    p=p->left;
         }
	 else
         {
            p=p->right;
         }
      }
   } while(p);

   p= new ArmBinaryTree(s);

   if(order<0)
   {
      q->left=p;
   }
   else
   {
      q->right=p;
   }

   return p->symbol;
}

const ArmNode *
ArmBinaryTree::find(ArmNode *s)
{
   ArmBinaryTree *p=this;
   int order;

   if(p->symbol == NULL)
      return Arm_Not_Found; // not found
   
   do {
      order=s->compare(p->symbol);
      if(order==0)
      {
         return p->symbol;  // found it
      }
      else if(order<0)
      {
         p=p->left;
      }
      else
      {
         p=p->right;
      }
   } while(p);

   return Arm_Not_Found; // not found
}

/* ArmList Member Functions */

ArmList::~ArmList() 
{
   /* explode ;^) */
   delete symbol; // delete element
   delete left;   // delete left branch
   delete right;  // delete right branch
}

ArmList::ArmList(ArmNode *s)
{
   symbol=NULL;
   left=right=NULL;

   if(s != NULL)
   {
      symbol=s->duplicate();
   }
}

const ArmNode *
ArmList::add(ArmNode *s)
{
   if(symbol==NULL) 
   {
      symbol=s->duplicate();
      return symbol;
   }

   ArmList *q, *p=this;

   // add it to the right end of the list
   while(p->right != NULL)
   {
      p = p->right;
   }
 
   q = new ArmList(s);

   p->right=q;
   q->left=p;

   return q->symbol;
}

void 
ArmList::remove(ArmNode *elt)
{
   ArmList *p=this;

   p = find_node(elt);
 
   if(p != Arm_Not_Found)
   {
      if(p->left != NULL)
      {
         p->left->right = p->right;
      }
      if(p->right != NULL)
      {
         p->right->left = p->left;
      }

      p->left = NULL;
      p->right = NULL;

      delete p;
   }
#if 0
   /* uncomment to check for leaks */
   else
   {
      /* error did not find node */
      printf("Could not find type %s\n",elt->isa());
   }
#endif
}

const ArmNode *
ArmList::find(ArmNode *elt)
{
   ArmList *p;
 
   p = find_node(elt);
   if(p != Arm_Not_Found)
   {
      return p->symbol;  // found it
   } 
   return Arm_Not_Found;
}

ArmList *
ArmList::find_node(ArmNode *elt) 
{
   ArmList *p=this;
   // start at head (left end)
   while(p->left != NULL)   
   {
      p = p->left;
   }

   /* only the head record is allowed to not have a symbol */
   if(p->symbol == NULL)
   {
      return Arm_Not_Found; // no head record
   }

   do
   {
      if(elt->compare(p->symbol)==0)
      {
         return p;  // found it
      }
      p = p->right;
   }
   while(p);

   return Arm_Not_Found; 
}


