/* $Id: TextF.C,v 1.2 1997/04/08 15:21:00 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/

#include <Xarm/TextF.h>
/* TextFieldClass member functions */

/* callbacks */
void 
TextFieldClass::activateCallback(XtCallbackProc funcp, XtPointer data) 
{
   addCallback(XmNactivateCallback,funcp,data);
}

void 
TextFieldClass::focusCallback(XtCallbackProc funcp, XtPointer data)
{
   addCallback(XmNfocusCallback,funcp,data);
}

void 
TextFieldClass::gainPrimaryCallback(XtCallbackProc funcp, XtPointer data)
{
   addCallback(XmNgainPrimaryCallback,funcp,data);
}

void 
TextFieldClass::losingFocusCallback(XtCallbackProc funcp, XtPointer data) 
{
   addCallback(XmNlosingFocusCallback,funcp,data);
}

void 
TextFieldClass::losePrimaryCallback(XtCallbackProc funcp, XtPointer data)
{
   addCallback(XmNlosePrimaryCallback,funcp,data);
}

void 
TextFieldClass::modifyVerifyCallback(XtCallbackProc funcp, XtPointer data)
{
   addCallback(XmNmodifyVerifyCallback,funcp,data);
}

void 
TextFieldClass::modifyVerifyCallbackWcs(XtCallbackProc funcp, XtPointer data)
{
   addCallback(XmNmodifyVerifyCallbackWcs,funcp,data);
}

void 
TextFieldClass::motionVerifyCallback(XtCallbackProc funcp, XtPointer data)
{
   addCallback(XmNmotionVerifyCallback,funcp,data);
}

void 
TextFieldClass::valueChangedCallback(XtCallbackProc funcp, XtPointer data) 
{
   addCallback(XmNvalueChangedCallback,funcp,data);
}

/* convenience routines */

void
TextFieldClass::clearSelection(Time time)
{
   XmTextFieldClearSelection(widget(), time);
}

Boolean
TextFieldClass::copy(Time time)
{
   return XmTextFieldCopy(widget(),time);
}

Boolean
TextFieldClass::cut(Time time)
{
   return XmTextFieldCut(widget(),time);
}

int
TextFieldClass::getBaseline()
{
   return XmTextFieldGetBaseline(widget());
}

XmTextPosition
TextFieldClass::getCursorPosition()
{
   return XmTextFieldGetCursorPosition(widget());
}

Boolean
TextFieldClass::getEditable()
{
   return XmTextFieldGetEditable(widget());
}

XmTextPosition
TextFieldClass::getInsertionPosition()
{
   return XmTextFieldGetInsertionPosition(widget());
}

XmTextPosition
TextFieldClass::getLastPosition()
{
   return XmTextFieldGetLastPosition(widget());
}

int
TextFieldClass::getMaxLength()
{
   return XmTextFieldGetMaxLength(widget());
}

char *
TextFieldClass::getSelection()
{
   return XmTextFieldGetSelection(widget());
}

Boolean
TextFieldClass::getSelectionPosition(XmTextPosition *left, XmTextPosition *right)
{
   return XmTextFieldGetSelectionPosition(widget(), left, right);
}

wchar_t *
TextFieldClass::getSelectionWcs()
{
   return XmTextFieldGetSelectionWcs(widget());
}

_XtString 
TextFieldClass::getString()
{
   return XmTextFieldGetString(widget());
}

wchar_t * 
TextFieldClass::getStringWcs()
{
   return XmTextFieldGetStringWcs(widget());
}

int
TextFieldClass::getSubstring(XmTextPosition start, int no_chars, int buf_sz, 
                             char *buf)
{
   return XmTextFieldGetSubstring(widget(), start, no_chars, buf_sz, buf);
}

int
TextFieldClass::getSubstringWcs(XmTextPosition start, int no_chars, int buf_sz,
                                wchar_t *buf)
{
   return XmTextFieldGetSubstringWcs(widget(), start, no_chars, buf_sz, buf);
}

void
TextFieldClass::insert(XmTextPosition pos, char *str)
{
   XmTextFieldInsert(widget(), pos, str);
}

void
TextFieldClass::insertWcs(XmTextPosition pos, wchar_t *str)
{
   XmTextFieldInsertWcs(widget(), pos, str);
}

Boolean
TextFieldClass::paste()
{
   return XmTextFieldPaste(widget());
}

Boolean
TextFieldClass::posToXY(XmTextPosition pos, Position *xpos, Position *ypos)
{
   return XmTextFieldPosToXY(widget(),pos,xpos,ypos);
}

Boolean
TextFieldClass::remove()
{
   return XmTextFieldRemove(widget());
}

void
TextFieldClass::replace(XmTextPosition from, XmTextPosition to, char *val)
{
   XmTextFieldReplace(widget(), from, to, val);
}

void
TextFieldClass::replaceWcs(XmTextPosition from, XmTextPosition to, wchar_t *val)
{
   XmTextFieldReplaceWcs(widget(), from, to, val);
}

void
TextFieldClass::setAddMode(Boolean state)
{
   XmTextFieldSetAddMode(widget(), state);
}

void
TextFieldClass::setCursorPosition(XmTextPosition pos)
{
   XmTextFieldSetCursorPosition(widget(), pos);
}

void
TextFieldClass::setEditable(Boolean edit)
{
   XmTextFieldSetEditable(widget(), edit);
}

void
TextFieldClass::setHighlight(XmTextPosition left, XmTextPosition right, XmHighlightMode mode)
{
   XmTextFieldSetHighlight(widget(), left, right, mode);
}

void 
TextFieldClass::setInsertionPosition(XmTextPosition pos)
{
   XmTextFieldSetInsertionPosition(widget(), pos);
}

void 
TextFieldClass::setMaxLength(int max)
{
   XmTextFieldSetMaxLength(widget(), max);
}

void 
TextFieldClass::setSelection(XmTextPosition first, XmTextPosition last, Time t)
{
   XmTextFieldSetSelection(widget(), first, last, t);
}

void 
TextFieldClass::setString(char *str)
{
   XmTextFieldSetString(widget(), str);
}

void 
TextFieldClass::setStringWcs(wchar_t *str)
{
   XmTextFieldSetStringWcs(widget(), str);
}

void 
TextFieldClass::showPosition(XmTextPosition pos)
{
   XmTextFieldShowPosition(widget(), pos);
}

XmTextPosition
TextFieldClass::xyToPos(Position xpos, Position ypos)
{
   return XmTextFieldXYToPos(widget(), xpos, ypos);
}

/* resources */
void 
TextFieldClass::blinkRate(int b)
{
   XtVaSetValues(widget(), XmNblinkRate, b, NULL);
}

int
TextFieldClass::blinkRate()
{
   int b;
   XtVaGetValues(widget(), XmNblinkRate, &b, NULL);
   return b;
}

void 
TextFieldClass::columns(short c)
{
   XtVaSetValues(widget(), XmNcolumns, c, NULL);
}

short
TextFieldClass::columns()
{
   short c;
   XtVaGetValues(widget(), XmNcolumns, &c, NULL);
   return c;
}

void 
TextFieldClass::cursorPosition(XmTextPosition pos)
{
   XtVaSetValues(widget(), XmNcursorPosition, pos, NULL);
}

XmTextPosition
TextFieldClass::cursorPosition()
{
   XmTextPosition pos;
   XtVaGetValues(widget(), XmNcursorPosition, &pos, NULL);
   return pos;
}

void 
TextFieldClass::cursorPositionVisible(Boolean b)
{
   XtVaSetValues(widget(), XmNcursorPositionVisible, b, NULL);
}

Boolean
TextFieldClass::cursorPositionVisible()
{
   Boolean b;
   XtVaGetValues(widget(), XmNcursorPositionVisible, &b, NULL);
   return b;
}

void 
TextFieldClass::editable(Boolean b)
{
   XtVaSetValues(widget(), XmNeditable, b, NULL);
}

Boolean
TextFieldClass::editable()
{
   Boolean b;
   XtVaGetValues(widget(), XmNeditable, &b, NULL);
   return b;
}

void 
TextFieldClass::fontList(XmFontList f)
{
   XtVaSetValues(widget(),XmNfontList, f, NULL);
}

XmFontList
TextFieldClass::fontList()
{
   XmFontList f;
   XtVaGetValues(widget(),XmNfontList, &f, NULL);
   return f;
}

void 
TextFieldClass::marginHeight(Dimension h)
{
   XtVaSetValues(widget(),XmNmarginHeight,h, NULL);
}

Dimension
TextFieldClass::marginHeight()
{
   Dimension d;
   XtVaGetValues(widget(),XmNmarginHeight, &d, NULL);
   return d;
}

void 
TextFieldClass::marginWidth(Dimension w)
{
   XtVaSetValues(widget(),XmNmarginWidth,w, NULL);
}

Dimension
TextFieldClass::marginWidth()
{
   Dimension d;
   XtVaGetValues(widget(),XmNmarginWidth, &d, NULL);
   return d;
}

void 
TextFieldClass::maxLength(int l)
{
   XtVaSetValues(widget(),XmNmaxLength,l, NULL);
}

int
TextFieldClass::maxLength()
{
   int l;
   XtVaGetValues(widget(),XmNmaxLength, &l, NULL);
   return l;
}

void 
TextFieldClass::pendingDelete(Boolean b)
{
   XtVaSetValues(widget(),XmNpendingDelete,b, NULL);
}

Boolean
TextFieldClass::pendingDelete()
{
   Boolean b;
   XtVaGetValues(widget(),XmNpendingDelete, &b, NULL);
   return b;
}

void 
TextFieldClass::resizeWidth(Boolean b)
{
   XtVaSetValues(widget(),XmNresizeWidth,b, NULL);
}

Boolean
TextFieldClass::resizeWidth()
{
   Boolean b;
   XtVaGetValues(widget(),XmNresizeWidth, &b, NULL);
   return b;
}

void 
TextFieldClass::selectionArray(XmTextScanType *p)
{
   XtVaSetValues(widget(),XmNselectionArray, p, NULL);
}

XmTextScanType *
TextFieldClass::selectionArray()
{
   XmTextScanType *s;
   XtVaGetValues(widget(),XmNselectionArray, &s, NULL);
   return s;
}

void 
TextFieldClass::selectionArrayCount(int cnt)
{
   XtVaSetValues(widget(),XmNselectionArrayCount, cnt, NULL);
}

int
TextFieldClass::selectionArrayCount()
{
   int i;
   XtVaGetValues(widget(),XmNselectionArrayCount, &i, NULL);
   return i;
}

void 
TextFieldClass::selectThreshold(int h)
{
   XtVaSetValues(widget(),XmNselectThreshold, h, NULL);
}

int
TextFieldClass::selectThreshold()
{
   int i;
   XtVaGetValues(widget(),XmNselectThreshold, &i, NULL);
   return i;
}

void 
TextFieldClass::value(_XtString v)
{
   XtVaSetValues(widget(),XmNvalue,v, NULL);
}

_XtString
TextFieldClass::value()
{
   _XtString s;
   XtVaGetValues(widget(),XmNvalue, &s, NULL);
   return s;
}

void 
TextFieldClass::valueWcs(wchar_t *v)
{
   XtVaSetValues(widget(),XmNvalueWcs, v, NULL);
}

wchar_t *
TextFieldClass::valueWcs()
{
   wchar_t *w;
   XtVaGetValues(widget(),XmNvalueWcs, &w, NULL);
   return w;
}

void 
TextFieldClass::verifyBell(Boolean b)
{
   XtVaSetValues(widget(),XmNverifyBell,b, NULL);
}

Boolean
TextFieldClass::verifyBell()
{
   Boolean b;
   XtVaGetValues(widget(),XmNverifyBell, &b, NULL);
   return b;
}

/* constructor */
TextField::TextField(Widget w_parent, ArgList arglist, Cardinal cnt, _XtString name)
{
   Widget wid = createWidget(name, w_parent, arglist, cnt);
   widget(wid);
   manage();
}

TextField::TextField(Widget w_parent, XarmArg &args, _XtString name)
{
   Widget wid = createWidget(name, w_parent, args.getArgs(), args.count());
   widget(wid);
   manage();
}

TextField::TextField(_XtString name, Widget w_parent)
{
   Widget wid = createWidget(name, w_parent);
   widget(wid);
   manage();
}
