/* $Id: Text.C,v 1.2 1997/04/08 15:20:59 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/

#include <Xarm/Text.h>
/* TextClass member functions */

/* callbacks */
void 
TextClass::activateCallback(XtCallbackProc funcp, XtPointer data) 
{
   addCallback(XmNactivateCallback,funcp,data);
}

void 
TextClass::focusCallback(XtCallbackProc funcp, XtPointer data)
{
   addCallback(XmNfocusCallback,funcp,data);
}

void 
TextClass::gainPrimaryCallback(XtCallbackProc funcp, XtPointer data)
{
   addCallback(XmNgainPrimaryCallback,funcp,data);
}

void 
TextClass::losingFocusCallback(XtCallbackProc funcp, XtPointer data) 
{
   addCallback(XmNlosingFocusCallback,funcp,data);
}

void 
TextClass::losePrimaryCallback(XtCallbackProc funcp, XtPointer data)
{
   addCallback(XmNlosePrimaryCallback,funcp,data);
}

void 
TextClass::modifyVerifyCallback(XtCallbackProc funcp, XtPointer data)
{
   addCallback(XmNmodifyVerifyCallback,funcp,data);
}

void 
TextClass::modifyVerifyCallbackWcs(XtCallbackProc funcp, XtPointer data)
{
   addCallback(XmNmodifyVerifyCallbackWcs,funcp,data);
}

void 
TextClass::motionVerifyCallback(XtCallbackProc funcp, XtPointer data)
{
   addCallback(XmNmotionVerifyCallback,funcp,data);
}

void 
TextClass::valueChangedCallback(XtCallbackProc funcp, XtPointer data) 
{
   addCallback(XmNvalueChangedCallback,funcp,data);
}

/* convenience functions */

void
TextClass::clearSelection(Time time)
{
   XmTextClearSelection(widget(), time);
}

Boolean
TextClass::copy(Time time)
{
   return XmTextCopy(widget(),time);
}

Boolean
TextClass::cut(Time time)
{
   return XmTextCut(widget(),time);
}

void
TextClass::disableRedisplay()
{
   XmTextDisableRedisplay(widget());
}

void
TextClass::enableRedisplay()
{
   XmTextEnableRedisplay(widget());
}

Boolean 
TextClass::findString(XmTextPosition start, char *str, XmTextDirection direction, XmTextPosition *pos)
{
   return XmTextFindString(widget(), start, str, direction, pos);
}

Boolean 
TextClass::findStringWcs(XmTextPosition start, wchar_t *str, XmTextDirection direction, XmTextPosition *pos)
{
   return XmTextFindStringWcs(widget(), start, str, direction, pos);
}

int
TextClass::getBaseline()
{
   return XmTextGetBaseline(widget());
}

XmTextPosition
TextClass::getCursorPosition()
{
   return XmTextGetCursorPosition(widget());
}

Boolean
TextClass::getEditable()
{
   return XmTextGetEditable(widget());
}


XmTextPosition
TextClass::getInsertionPosition()
{
   return XmTextGetInsertionPosition(widget());
}

XmTextPosition
TextClass::getLastPosition()
{
   return XmTextGetLastPosition(widget());
}

int
TextClass::getMaxLength()
{
   return XmTextGetMaxLength(widget());
}

char *
TextClass::getSelection()
{
   return XmTextGetSelection(widget());
}

Boolean
TextClass::getSelectionPosition(XmTextPosition *left, XmTextPosition *right)
{
   return XmTextGetSelectionPosition(widget(), left, right);
}

wchar_t *
TextClass::getSelectionWcs()
{
   return XmTextGetSelectionWcs(widget());
}

XmTextSource
TextClass::getSource()
{
   return XmTextGetSource(widget());
}

char * 
TextClass::getString()
{
   return XmTextGetString(widget()); 
}

wchar_t * 
TextClass::getStringWcs()
{
   return XmTextGetStringWcs(widget());
}

int
TextClass::getSubstring(XmTextPosition start, int no_chars, int buf_sz, 
                        char *buf)
{
   return XmTextGetSubstring(widget(), start, no_chars, buf_sz, buf);
}

int
TextClass::getSubstringWcs(XmTextPosition start, int no_chars, int buf_sz, 
                           wchar_t *buf)
{
   return XmTextGetSubstringWcs(widget(), start, no_chars, buf_sz, buf);
}

XmTextPosition
TextClass::getTopCharacter()
{
   return XmTextGetTopCharacter(widget());
}

void
TextClass::insert(XmTextPosition pos, char *str)
{
   XmTextInsert(widget(), pos, str);
}

void
TextClass::insertWcs(XmTextPosition pos, wchar_t *str)
{
   XmTextInsertWcs(widget(), pos, str);
}

Boolean
TextClass::paste()
{
   return XmTextPaste(widget());
}

Boolean
TextClass::posToXY(XmTextPosition pos, Position *xpos, Position *ypos)
{
   return XmTextPosToXY(widget(),pos,xpos,ypos);
}

Boolean
TextClass::remove()
{
   return XmTextRemove(widget());
}

void
TextClass::replace(XmTextPosition from, XmTextPosition to, char *val)
{
   XmTextReplace(widget(), from, to, val);
}

void
TextClass::replaceWcs(XmTextPosition from, XmTextPosition to, wchar_t *val)
{
   XmTextReplaceWcs(widget(), from, to, val);
}

void
TextClass::scroll(int lines)
{
   XmTextScroll(widget(), lines);
}

void
TextClass::setAddMode(Boolean state)
{
   XmTextSetAddMode(widget(), state);
}

void
TextClass::setCursorPosition(XmTextPosition pos)
{
   XmTextSetCursorPosition(widget(), pos);
}

void
TextClass::setEditable(Boolean edit)
{
   XmTextSetEditable(widget(), edit);
}

void
TextClass::setHighlight(XmTextPosition left, XmTextPosition right, XmHighlightMode mode)
{
   XmTextSetHighlight(widget(), left, right, mode);
}

void 
TextClass::setInsertionPosition(XmTextPosition pos)
{
   XmTextSetInsertionPosition(widget(), pos);
}

void 
TextClass::setMaxLength(int max)
{
   XmTextSetMaxLength(widget(), max);
}

void 
TextClass::setSelection(XmTextPosition first, XmTextPosition last, Time t)
{
   XmTextSetSelection(widget(), first, last, t);
}

void 
TextClass::setString(char *str)
{
   XmTextSetString(widget(), str);
}

void 
TextClass::setStringWcs(wchar_t *str)
{
   XmTextSetStringWcs(widget(), str);
}

void
TextClass::setTopCharacter(XmTextPosition top)
{
   XmTextSetTopCharacter(widget(),top);
}

void 
TextClass::showPosition(XmTextPosition pos)
{
   XmTextShowPosition(widget(), pos);
}

XmTextPosition
TextClass::xyToPos(Position xpos, Position ypos)
{
   return XmTextXYToPos(widget(), xpos, ypos);
}

/* resources */
void 
TextClass::autoShowCursorPosition(Boolean b)
{
   XtVaSetValues(widget(), XmNautoShowCursorPosition, b, NULL);
}

Boolean
TextClass::autoShowCursorPosition()
{
   Boolean b;
   XtVaGetValues(widget(), XmNautoShowCursorPosition, &b, NULL);
   return b;
}

void
TextClass::blinkRate(int b)
{
   XtVaSetValues(widget(), XmNblinkRate, b, NULL);
}

int
TextClass::blinkRate()
{
   int b;
   XtVaGetValues(widget(), XmNblinkRate, &b, NULL);
   return b;
}

void
TextClass::columns(short s)
{
   XtVaSetValues(widget(), XmNcolumns, s, NULL);
}

short
TextClass::columns()
{
   short c;
   XtVaGetValues(widget(), XmNcolumns, &c, NULL);
   return c;
}

void 
TextClass::cursorPosition(XmTextPosition pos)
{
   XtVaSetValues(widget(), XmNcursorPosition, pos, NULL);
}

XmTextPosition
TextClass::cursorPosition()
{
   XmTextPosition pos;
   XtVaGetValues(widget(), XmNcursorPosition, &pos, NULL);
   return pos;
}

void 
TextClass::cursorPositionVisible(Boolean b)
{
   XtVaSetValues(widget(), XmNcursorPositionVisible, b, NULL);
}

Boolean
TextClass::cursorPositionVisible()
{
   Boolean b;
   XtVaGetValues(widget(), XmNcursorPositionVisible, &b, NULL);
   return b;
}

void 
TextClass::editable(Boolean b)
{
   XtVaSetValues(widget(), XmNeditable, b, NULL);
}

Boolean
TextClass::editable()
{
   Boolean b;
   XtVaGetValues(widget(), XmNeditable, &b, NULL);
   return b;
}

void 
TextClass::editMode(int m)
{
   XtVaSetValues(widget(),XmNeditMode, m, NULL);
}

int
TextClass::editMode()
{
   int m;
   XtVaGetValues(widget(),XmNeditMode, &m, NULL);
   return m;
}

void
TextClass::fontList(XmFontList fl)
{
   XtVaSetValues(widget(),XmNfontList, fl, NULL);
}

XmFontList
TextClass::fontList()
{
   XmFontList f;
   XtVaGetValues(widget(),XmNfontList, &f, NULL);
   return f;
}

void 
TextClass::marginHeight(Dimension h)
{
   XtVaSetValues(widget(),XmNmarginHeight,h, NULL);
}

Dimension
TextClass::marginHeight()
{
   Dimension d;
   XtVaGetValues(widget(),XmNmarginHeight, &d, NULL);
   return d;
}

void 
TextClass::marginWidth(Dimension w)
{
   XtVaSetValues(widget(),XmNmarginWidth,w, NULL);
}

Dimension
TextClass::marginWidth()
{
   Dimension d;
   XtVaGetValues(widget(),XmNmarginWidth, &d, NULL);
   return d;
}

void 
TextClass::maxLength(int l)
{
   XtVaSetValues(widget(),XmNmaxLength,l, NULL);
}

int
TextClass::maxLength()
{
   int l;
   XtVaGetValues(widget(),XmNmaxLength, &l, NULL);
   return l;
}

void
TextClass::pendingDelete(Boolean b)
{
   XtVaSetValues(widget(),XmNpendingDelete, b, NULL);
}

Boolean
TextClass::pendingDelete()
{
   Boolean b;
   XtVaGetValues(widget(),XmNpendingDelete, &b, NULL);
   return b;
}

void
TextClass::resizeHeight(Boolean b)
{
   XtVaSetValues(widget(),XmNresizeHeight, b, NULL);
}

Boolean
TextClass::resizeHeight()
{
   Boolean b;
   XtVaGetValues(widget(),XmNresizeHeight, &b, NULL);
   return b;
}

void
TextClass::resizeWidth(Boolean b)
{
   XtVaSetValues(widget(),XmNresizeWidth, b, NULL);
}

Boolean
TextClass::resizeWidth()
{
   Boolean b;
   XtVaGetValues(widget(),XmNresizeWidth, &b, NULL);
   return b;
}

void
TextClass::rows(short r)
{
   XtVaSetValues(widget(),XmNrows, r, NULL);
}

short
TextClass::rows()
{
   short r;
   XtVaGetValues(widget(),XmNrows, &r, NULL);
   return r;
}

void
TextClass::selectionArray(XmTextScanType *p)
{
   XtVaSetValues(widget(),XmNselectionArray, p, NULL);
}

XmTextScanType *
TextClass::selectionArray()
{
   XmTextScanType *s;
   XtVaGetValues(widget(),XmNselectionArray, &s, NULL);
   return s;
}

void
TextClass::selectionArrayCount(int cnt)
{
   XtVaSetValues(widget(),XmNselectionArrayCount, cnt, NULL);
}

int
TextClass::selectionArrayCount()
{
   int i;
   XtVaGetValues(widget(),XmNselectionArrayCount, &i, NULL);
   return i;
}

void
TextClass::selectThreshold(int s)
{
   XtVaSetValues(widget(),XmNselectThreshold, s, NULL);
}

int
TextClass::selectThreshold()
{
   int i;
   XtVaGetValues(widget(),XmNselectThreshold, &i, NULL);
   return i;
}

void 
TextClass::source(XmTextSource s)
{
   XtVaSetValues(widget(),XmNsource,s, NULL);
}

XmTextSource
TextClass::source()
{
   XmTextSource s;
   XtVaGetValues(widget(),XmNsource, &s, NULL);
   return s;
}

void 
TextClass::topCharacter(XmTextPosition p)
{
   XtVaSetValues(widget(),XmNtopCharacter,p, NULL);
}

XmTextPosition
TextClass::topCharacter()
{
   XmTextPosition p;
   XtVaGetValues(widget(),XmNtopCharacter,&p, NULL);
   return p;
}

void 
TextClass::value(_XtString v)
{
   XtVaSetValues(widget(),XmNvalue,v, NULL);
}

_XtString
TextClass::value()
{
   _XtString s;
   XtVaGetValues(widget(),XmNvalue, &s, NULL);
   return s;
}

void 
TextClass::valueWcs(wchar_t *v)
{
   XtVaSetValues(widget(),XmNvalueWcs, v, NULL);
}

wchar_t *
TextClass::valueWcs()
{
   wchar_t *w;
   XtVaGetValues(widget(),XmNvalueWcs, &w, NULL);
   return w;
}

void 
TextClass::verifyBell(Boolean b)
{
   XtVaSetValues(widget(),XmNverifyBell,b, NULL);
}

Boolean
TextClass::verifyBell()
{
   Boolean b;
   XtVaGetValues(widget(),XmNverifyBell, &b, NULL);
   return b;
}

void 
TextClass::wordWrap(Boolean b)
{
   XtVaSetValues(widget(),XmNwordWrap, b, NULL);
}

Boolean
TextClass::wordWrap()
{
   Boolean b;
   XtVaGetValues(widget(),XmNwordWrap, &b, NULL);
   return b;
}

Text::Text(Widget w_parent, ArgList arglist, Cardinal cnt, _XtString name)
{
   Widget w = createWidget(name, w_parent,arglist, cnt);
   widget(w);
   manage();
}

Text::Text(Widget w_parent, XarmArg &args, _XtString name)
{
   Widget w = createWidget(name, w_parent, args.getArgs(), args.count());
   widget(w);
   manage();
}

Text::Text(_XtString name, Widget w_parent)
{
   Widget w = createWidget(name, w_parent);
   widget(w);
   manage();
}

Widget
ScrolledTextClass::createWidget(_XtString name,
                                Widget w_parent,
                                ArgList arglist,
                                Cardinal cnt)
{
   if(name == NULL || *name == '\0') { name = className(); }
   return XmCreateScrolledText(w_parent, name, arglist, cnt);
}

ScrolledText::ScrolledText(Widget w_parent,
                           ArgList arglist,
                           Cardinal cnt,
                           _XtString name)
{
   Widget w = createWidget(name, w_parent, arglist, cnt);
   widget(w);
   manage();
}

ScrolledText::ScrolledText(Widget w_parent, XarmArg &args, _XtString name)
{
   Widget w = createWidget(name, w_parent, args.getArgs(), args.count());
   widget(w);
   manage();
}

ScrolledText::ScrolledText(_XtString name, Widget w_parent)
{
   Widget w = createWidget(name, w_parent);
   widget(w);
   manage();
}
