/*
 Copyright (C) 1996 Peter Williams
 Copyright (C) 1997 Gerald L. Gay

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License
 version 2 as published by the Free Software Foundation.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave,
 Cambridge, MA 02139, USA.
*/

/* Include(s) */
#include <Xarm/PasswordF.h>

void
PasswordField::onInit()
{
   filler = '*';
   PasteEnabled = false;
   addCallback(widget(),XmNmodifyVerifyCallback,(p_msg) onModify);
}

PasswordField::PasswordField(_XtString name, Widget w_parent):
             TextField(name, w_parent)
{
   onInit();
}

PasswordField::PasswordField(Widget w_parent,
                             ArgList arglist,
                             Cardinal cnt,
                             _XtString name):
                             TextField(w_parent, arglist, cnt, name)
{
   onInit();
}


PasswordField::PasswordField(Widget w_parent,
                             XarmArg &args,
                             _XtString name):
                             TextField(w_parent, args, name)
{
   onInit();
}

void
PasswordField::onModify(Widget, XtPointer, XtPointer cdata)
{
   XmTextVerifyCallbackStruct *cbs = (XmTextVerifyCallbackStruct *) cdata;

   if (cbs->reason != XmCR_MODIFYING_TEXT_VALUE) return;

   // If PasteEnabled is false, we only allow
   // single character inserts, deletes and
   // replacements.

   if (!PasteEnabled) {
       if ( (cbs->text->length > 1) ||
            ((cbs->endPos - cbs->startPos) > 1)) {

           cbs->doit = False;
           return;
       }
   }

   passwd.replace(cbs->startPos, cbs->endPos - cbs->startPos,
                  cbs->text->ptr, cbs->text->length);

   for (int x = 0; x < cbs->text->length; x++)
      *(cbs->text->ptr + x) = filler;
}

