/* $Id: ComboBox.C,v 1.4 1997/11/07 14:19:58 glgay Exp $ */
/*
 Copyright (C) 1996 Peter Williams

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave,
 Cambridge, MA 02139, USA.
*/

#include <Xarm/ComboBox.h>

/*
* The ComboBox only exists in versions of Motif >= 2.
* However, you could write one yourself and remove this restriction.
*/
#if XmVERSION >= 2 || HAS_CDE == yes


#if !defined(CB_List)
#if XmVERSION >= 2
#define CB_List(w) \
	(((XmComboBoxWidget)(w))->combo_box.list)
#else
#define CB_List(w) \
	(((DtComboBoxWidget)(w))->combo_box.list)
#endif
#endif

/* callbacks */
void
ComboBoxClass::selectionCallback(XtCallbackProc fp, XtPointer udata)
{
   addCallback(XarmNselectionCallback,fp,udata);
}

/* resources */

#if XmVERSION >= 2

void
ComboBoxClass::arrowSize(Dimension d)
{
   XtVaSetValues(widget(),XmNarrowSize,d,NULL);
}

Dimension
ComboBoxClass::arrowSize()
{
   Dimension d;
   XtVaGetValues(widget(),XmNarrowSize, &d,NULL);
   return d;
}

void
ComboBoxClass::arrowSpacing(Dimension d)
{
   XtVaSetValues(widget(),XmNarrowSpacing,d,NULL);
}

Dimension
ComboBoxClass::arrowSpacing()
{
   Dimension d;
   XtVaGetValues(widget(),XmNarrowSpacing, &d,NULL);
   return d;
}

void
ComboBoxClass::highlightThickness(Dimension d)
{
   XtVaSetValues(widget(),XmNhighlightThickness,d,NULL);
}

Dimension
ComboBoxClass::highlightThickness()
{
   Dimension d;
   XtVaGetValues(widget(),XmNhighlightThickness, &d,NULL);
   return d;
}

void
ComboBoxClass::fontList(XmFontList fl)
{
   XtVaSetValues(widget(),XmNfontList, fl, NULL);
}

XmFontList
ComboBoxClass::fontList()
{
   XmFontList f;
   XtVaGetValues(widget(),XmNfontList, &f, NULL);
   return f;
}

void
ComboBoxClass::matchBehavior(unsigned char c)
{
   XtVaSetValues(widget(), XmNmatchBehavior, c, NULL);
}

unsigned char
ComboBoxClass::matchBehavior()
{
   unsigned char c;
   XtVaGetValues(widget(), XmNmatchBehavior, &c, NULL);
   return c;
}

void
ComboBoxClass::renderTable(XmRenderTable t)
{
   XtVaSetValues(widget(), XmNrenderTable, t, NULL);
}

XmRenderTable 
ComboBoxClass::renderTable()
{
   XmRenderTable t;
   XtVaGetValues(widget(), XmNrenderTable, &t, NULL);
   return t;
}

#endif /* Motif 2.0 or greater */

unsigned char
ComboBoxClass::comboBoxType()
{
   unsigned char c;
   XtVaGetValues(widget(),XarmNcomboBoxType, &c,NULL);
   return c;
}

void
ComboBoxClass::marginHeight(Dimension h)
{
   XtVaSetValues(widget(),XmNmarginHeight,h, NULL);
}

Dimension
ComboBoxClass::marginHeight()
{
   Dimension d;
   XtVaGetValues(widget(),XmNmarginHeight, &d, NULL);
   return d;
}

void
ComboBoxClass::marginWidth(Dimension w)
{
   XtVaSetValues(widget(),XmNmarginWidth,w, NULL);
}

Dimension
ComboBoxClass::marginWidth()
{
   Dimension d;
   XtVaGetValues(widget(),XmNmarginWidth, &d, NULL);
   return d;
}

void
ComboBoxClass::selectedItem(char *s)
{
   XmString xmstr = cvtStringToXmString(s);
   XtVaSetValues(widget(), XarmNselectedItem, xmstr, NULL);
   XmStringFree(xmstr);
}

char *
ComboBoxClass::selectedItem()
{
   XmString xmstr;
   XtVaGetValues(widget(), XarmNselectedItem, &xmstr, NULL);
   return cvtXmStringToString(xmstr);
}

void
ComboBoxClass::selectedPosition(int i)
{
   XtVaSetValues(widget(), XarmNselectedPosition, i, NULL);
}

int
ComboBoxClass::selectedPosition()
{
   int i;
   XtVaGetValues(widget(), XarmNselectedPosition, &i, NULL);
   return i;
}

Widget
ComboBoxClass::createWidget(_XtString name,
                       Widget w_parent,
                       ArgList arglist,
                       Cardinal cnt)
{
   if(name == NULL || *name == '\0') { name = className(); }
#if XmVERSION >= 2
   return XmCreateComboBox(w_parent, name, arglist, cnt);
#else
   return DtCreateComboBox(w_parent, name, arglist, cnt);
#endif
}

ComboBox::ComboBox(Widget w_parent,
            ArgList arglist, 
            Cardinal cnt,
            _XtString name)
{
   Widget w = createWidget(name, w_parent,arglist,cnt);
   widget(w);
   manage();
}

ComboBox::ComboBox(Widget w_parent, XarmArg &args, _XtString name)
{
   Widget w = createWidget(name, w_parent, args.getArgs(), args.count());
   widget(w);
   manage();
}

ComboBox::ComboBox(_XtString name, Widget w_parent)
{
   Widget w = createWidget(name, w_parent);
   widget(w);
   manage();
}

#if XmVERSION >= 2
Widget
DropDownList::createWidget(_XtString name,
                       Widget w_parent,
                       ArgList arglist,
                       Cardinal cnt)
{
   if(name == NULL || *name == '\0') { name = className(); }
   return XmCreateDropDownList(w_parent, name, arglist, cnt);
}

DropDownList::DropDownList(Widget w_parent,
            ArgList arglist, 
            Cardinal cnt,
            _XtString name)
{
   Widget w = createWidget(name, w_parent,arglist,cnt);
   widget(w);
   manage();
}

DropDownList::DropDownList(Widget w_parent, XarmArg &args, _XtString name)
{
   Widget w = createWidget(name, w_parent, args.getArgs(), args.count());
   widget(w);
   manage();
}

DropDownList::DropDownList(_XtString name, Widget w_parent)
{
   Widget w = createWidget(name, w_parent);
   widget(w);
   manage();
}

Widget
DropDownComboBox::createWidget(_XtString name,
                       Widget w_parent,
                       ArgList arglist,
                       Cardinal cnt)
{
   if(name == NULL || *name == '\0') { name = className(); }
   return XmCreateDropDownComboBox(w_parent, name, arglist, cnt);
}

DropDownComboBox::DropDownComboBox(Widget w_parent,
            ArgList arglist, 
            Cardinal cnt,
            _XtString name)
{
   Widget w = createWidget(name, w_parent,arglist,cnt);
   widget(w);
   manage();
}

DropDownComboBox::DropDownComboBox(Widget w_parent, XarmArg &args, _XtString name)
{
   Widget w = createWidget(name, w_parent, args.getArgs(), args.count());
   widget(w);
   manage();
}

DropDownComboBox::DropDownComboBox(_XtString name, Widget w_parent)
{
   Widget w = createWidget(name, w_parent);
   widget(w);
   manage();
}

#endif /* Motif 2.0 or greater */

/* convenience routines */
Widget
ComboBoxClass::list()
{
#if XmVERSION >= 2
   return (Widget) CB_List(widget());
#else
   return XtNameToWidget(widget(), "*List");
#endif
}

void
ComboBoxClass::update()
{
#if XmVERSION >= 2
   XmComboBoxUpdate(widget());
#endif
}
   
/* extras */
/* This is how you wrap existing widgets. */
class WrapList : public ListClass {
 public:
   WrapList(Widget w) { widget(w); }  
};

ListClass *
ComboBoxClass::listObject()
{
   ListClass *foo; 

   foo = (ListClass *) WidgetToWObject(list());   
   if (foo == NULL)
   {  /* then no wrap yet so wrap it */
      foo = new WrapList(list());
   }
   return foo;
}

#endif

