/* $Id: adt.h,v 1.1.1.1 1997/03/19 13:32:20 glgay Exp $ */
/*
 Copyright (C) 1991-1996 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/
/*
*  File: adt.h
*  Author: Peter G. Williams
*  Date: 12/15/91
*/

#ifndef _XARM_ADT_H_
#define _XARM_ADT_H_

/* Node for data structures */
class ArmNode {
   public:
      virtual ~ArmNode() {}
      virtual ArmNode* duplicate () = 0;
      /* compare must return 0 on match */
      virtual int compare(ArmNode *other) = 0;
      virtual char *isa() { return "ArmNode"; } 
};

/* Binary Tree */
class ArmBinaryTree {
   private:
      ArmNode *symbol;
      ArmBinaryTree *left, *right;

   public:
      /* 
       * Returns the new node on successful or NULL on failure.
       */
      const ArmNode *add(ArmNode *s); 
      /* 
       * Returns the node in the tree on successful or NULL on failure.
       */
      const ArmNode *find(ArmNode *e);

      ArmBinaryTree(ArmNode *s=NULL);
      virtual ~ArmBinaryTree();
};

/* List */ 
class ArmList {
   private:
      ArmNode *symbol;
      ArmList *left, *right;

      ArmList *find_node(ArmNode *e);
   public:
      /* 
       * Returns the new node on successful or NULL on failure.
       */
      const ArmNode *add(ArmNode *e);
      /* 
       * Returns the node in the tree on successful or NULL on failure.
       */
      const ArmNode *find(ArmNode *e);
      /*
       * Removes the entry from the list or does nothing if not found.
       */
      void remove(ArmNode *e);  

      ArmList(ArmNode *s=NULL);
      virtual ~ArmList();
};
      
#endif
