/* $Id: Text.h,v 1.2 1997/04/07 15:33:23 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(_XARM_TEXT_H_)
#define _XARM_TEXT_H_

/* ======================================================================= */
/* Include(s): */
#include <Xarm/Primitive.h>

class TextClass : public PrimitiveClass {
 protected:
   TextClass() {}
   virtual WidgetClass classPointer() { return xmTextWidgetClass; }
   virtual _XtString className() { return (_XtString) "XmText"; }
 public:
   /* callbacks */
   void activateCallback(XtCallbackProc funcp, XtPointer data = NULL);
   void focusCallback(XtCallbackProc funcp, XtPointer data = NULL);
   void gainPrimaryCallback(XtCallbackProc funcp, XtPointer data = NULL);
   void losePrimaryCallback(XtCallbackProc funcp, XtPointer data = NULL);
   void losingFocusCallback(XtCallbackProc funcp, XtPointer data = NULL);
   void modifyVerifyCallback(XtCallbackProc funcp, XtPointer data = NULL);
   void modifyVerifyCallbackWcs(XtCallbackProc funcp, XtPointer data = NULL);
   void motionVerifyCallback(XtCallbackProc funcp, XtPointer data = NULL);
   void valueChangedCallback(XtCallbackProc funcp, XtPointer data = NULL);

   /* convient functions */
   void clearSelection(Time time);
   Boolean copy(Time t);
   Boolean cut(Time t);
   void disableRedisplay();
   void enableRedisplay();
   Boolean findString(XmTextPosition start, char *str, 
                         XmTextDirection direction, XmTextPosition *pos);
   Boolean findStringWcs(XmTextPosition start, wchar_t *wcs, 
                         XmTextDirection direction, XmTextPosition *pos);
   int getBaseline();
   XmTextPosition getCursorPosition();
   Boolean getEditable();
   XmTextPosition getInsertionPosition();
   XmTextPosition getLastPosition();
   int getMaxLength();
   char *getSelection();
   Boolean getSelectionPosition(XmTextPosition *left, XmTextPosition *right);
   wchar_t *getSelectionWcs();
   XmTextSource getSource();
   char *getString();
   wchar_t *getStringWcs();
   int getSubstring(XmTextPosition start, int no_chars, int buf_sz, char *buf);
   int getSubstringWcs(XmTextPosition start, int no_chars, int buf_sz, 
                       wchar_t *buf);
   XmTextPosition getTopCharacter();
   void insert(XmTextPosition pos, char *str);
   void insertWcs(XmTextPosition pos, wchar_t *str);
   Boolean paste();
   Boolean posToXY(XmTextPosition pos, Position *xpos, Position *ypos);
   Boolean remove();
   void replace(XmTextPosition from, XmTextPosition to, char *val);
   void replaceWcs(XmTextPosition from, XmTextPosition to, wchar_t *val);
   void scroll(int lines);
   void setAddMode(Boolean state);
   void setCursorPosition(XmTextPosition pos);
   void setEditable(Boolean edit);
   void setHighlight(XmTextPosition left, XmTextPosition right,
                     XmHighlightMode mode);
   void setInsertionPosition(XmTextPosition pos);
   void setMaxLength(int max);
   void setSelection(XmTextPosition first, XmTextPosition last,
                     Time t);
   void setSource(XmTextSource src, XmTextPosition top, XmTextPosition cursor);
   void setString(char *str);
   void setStringWcs(wchar_t *str);
   void setTopCharacter(XmTextPosition top);
   void showPosition(XmTextPosition pos);
   XmTextPosition xyToPos(Position xpos, Position ypos);

   /* resources */
   void autoShowCursorPosition(Boolean);
   Boolean autoShowCursorPosition();
   void blinkRate(int);
   int blinkRate();
   void columns(short);
   short columns();
   void cursorPosition(XmTextPosition);
   XmTextPosition cursorPosition();
   void cursorPositionVisible(Boolean);
   Boolean cursorPositionVisible();
   void editable(Boolean);
   Boolean editable();
   void editMode(int);
   int editMode();
   void fontList(XmFontList);
   XmFontList fontList();
   void marginHeight(Dimension);
   Dimension marginHeight();
   void marginWidth(Dimension);
   Dimension marginWidth();
   void maxLength(int);
   int maxLength();
   void pendingDelete(Boolean);
   Boolean pendingDelete();
   void resizeHeight(Boolean);
   Boolean resizeHeight();
   void resizeWidth(Boolean);
   Boolean resizeWidth();
   void rows(short);
   short rows();
   void selectionArray(XmTextScanType *);
   XmTextScanType *selectionArray();
   void selectionArrayCount(int);
   int selectionArrayCount();
   void selectThreshold(int);
   int selectThreshold();
   void source(XmTextSource);
   XmTextSource source();
   void topCharacter(XmTextPosition);
   XmTextPosition topCharacter();
   void value(_XtString);
   _XtString value();
   void valueWcs(wchar_t *);
   wchar_t *valueWcs();
   void verifyBell(Boolean);
   Boolean verifyBell();
   void wordWrap(Boolean);
   Boolean wordWrap();
};

class ScrolledTextClass : public TextClass {
 protected:
   virtual Widget createWidget(_XtString name, 
                               Widget w_parent,
                               ArgList arglist = NULL,
                               Cardinal cnt = 0);
   ScrolledTextClass() {}
 public:
   void scrollHorizontal(Boolean);
   Boolean scrollHorizontal();
   void scrollLeftSide(Boolean);
   Boolean scrollLeftSide();
   void scrollTopSide(Boolean);
   Boolean scrollTopSide();
   void scrollVertical(Boolean);
   Boolean scrollVertical();
};

class Text : public TextClass {
 public:
   Text(Widget w_parent, 
        ArgList arglist = NULL,
        Cardinal cnt = 0,
        _XtString name = NULL);
   Text(_XtString name, Widget w_parent);
   Text(Widget w_parent, XarmArg &args, _XtString name);
};

class ScrolledText : public ScrolledTextClass {
 public:
   ScrolledText(Widget w_parent,
                ArgList arglist = NULL,
                Cardinal cnt = 0,
                _XtString name = NULL);
   ScrolledText(_XtString name, Widget w_parent);
   ScrolledText(Widget w_parent, XarmArg &args, _XtString name);
};


#endif
