/* $Id: SelectioB.h,v 1.2 1997/04/07 15:33:22 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(_XARM_SELECTIOB_H_)
#define _XARM_SELECTIOB_H_

/* ======================================================================= */
/* Include(s): */
#include <Xarm/BulletinB.h>

class SelectionBoxClass : public BulletinBoardClass {
 protected:
   SelectionBoxClass() {}
   virtual WidgetClass classPointer() { return xmSelectionBoxWidgetClass; }
   virtual _XtString className() { return (_XtString) "XmSelectionBox"; }
 public:
   /* callbacks */
   void applyCallback(XtCallbackProc funcp, XtPointer data = NULL);
   void cancelCallback(XtCallbackProc funcp, XtPointer data = NULL);
   void noMatchCallback(XtCallbackProc funcp, XtPointer data = NULL);
   void okCallback(XtCallbackProc funcp, XtPointer data = NULL);

   /* convenience routines */
   virtual Widget getChild(unsigned char);

   /* resources */
   void applyLabelString(char *);
   char *applyLabelString();
   void cancelLabelString(char *);
   char *cancelLabelString();
   void childPlacement(unsigned char);
   unsigned char childPlacement();
   void dialogType(unsigned char);
   unsigned char dialogType();
   void helpLabelString(char *);
   char *helpLabelString();
   void listItemCount(int);
   int listItemCount();
   void listItems(XmStringTable);
   XmStringTable listItems();
   void listLabelString(char *);
   char *listLabelString();
   void listVisibleItemCount(int);
   int listVisibleItemCount();
   void minimizeButtons(Boolean);
   Boolean minimizeButtons();
   void mustMatch(Boolean);
   Boolean mustMatch();
   void okLabelString(char *);
   char *okLabelString();
   void selectionLabelString(char *str);
   char *selectionLabelString();
   void textColumns(short);
   short textColumns();
   void textString(char *str);
   char *textString();
};

class SelectionBox : public SelectionBoxClass {
 protected:
   virtual Widget createWidget(_XtString name,
                               Widget w_parent,
                               ArgList arglist = NULL,
                               Cardinal cnt = 0);
 public:
   SelectionBox(Widget w_parent, 
                ArgList arglist = NULL,
                Cardinal cnt = 0,
                _XtString name = NULL);
   SelectionBox(_XtString name, Widget w_parent);
   SelectionBox(Widget w_parent, XarmArg &args, _XtString name);
};

class SelectionDialog : public SelectionBoxClass {
 protected:
   virtual Widget createWidget(_XtString name,
                               Widget w_parent,
                               ArgList arglist = NULL,
                               Cardinal cnt = 0);
 public:
   SelectionDialog(Widget w_parent,
                   ArgList arglist = NULL,
                   Cardinal cnt = 0,
                   _XtString name = NULL);
   SelectionDialog(_XtString name, Widget w_parent);
   SelectionDialog(Widget w_parent, XarmArg &args, _XtString name);
};

class PromptDialog : public SelectionBoxClass {
 protected:
   virtual Widget createWidget(_XtString name,
                               Widget w_parent,
                               ArgList arglist = NULL,
                               Cardinal cnt = 0);
 public:
   PromptDialog(Widget w_parent, char *mesg, _XtString name = NULL);
   PromptDialog(Widget w_parent,
                ArgList arglist = NULL,
                Cardinal cnt = 0,
                _XtString name = NULL);
   PromptDialog(_XtString name, Widget w_parent);
   PromptDialog(Widget w_parent, XarmArg &args, _XtString name);
};

#endif
