/* $Id: PanedW.h,v 1.2 1997/04/07 15:33:21 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(_XARM_PANEDW_H_)
#define _XARM_PANEDW_H_

/* ======================================================================= */
/* Include(s): */
#include <Xarm/Manager.h>

class PanedWindowClass : public ManagerClass {
 protected:
   PanedWindowClass() {}
   virtual WidgetClass classPointer() { return xmPanedWindowWidgetClass; }
   virtual _XtString className() { return (_XtString) "XmPanedWindow"; }
 public:
   /* resources */
   void marginHeight(Dimension);
   Dimension marginHeight();
   void marginWidth(Dimension);
   Dimension marginWidth();
   void refigureMode(Boolean);
   Boolean refigureMode();
   void sashHeight(Dimension);
   Dimension sashHeight();
   void sashIndent(Position);
   Position sashIndent();
   void sashShadowThickness(Dimension);
   Dimension sashShadowThickness();
   void sashWidth(Dimension);
   Dimension sashWidth();
   void separatorOn(Boolean);
   Boolean separatorOn();
   void spacing(Dimension);
   Dimension spacing();
   
};

class PanedWindow : public PanedWindowClass {
 public:
   PanedWindow(Widget w_parent,
               ArgList arglist = NULL,
               Cardinal cnt = 0,
               _XtString name = NULL);
   PanedWindow(_XtString name, Widget w_parent);
   PanedWindow(Widget w_parent, XarmArg &args, _XtString name);
};

#endif
