/* $Id: Page.h,v 1.2 1997/04/07 15:33:20 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(_XARM_PROPERTY_PAGE_H_)
#define _XARM_PROPERTY_PAGE_H_

/*
 * Warning:  These classes diverge from the Motif 1.2 standard GUI and 
 * use widgets written by the author.
 */

/* ======================================================================= */
/* Include(s): */
#include <Xmext/Page.h>
#include <Xarm/BulletinB.h>

class PropertyPageClass : public BulletinBoardClass {
 protected:
   PropertyPageClass() {} /* only a derived class can make this */
   virtual WidgetClass classPointer() { return xmPropertyPageWidgetClass; }
   virtual _XtString className() { return (_XtString) "XmPropertyPage"; }
   virtual Widget createWidget(_XtString name,
                               Widget w_parent,
                               ArgList arglist = NULL,
                               Cardinal cnt = 0);
 public:

   /* Callbacks */
   /* activate callbacks for the following default buttons */
   void cancelCallback(XtCallbackProc fp, XtPointer udata = NULL);
   void okCallback(XtCallbackProc fp, XtPointer udata = NULL);
   void applyCallback(XtCallbackProc fp, XtPointer udata = NULL);

   /* Called when the current page is no longer active. */
   void killActiveCallback(XtCallbackProc fp, XtPointer udata = NULL);
   /* Called when the page is made the active page. */
   void setActiveCallback(XtCallbackProc fp, XtPointer udata = NULL);

   /* extras */
   void setModified(Boolean b = TRUE); /* enable or disable apply button */
   void cancelLabelString(char *s);  /* changes text of cancel button */
   
};

class PropertyPage : public PropertyPageClass {
 public:
   PropertyPage(Widget w_parent, 
                 ArgList arglist = NULL, 
                 Cardinal cnt = 0, 
                 _XtString name = NULL);
   PropertyPage(_XtString name, Widget w_parent); 
   PropertyPage(Widget w_parent, XarmArg &args, _XtString name);
};

#endif
