/* $Id: MainW.h,v 1.2 1997/04/07 15:33:20 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(_XARM_MAINW_H_)
#define _XARM_MAINW_H_

/* ======================================================================= */
/* Include(s): */
#include <Xarm/ScrolledW.h>

class MainWindowClass : public ScrolledWindowClass {
 protected:
   MainWindowClass() {}
   virtual WidgetClass classPointer() { return xmMainWindowWidgetClass; }
   virtual _XtString className() { return (_XtString) "XmMainWindow"; }
 public:
   /* convenience routines */
   Widget separator1();
   Widget separator2();
   Widget separator3();
   void setArea(Widget menu,Widget command,
		Widget hscroll, Widget vscroll,
		Widget work);

   /* resources */
   void commandWindow(Widget);
   Widget commandWindow();
   unsigned char commandWindowLocation();
   void mainWindowMarginHeight(Dimension);
   Dimension mainWindowMarginHeight();
   void mainWindowMarginWidth(Dimension);
   Dimension mainWindowMarginWidth();
   void menuBar(Widget);
   Widget menuBar();
   void messageWindow(Widget);
   Widget messageWindow();
   void showSeparator(Boolean);
   Boolean showSeparator();
};

class MainWindow : public MainWindowClass {
 public:
   MainWindow(Widget w_parent, 
              unsigned char scroll_policy,
              Boolean show_separator = FALSE,
              _XtString name = NULL);
   MainWindow(Widget w_parent, 
              Dimension width, 
              Dimension height,
              unsigned char scroll_policy = XmAPPLICATION_DEFINED,
              Boolean show_separator = FALSE,
              _XtString name = NULL);
   MainWindow(Widget w_parent, 
              ArgList arglist = NULL, 
              Cardinal cnt = 0,
              _XtString name = NULL);
   MainWindow(_XtString name, Widget w_parent); 
   MainWindow(Widget w_parent, XarmArg &args, _XtString name);
};
   
#endif
