/* $Id: List.h,v 1.3 1997/04/07 15:33:19 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(_XARM_LIST_H_)
#define _XARM_LIST_H_

/* ======================================================================= */
/* Include(s): */
#include <Xarm/Primitive.h>

class ListClass : public PrimitiveClass {
 protected:
   ListClass() {} 
   virtual WidgetClass classPointer() { return xmListWidgetClass; }
   virtual _XtString className() { return (_XtString) "XmList"; }
 public:
   /* callbacks */
   void browseSelectionCallback(XtCallbackProc, XtPointer);
   void defaultActionCallback(XtCallbackProc, XtPointer);
   void extendedSelectionCallback(XtCallbackProc, XtPointer);
   void multipleSelectionCallback(XtCallbackProc, XtPointer);
   void singleSelectionCallback(XtCallbackProc, XtPointer);

   /* convenience routines */

   /* resources */
   void automaticSelection(Boolean);
   Boolean automaticSelection();
   void doubleClickInterval(int);
   int doubleClickInterval();
   void fontList(XmFontList);
   XmFontList fontList();
   void itemCount(int);
   int itemCount();
   void items(XmStringTable);
   XmStringTable items();
   void listMarginHeight(Dimension);
   Dimension listMarginHeight();
   void listMarginWidth(Dimension);
   Dimension listMarginWidth();
   unsigned char listSizePolicy();
   void listSpacing(Dimension);
   Dimension listSpacing();
   void scrollBarDisplayPolicy(unsigned char);
   unsigned char scrollBarDisplayPolicy();
   void selectedItemCount(int);
   int selectedItemCount(); 
   void selectedItems(XmStringTable);
   XmStringTable selectedItems();
   void selectionPolicy(unsigned char);
   unsigned char selectionPolicy();
   void stringDirection(XmStringDirection);
   XmStringDirection stringDirection();
   void topItemPosition(int);
   int topItemPosition();
   void visibleItemCount(int);
   int visibleItemCount();

   /* extra functionality */
   void add(char *);  /* adds an item to the list box */
   void add(char ** l, int c); /* [][]= { "foo","yo" }; */
   void clear();     /* clears out the list box */
   int count();      /* returns the count of the items in the list */
   void del(int);     /* deletes an item at position p */
   void del(int n,int p); /* deletes n items starting at position p */
   void del(char *);
   void del(char **, int); /* [][]= { "foo","yo" }; */
   void deselect(const char *);
   void deselect(int);
   int exists(const char *); /* does the item exists in the list */
   void insert(char * s, int p);  /* inserts an item at a location */
   void insert(char ** l, int c, int p); /* [][]= {"foo","yo" }; */
   int item(const char *s); /* returns the position of s */
   void horizontal(int); /* position of the scroll bar */
   int match(char *item, int *&p, int &c); 
   void replace(char **n, int c, int p);
   void replace(char **o, int c, char **n); /* replace old items w/ new */
   Boolean selected(int *&, int &);  /* returns the selected items, delete array */
   void select(const char *s, int notify); /* selects the item in the list */
   void select(int p, int notify); /* selects the item at that position */
   void set(char *); /* sets the item to be the first visible item if posible */
   void set(int); /* sets the item to be the first visible item if posible */
   void setBottom(char *);
   void setBottom(int);
   
};

class List : public ListClass {
 public:
   List(Widget w_parent,
        ArgList arglist = NULL,
        Cardinal = 0,
        _XtString name = NULL);
   List(_XtString name, Widget w_parent);
   List(Widget w_parent, XarmArg &args, _XtString name);
};

class ScrolledList : public ListClass {
 protected:
   virtual Widget createWidget(_XtString name,
                               Widget w_parent,
                               ArgList arglist = NULL,
                               Cardinal cnt = 0);
 public:
   ScrolledList(Widget w_parent,
        ArgList arglist = NULL,
        Cardinal = 0,
        _XtString name = NULL);
  ScrolledList(_XtString name, Widget w_parent);
  ScrolledList(Widget w_parent, XarmArg &args, _XtString name);
};

#endif
