/* $Id: DragDrop.h,v 1.1.1.1 1997/03/19 13:32:20 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(_XARM_DRAGDROP_H_)
#define _XARM_DRAGDROP_H_

/* ======================================================================= */
/* Include(s): */
#include <Xarm/Core.h>

class DragContextClass : public CoreClass {
 protected:
   DragContextClass() {} /* only a derived class can make this */
 
   virtual WidgetClass classPointer() { return xmDragContextClass; }
   virtual _XtString className() { return (_XtString) "XmDragContext"; }
 public:
   /* callbacks */
   void dragDropFinishCallback(XtCallbackProc, XtPointer);
   void dragMotionCallback(XtCallbackProc, XtPointer);
   void dropFinishCallback(XtCallbackProc, XtPointer);
   void dropSiteEnterCallback(XtCallbackProc, XtPointer);
   void dropSiteLeaveCallback(XtCallbackProc, XtPointer);
   void dropStartCallback(XtCallbackProc, XtPointer);
   void operationChangedCallback(XtCallbackProc, XtPointer);
   void topLevelEnterCallback(XtCallbackProc, XtPointer);
   void topLevelLeaveCallback(XtCallbackProc, XtPointer);

   /* resources */
   unsigned char blendModel();
   void clientData (XtPointer);
   XtPointer clientData();
   void convertProc(XtConvertSelectionIncrProc);
   XtConvertSelectionIncrProc convertProc();
   void cursorBackground(Pixel);
   Pixel cursorBackground();
   void cursorForeground(Pixel);
   Pixel cursorForeground();
   void exportTargets(Atom *);
   Atom *exportTargets();
   void incremental(Boolean);
   Boolean incremental();
   void invalidCursorForeground(Pixel);
   Pixel invalidCursorForeground();
   void noneCursorForeground(Pixel);
   Pixel noneCursorForeground();
   void numExportTargets(Cardinal);
   Cardinal numExportTargets();
   void operationCursorIcon(Widget);
   Widget operationCursorIcon();
   void sourceCursorIcon(Widget);
   Widget sourceCursorIcon();
   void sourcePixmapIcon(Widget);
   Widget sourcePixmapIcon();
   void stateCursorIcon(Widget);
   Widget stateCursorIcon();
   void validCursorForeground(Pixel);
   Pixel validCursorForeground();
};

class DragIconClass : public _ObjectClass {
 protected:
   DragIconClass() {}     

   virtual WidgetClass classPointer() { return xmDragIconObjectClass; }
   virtual _XtString className() { return (_XtString) "XmDragIcon"; }
 public:
   /* resources */
   void attachment(unsigned char);
   unsigned char attachment();
   void depth(int);
   int depth();
   void height(Dimension);
   Dimension height();
   void hotX(Position);
   Position hotX();
   void hotY(Position);
   Position hotY();
   void mask(Pixmap);
   Pixmap mask();
   void offsetX(Position);
   Position offsetX();
   void offsetY(Position);
   Position offsetY();
   void pixmap(Pixmap);
   Pixmap pixmap();
   void width(Dimension);
   Dimension width();
};

class DropTransferClass : public _ObjectClass 
{
 protected:
   DropTransferClass() {}
 public:
   /* resources */
   XmDropTransferEntryRec *dropTransfers();
   void incremental(Boolean);
   Boolean incremental();
   void numDropTransfers(Cardinal);
   Cardinal numDropTransfers();
   void transferProc(XtSelectionCallbackProc);
   XtSelectionCallbackProc transferProc();
   void transferStatus(unsigned char);
   unsigned char transferStatus();
};

#endif
