/* $Id: ComboBox.h,v 1.3 1997/11/07 14:19:49 glgay Exp $ */
/*
 Copyright (C) 1996 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(_XARM_COMBOBOX_H_)
#define _XARM_COMBOBOX_H_

/* ======================================================================= */
/* Include(s): */

#include <Xarm/Manager.h>

/* 
* The ComboBox only exists in versions of Motif >= 2. 
* However, you could write one yourself and remove this restriction.  
*/

#if XmVERSION >= 2  || HAS_CDE == yes

#if XmVERSION >= 2
#include <Xm/ComboBoxP.h>
#else
#include <Dt/ComboBox.h>
#endif
#include <Xarm/List.h>

#if XmVERSION >= 2

#define XarmNselectionCallback XmNselectionCallback
#define XarmNcomboBoxType      XmNcomboBoxType
#define XarmNselectedItem      XmNselectedItem
#define XarmNselectedPosition  XmNselectedPosition

#else

#define XarmNselectionCallback DtNselectionCallback
#define XarmNcomboBoxType      DtNcomboBoxType
#define XarmNselectedItem      DtNselectedItem
#define XarmNselectedPosition  DtNselectedPosition

#endif

class ComboBoxClass : public ManagerClass {
 protected:
   ComboBoxClass() {} /* only a derived class can make this */
#if XmVERSION >= 2
   virtual WidgetClass classPointer() { return xmComboBoxWidgetClass; }
   virtual _XtString className() { return (_XtString) "XmComboBox"; }
#else
   virtual WidgetClass classPointer() { return dtComboBoxWidgetClass; }
   virtual _XtString className() { return (_XtString) "DtComboBox"; }
#endif
   virtual Widget createWidget(_XtString name,
                               Widget w_parent,
                               ArgList arglist = NULL,
                               Cardinal cnt = 0);
 public:
   /* callbacks */
   void selectionCallback(XtCallbackProc fp, XtPointer udata = NULL);

   /* resources */
#if XmVERSION >= 2
   void arrowSize(Dimension);
   Dimension arrowSize();
   void arrowSpacing(Dimension);
   Dimension arrowSpacing();
   void highlightThickness(Dimension);
   Dimension highlightThickness();
   void fontList(XmFontList);
   XmFontList fontList();
   void matchBehavior(unsigned char);
   unsigned char matchBehavior();
   void renderTable(XmRenderTable);
   XmRenderTable renderTable();
#endif
   unsigned char comboBoxType();  /* read only resource after construction */
   void marginHeight(Dimension);
   Dimension marginHeight();
   void marginWidth(Dimension);
   Dimension marginWidth();
   void selectedItem(char *); /* notice this takes char * not XmString */
   char *selectedItem(); /* notice this returns char * not XmString */
   void selectedPosition(int);
   int selectedPosition();

   /* convenience routines */
   Widget list(); /* return list widget */
   void update(); /* update combobox internal structs */
   
   /* extra functionality */
   /* 
    * listObject()
    * This routine returns the list wrapper object for the list widget. 
    * Warning: if you modify anything in this object don't forget to 
    * call the update function.
    */
   ListClass *listObject(); 
   
};

class ComboBox : public ComboBoxClass {
 public:
   ComboBox(Widget p, 
            ArgList arglist = NULL, 
            Cardinal cnt = 0, 
            _XtString name = NULL); 
   ComboBox(_XtString name, Widget p);
   ComboBox(Widget w_parent, XarmArg &args, _XtString name);
};

#if XmVERSION >= 2

class DropDownList : public ComboBoxClass {
 protected:
   virtual Widget createWidget(_XtString name,
                               Widget w_parent,
                               ArgList arglist = NULL,
                               Cardinal cnt = 0);
 public:
   DropDownList(Widget p, 
            ArgList arglist = NULL, 
            Cardinal cnt = 0, 
            _XtString name = NULL); 
   DropDownList(_XtString name, Widget p);
   DropDownList(Widget w_parent, XarmArg &args, _XtString name);
};

class DropDownComboBox : public ComboBoxClass {
 protected:
   virtual Widget createWidget(_XtString name,
                               Widget w_parent,
                               ArgList arglist = NULL,
                               Cardinal cnt = 0);
 public:
   DropDownComboBox(Widget p, 
            ArgList arglist = NULL, 
            Cardinal cnt = 0, 
            _XtString name = NULL); 
   DropDownComboBox(_XtString name, Widget p);
   DropDownComboBox(Widget w_parent, XarmArg &args, _XtString name);
};

#endif

#endif

#endif
