/* $Id: CObject.h,v 1.3 1997/03/24 13:44:59 glgay Exp $ */
/*
 Copyright (C) 1996 Gerald L. Gay
 Copyright (C) 1996 Peter Williams

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave,
 Cambridge, MA 02139, USA.
*/

#if !defined(_XARM_COBJECT_H_)
#define _XARM_COBJECT_H_

/* ======================================================================= */
/* Include(s): */
#include <X11/X.h>
#include <X11/IntrinsicP.h>
#include <X11/Intrinsic.h>
#include <Xm/XmAll.h>

class CObject;

/* Typedef's for member function callbacks */
typedef void (CObject::*p_msg)(Widget, XtPointer, XtPointer);
typedef void (CObject::*p_event_msg)(Widget, XtPointer, XEvent *, Boolean *);
typedef void (CObject::*p_input_msg)(XtPointer, int*, XtInputId*);
typedef void (CObject::*p_timer_msg)(XtPointer, XtIntervalId *);
typedef Boolean (CObject::*p_work_msg)(XtPointer);

/* Standard window manager protocols */
#if !defined(XA_WM_DELETE_WINDOW)
#define XA_WM_DELETE_WINDOW "WM_DELETE_WINDOW"
#endif 
#if !defined(XA_WM_SAVE_YOURSELF)
#define XA_WM_SAVE_YOURSELF "WM_SAVE_YOURSELF"
#endif 
#if !defined(XA_WM_TAKE_FOCUS)
#define XA_WM_TAKE_FOCUS "WM_TAKE_FOCUS"
#endif 

/* Non-standard window manager messages */
/* T.B.W. */

/* Callable object */
class CObject {
 private:

 public:
   CObject();
   virtual ~CObject();

   /* the widget callback routines */
   void addCallback(Widget w,
                    _XtString type,
                    p_msg fp,
                    XtPointer closure=NULL);
   void removeCallback(Widget w,
                       _XtString type,
                       p_msg fp,
                       XtPointer closure=NULL);
   void removeAllCallbacks(Widget w, _XtString type);

   /* protocol callback routines */
   void addProtocolCallback(Widget w,
                            Atom property,
                            Atom proto_atom,
                            p_msg fp,
                            XtPointer closure=NULL);

   void removeProtocolCallback(Widget w,
                            Atom property,
                            Atom proto_atom,
                            p_msg fp,
                            XtPointer closure=NULL);

   void addWMProtocolCallback(Widget w,
                            Atom protocol,
                            p_msg fp,
                            XtPointer closure=NULL);

   void removeWMProtocolCallback(Widget w,
                            Atom protocol,
                            p_msg fp,
                            XtPointer closure=NULL);

   /* application callback routines */
   XtWorkProcId addWorkProc(XtAppContext ac, 
                            p_work_msg fp, 
                            XtPointer closure=NULL); 

   void removeWorkProc(XtWorkProcId id);

   XtIntervalId addTimeOut(XtAppContext ac,
                           unsigned long interval,
                           p_timer_msg fp,
                           XtPointer closure=NULL); 

   void removeTimeOut(XtIntervalId id);

   XtInputId addInput(XtAppContext ac,
                      int source,
                      XtPointer condition,
                      p_input_msg fp,
                      XtPointer closure=NULL); 

   void removeInput(XtInputId id);

   /* According to the comments in Intrinsic.h (X11R6) _XtBoolean is private
      to the Xt implementation and must not be used in client code.
      Then why did they use it as a type in a public function? 
    */
   void addEventHandler(Widget w,
                        EventMask event_mask,
                        _XtBoolean nomaskable,
                        p_event_msg fp,
                        XtPointer closure=NULL);

   void removeEventHandler(Widget w,
                        EventMask event_mask,
                        _XtBoolean nomaskable,
                        p_event_msg fp,
                        XtPointer closure=NULL);
};

#endif
